<?php
session_start();
?>
<!doctype html>
<html lang="ar" dir="ltr">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">



    <title>Form Validation with captcha using jquery Validation and PHP</title>
    <style>
        .error{
            color:red;
        }
    </style>
</head>

<body>


    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <h1>Jquery validation and PHP </h1>
                <form id="cnt_myform" method="post" >
                    <div class="form-group mb-3">
                        <label for="exampleInputEmail1" class="form-label">Name</label>
                        <input class="form-control" type="text" name="name" id="name" required>
                    </div>
                    <div class="form-group mb-3">
                        <label for="exampleInputEmail1" class="form-label">Email </label>
                        <input class="form-control" type="email" name="email" id="email" required>
                    </div>
                    <div class="form-group mb-3">
                        <label for="mobile" class="form-label">Contact </label>
                        <input class="form-control" type="text" name="mobile" id="mobile" required>
                    </div>

                    <div class="form-group mb-3">
                        <label for="exampleInputEmail1" class="form-label">Gender</label>
                        <select class="form-control" name="gender" id="gender" required>
                            <option value="">Select Gender</option>
                            <option value="male">Male</option>
                            <option value="female">Female</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    <div class="mb-3 ">
                        <input type="checkbox"  name="terms" id="terms" required>
                        <label class="form-check-label" for="terms">I accept the terms and conditions</label>
                    </div>

                    <div class="form-group">
                        <div class="row">
                            <div class="col-lg-4">
                            <label for="captcha_text" class="form-label">Enter Captcha</label>
                                <input type="text" id="captcha_text" name="captcha_text" class="form-control" required>
                            </div>
                            <div class="col-lg-2" style="margin-top:32px;">
                            <img id="captcha" src="captcha.php" alt="CAPTCHA" style="width:190px">


                            </div>
                            <div class="col-lg-4" style="margin-top:32px;">
                            <button type="button" class=" btn  btn-primary" onclick="captcha_refresh()">Regenerate captcha</button>

                            </div>
                        </div>
                    </div>
                    </div>
                   
                    <div class="mb-3 ">
                       <input class="btn btn-primary" type="submit" value="Submit">
                    </div>
                   
                </form>
            </div>
        </div>
    </div>

    
    <script src="https://code.jquery.com/jquery-3.6.3.min.js" integrity="sha256-pvPw+upLPUjgMXY0G+8O0xUf+/Im1MZjXxxgOcBQBXU="  crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js" integrity="sha512-rstIgDs0xPgmG6RX1Aba4KV5cWJbAMcvRCVmglpam9SoHZiUCyQVDdH2LPlxoHtrv17XWblE/V/PP+Tr04hbtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
   <script>
        function captcha_refresh(){
            $("#captcha").attr('src', 'captcha.php');
             return false;
        }

        $.validator.addMethod("mobile", function(value, element) {
            return this.optional(element) || /^(?:\+\d{2}[- ]?)?\d{10}$/.test(value);
        }, "Please enter a valid mobile number (10 digits only)");

        $.validator.addMethod("terms", function (value, element) {
            return $(element).is(":checked");
        }, "Please accept the terms and conditions");

        $(document).ready(function () {
            var captchaText = $("#captcha_text").val();
           //var captcha_var = "<?php //echo $_SESSION['captcha']; ?>";
            $("#cnt_myform").validate({
                rules: {
                    name: {
                        required: true,
                        minlength: 3
                    },
                    terms: {
                        required: true,
                        terms:true
                    },
                    email: {
                        required: true,
                        email: true
                    },
                    mobile: {
                        required: true,
                        mobile: true
                    },
                    gender: {
                        required: true
                    },
                    
                    captcha_text: {
                        required: true,
                        remote: {
                            url: "check-captcha.php",
                            type: "post",
                            data: {
                                captcha: function() {
                                    return $("#captcha_text").val();
                                }
                            }
                        }
                    },
                   
                },
                messages: {
                    name: {
                        required: "Please enter your name",
                        minlength: "Name must be at least 3 characters long"
                    },
                    email: {
                        required: "Please enter your email",
                        email: "Please enter a valid email address"
                    },
                    captcha_text: {
                        required: "Please Enter Captcha",
                        remote: "The code you entered does not match the captcha"

                    },
                    gender: {
                        required: "Please select your gender"
                    },
                    terms: {
                        required: "Please accept the terms and conditions"
                    }
                },
                submitHandler: function (form) {
                    //form is valid, now submit it using ajax
                    $.ajax({
                        type: "POST",
                        url: "submit.php",
                        data: $(form).serialize(),
                        success: function (response) {
                            //handle the response
                            alert(response);
                            window.location.reload();
                        }
                    });
                }
            });
        });
    </script>
</body>

</html>