import { createRouter, createWebHistory } from 'vue-router'
import Home from './components/Home.vue'

export default createRouter({
  history: createWebHistory(),
  routes: [
    {
      path: '/',
      component: Home,
    },
    {
      path: '/animated-chart',
      component: () => import('./components/overview/AnimatedChart.vue'),
    },
    {
      path: '/chart-with-zoom-pan',
      component: () => import('./components/overview/ChartWithZoom.vue'),
    },
    {
      path: '/multiseries-chart',
      component: () => import('./components/overview/MultiseriesChart.vue'),
    },
    {
      path: '/chart-multiple-axes',
      component: () => import('./components/overview/MultipleAxisChart.vue'),
    },
    {
      path: '/logarithmic-axis',
      component: () => import('./components/overview/LogarithmicAxisChart.vue'),
    },
    {
      path: '/chart-data-ajax-json',
      component: () => import('./components/overview/ChartJSONData.vue'),
    },
    {
      path: '/dynamic-line-chart',
      component: () => import('./components/overview/DynamicChart.vue'),
    },
    {
      path: '/drilldown-chart',
      component: () => import('./components/overview/DrilldownChart.vue'),
    },
    {
      path: '/responsive-chart',
      component: () => import('./components/overview/ResponsiveChart.vue'),
    },
    {
      path: '/synchronized-charts',
      component: () => import('./components/overview/SynchronizedCharts.vue'),
    },
    {
      path: '/line-chart-category-axis',
      component: () => import('./components/line-charts/LineChart.vue'),
    },
    {
      path: '/dashed-line-chart',
      component: () => import('./components/line-charts/DashedLineChart.vue'),
    },
    {
      path: '/multi-series-line-chart',
      component: () => import('./components/line-charts/MultiSeriesLineChart.vue'),
    },
    {
      path: '/spline-chart',
      component: () => import('./components/line-charts/SplineChart.vue'),
    },
    {
      path: '/multi-series-spline-chart',
      component: () => import('./components/line-charts/MultiSeriesSplineChart.vue'),
    },
    {
      path: '/step-line-chart',
      component: () => import('./components/line-charts/StepLineChart.vue'),
    },
    {
      path: '/multi-series-step-line-chart',
      component: () => import('./components/line-charts/MultiSeriesStepLineChart.vue'),
    },
    {
      path: '/bar-chart-category-axis',
      component: () => import('./components/bar-charts/BarChart.vue'),
    },
    {
      path: '/multi-series-bar-chart',
      component: () => import('./components/bar-charts/MultiSeriesBarChart.vue'),
    },
    {
      path: '/stacked-bar-chart',
      component: () => import('./components/bar-charts/StackedBarChart.vue'),
    },
    {
      path: '/stacked-bar-100-chart',
      component: () => import('./components/bar-charts/StackedBar100Chart.vue'),
    },
    {
      path: '/column-chart-category-axis',
      component: () => import('./components/column-charts/ColumnChart.vue'),
    },
    {
      path: '/column-chart-dark-theme',
      component: () => import('./components/column-charts/ColumnChartDarkTheme.vue'),
    },
    {
      path: '/multi-series-column-chart',
      component: () => import('./components/column-charts/MultiSeriesColumnChart.vue'),
    },
    {
      path: '/stacked-column-chart',
      component: () => import('./components/column-charts/StackedColumnChart.vue'),
    },
    {
      path: '/stacked-column-100-chart',
      component: () => import('./components/column-charts/StackedColumn100Chart.vue'),
    },
    {
      path: '/stacked-column-100-data-index-label',
      component: () => import('./components/column-charts/StackedColumn100ChartIndexLabel.vue'),
    },
    {
      path: '/pie-chart-indexlabel',
      component: () => import('./components/pie-doughnut-charts/PieChart.vue'),
    },
    {
      path: '/doughnut-chart',
      component: () => import('./components/pie-doughnut-charts/DoughnutChart.vue'),
    },
    {
      path: '/doughnut-chart-dark-theme',
      component: () => import('./components/pie-doughnut-charts/DoughnutChartDarkTheme.vue'),
    },
    {
      path: '/area-chart-category-axis',
      component: () => import('./components/area-charts/AreaChart.vue'),
    },
    {
      path: '/multi-series-area-chart',
      component: () => import('./components/area-charts/MultiSeriesAreaChart.vue'),
    },
    {
      path: '/spline-area-chart',
      component: () => import('./components/area-charts/AreaChart.vue'),
    },
    {
      path: '/multi-series-spline-area-chart',
      component: () => import('./components/area-charts/MultiSeriesSplineAreaChart.vue'),
    },
    {
      path: '/step-area-chart',
      component: () => import('./components/area-charts/StepAreaChart.vue'),
    },
    {
      path: '/stacked-area-chart',
      component: () => import('./components/area-charts/StackedAreaChart.vue'),
    },
    {
      path: '/stacked-area-100-chart',
      component: () => import('./components/area-charts/StackedArea100Chart.vue'),
    },
    {
      path: '/range-column-chart',
      component: () => import('./components/range-charts/RangeColumnChart.vue'),
    },
    {
      path: '/multi-series-range-column-chart',
      component: () => import('./components/range-charts/MultiSeriesRangeColumnChart.vue'),
    },
    {
      path: '/range-bar-chart',
      component: () => import('./components/range-charts/RangeBarChart.vue'),
    },
    {
      path: '/multi-series-range-bar-chart',
      component: () => import('./components/range-charts/MultiSeriesRangeBarChart.vue'),
    },
    {
      path: '/range-area-chart',
      component: () => import('./components/range-charts/RangeAreaChart.vue'),
    },
    {
      path: '/multi-series-range-area-chart',
      component: () => import('./components/range-charts/MultiSeriesRangeAreaChart.vue'),
    },
    {
      path: '/range-spline-area-chart',
      component: () => import('./components/range-charts/RangeSplineAreaChart.vue'),
    },
    {
      path: '/multi-series-range-spline-area-chart',
      component: () => import('./components/range-charts/MultiSeriesRangeSplineAreaChart.vue'),
    },
    {
      path: '/bubble-chart-3-dimensional-data',
      component: () => import('./components/bubble-scatter-charts/BubbleChart.vue'),
    },
    {
      path: '/bubble-chart-dark-theme',
      component: () => import('./components/bubble-scatter-charts/BubbleChartDarkTheme.vue'),
    },
    {
      path: '/scatter-chart',
      component: () => import('./components/bubble-scatter-charts/ScatterChart.vue'),
    },
    {
      path: '/funnel-chart-index-data-labels',
      component: () => import('./components/funnel-pyramid-charts/FunnelChart.vue'),
    },
    {
      path: '/funnel-chart-custom-neck-length',
      component: () => import('./components/funnel-pyramid-charts/FunnelChartCustomNeck.vue'),
    },
    {
      path: '/pyramid-chart',
      component: () => import('./components/funnel-pyramid-charts/PyramidChart.vue'),
    },
    {
      path: '/candlestick-chart',
      component: () => import('./components/financial-advanced-charts/CandlestickChart.vue'),
    },
    {
      path: '/multi-series-candlestick-chart',
      component: () => import('./components/financial-advanced-charts/MultiSeriesCandlestickChart.vue'),
    },
    {
      path: '/ohlc-chart',
      component: () => import('./components/financial-advanced-charts/OHLCChart.vue'),
    },
    {
      path: '/ohlc-chart-json-data',
      component: () => import('./components/financial-advanced-charts/OHLCChartJSONData.vue'),
    },
    {
      path: '/box-whisker-chart',
      component: () => import('./components/financial-advanced-charts/BoxAndWhiskerChart.vue'),
    },
    {
      path: '/waterfall-chart',
      component: () => import('./components/financial-advanced-charts/WaterfallChart.vue'),
    },
    {
      path: '/pareto-chart',
      component: () => import('./components/combination-charts/ParetoChart.vue'),
    },
    {
      path: '/error-line-chart',
      component: () => import('./components/combination-charts/ErrorLineChart.vue'),
    },
    {
      path: '/range-area-line-chart',
      component: () => import('./components/combination-charts/RangeAreaAndLineChart.vue'),
    },
    {
      path: '/candlestick-line-chart',
      component: () => import('./components/combination-charts/CandlestickAndLineChart.vue'),
    },
    {
      path: '/dynamic-live-line-chart',
      component: () => import('./components/dynamic-charts/DynamicLineChart.vue'),
    },
    {
      path: '/dynamic-live-column-chart',
      component: () => import('./components/dynamic-charts/DynamicColumnChart.vue'),
    },
    {
      path: '/dynamic-live-multi-series-chart',
      component: () => import('./components/dynamic-charts/DynamicMultiseriesChart.vue'),
    },
    {
      path: '/stockchart-numeric-axis',
      component: () => import('./components/stockcharts/StockChartNumericAxis.vue'),
    },
    {
      path: '/stockchart-date-time-axis',
      component: () => import('./components/stockcharts/StockChartDateTimeAxis.vue'),
    },
    {
      path: '/stockchart-rangeselector-navigator',
      component: () => import('./components/stockcharts/StockChartRangeSelector.vue'),
    },




    {
      path: '/404',
      name: 'NotFound',
      component: () => import('./components/NotFound.vue'),
  },
  {
      path: '/:catchAll(.*)',
      redirect:'404'
  }    
  ],
})
