# React Query and Axios: User Registration and Email Verification

This article will give you a comprehensive overview of JSON Web Token authentication with React.js, React Query, React-Hook-Form, Zod, and a RESTful API. You will learn how to validate forms with the React-Hook-Form library, make queries and mutations with React Query, register new users, verify their email addresses, sign the users into the React app, and log them out of the app.

![React Query and Axios: User Registration and Email Verification](https://codevoweb.com/wp-content/uploads/2022/09/React-Query-and-Axios-User-Registration-and-Email-Verification.webp)

## Topics Covered

- React Query and Axios User Authentication Flow
- Setup and Run the Backend Server
- Setup React with Vite and TailwindCSS
- Setup Axios and Zustand State Manager
- Create Reusable Components
- React Query Request: Register User
- React Query Request: Verify Email
- React Query Request: Login User
- React Query Request: Logout User
- Create Other Pages with TailwindCSS
- Setup Routing in React

Read the entire article here: [https://codevoweb.com/react-query-user-registration-and-email-verification](https://codevoweb.com/react-query-user-registration-and-email-verification)

Articles in this series:

### 1. React Query and Axios: User Registration and Email Verification

[React Query and Axios: User Registration and Email Verification](https://codevoweb.com/react-query-user-registration-and-email-verification)

### 2. Forgot/Reset Passwords with React Query and Axios

[Forgot/Reset Passwords with React Query and Axios](https://codevoweb.com/forgot-reset-passwords-with-react-query-and-axios)

