/*
 * Decompiled with CFR 0.152.
 */
package cz.eman.jsonrpc.server;

import cz.eman.jsonrpc.shared.RpcHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class JsonRpcServlet
extends HttpServlet {
    protected static final Logger log = Logger.getLogger(RpcHandler.class);
    protected String encoding = "UTF-8";
    protected boolean list = true;
    protected static final RpcHandler handler = new RpcHandler();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding(this.encoding);
        resp.setContentType("Content-Type: application/json;charset=" + this.encoding);
        log.debug((Object)("URI: " + req.getRequestURI()));
        if (this.list && req.getRequestURI().endsWith("/list")) {
            resp.getWriter().println(handler.displayHelp());
            return;
        }
        String urlParameter = req.getRequestURI().substring(req.getRequestURI().lastIndexOf("/") + 1);
        log.debug((Object)("urlParameter: " + urlParameter));
        String result = handler.onCall(urlParameter, JsonRpcServlet.isToString((InputStream)req.getInputStream()));
        log.debug((Object)("result:" + result));
        resp.getWriter().println(result);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if ("encoding".equals(key)) {
                this.encoding = config.getInitParameter(key);
                continue;
            }
            if ("list".equals(key)) {
                this.list = Boolean.parseBoolean(config.getInitParameter(key));
                continue;
            }
            try {
                RpcHandler.registerClass(key, Class.forName(config.getInitParameter(key)));
            }
            catch (ClassNotFoundException e1) {
                log.warn((Object)"Class in config not found!", (Throwable)e1);
            }
        }
    }

    public static String isToString(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

