/*
 * Decompiled with CFR 0.152.
 */
package cz.eman.jsonrpc.shared;

import cz.eman.jsonrpc.shared.RpcHandler;
import cz.eman.jsonrpc.shared.bo.JsonRpcResponse;
import cz.eman.jsonrpc.shared.exception.ThrowableMixIn;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public enum JsonTransformer {
    INSTANCE;

    protected static final Logger log;
    protected final ObjectMapper mapper = new ObjectMapper();

    static {
        log = Logger.getLogger(RpcHandler.class);
    }

    private JsonTransformer() {
        this.mapper.getSerializationConfig().addMixInAnnotations(Throwable.class, ThrowableMixIn.class);
        this.mapper.getDeserializationConfig().addMixInAnnotations(Throwable.class, ThrowableMixIn.class);
    }

    public static String toJson(Class<?> cl) throws InstantiationException, IllegalAccessException {
        if (cl.isPrimitive()) {
            return cl.getName();
        }
        Object instance = cl.newInstance();
        StringWriter sw = new StringWriter();
        try {
            JsonTransformer.getMapper().writeValue((Writer)sw, instance);
            return sw.toString();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return "ERR";
        }
    }

    public static Object toObject(String json, Class<?> cl) throws JsonParseException, JsonMappingException, IOException {
        return JsonTransformer.getMapper().readValue(json, cl);
    }

    public static String toJson(Object object) {
        StringWriter sw = new StringWriter();
        try {
            JsonTransformer.getMapper().writeValue((Writer)sw, object);
            return sw.toString();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return "ERR";
        }
    }

    public static String toJson(JsonRpcResponse result) {
        StringWriter sw = new StringWriter();
        try {
            JsonTransformer.getMapper().writeValue((Writer)sw, (Object)result);
            return sw.toString();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return "ERR";
        }
    }

    public static ObjectMapper getMapper() {
        return JsonTransformer.INSTANCE.mapper;
    }
}

