/*
 * Decompiled with CFR 0.152.
 */
package cz.eman.jsonrpc.shared;

import cz.eman.jsonrpc.shared.JsonTransformer;
import cz.eman.jsonrpc.shared.ParameterNameUtil;
import cz.eman.jsonrpc.shared.RpcHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceDetailsWriter {
    protected static final Logger log = Logger.getLogger(RpcHandler.class);
    protected Map<String, Class<?>> classMapping = new HashMap();

    public ServiceDetailsWriter(Map<String, Class<?>> classMapping) {
        this.classMapping = classMapping;
    }

    public String displayHelp() {
        StringBuffer sb = new StringBuffer();
        for (String key : this.classMapping.keySet()) {
            sb.append(this.displayClass(key));
            sb.append("\n\n");
        }
        return sb.toString();
    }

    protected String displayClass(String key) {
        Class<?> cl = this.classMapping.get(key);
        StringBuffer sb = new StringBuffer();
        sb.append("url: " + key + "\n");
        Method[] methodArray = cl.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            sb.append(this.displayMethod(m));
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    protected String displayMethod(Method method) {
        StringBuffer sb = new StringBuffer();
        if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !this.isObjectMethod(method)) {
            sb.append("\tmethod: " + method + " annotated: " + ParameterNameUtil.isMethodAnotatedByPName(method) + "\n");
            sb.append("\tparameters: \n");
            int index = 0;
            Class<?>[] classArray = method.getParameterTypes();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> cl = classArray[n2];
                sb.append(this.displayParameter(cl));
                if (ParameterNameUtil.isMethodAnotatedByPName(method)) {
                    sb.append("\t\t\tname: " + ParameterNameUtil.getPName(method, index).value() + "\n");
                }
                try {
                    sb.append("\t\t\texample: " + JsonTransformer.toJson(cl) + "\n");
                }
                catch (InstantiationException e) {
                    log.error((Object)e, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e, (Throwable)e);
                }
                ++index;
                ++n2;
            }
            sb.append("\treturn type: \n");
            sb.append("\t\t" + method.getReturnType() + " \n");
            try {
                sb.append("\t\t\t" + JsonTransformer.toJson(method.getReturnType()) + "\n\n\n");
            }
            catch (InstantiationException e) {
                log.error((Object)e, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return sb.toString();
    }

    protected String displayParameter(Class<?> parameter) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t\t" + parameter + "\n");
        return sb.toString();
    }

    public boolean isObjectMethod(Method method) {
        return method.getName().equals("toString") || method.getName().equals("equals") || method.getName().equals("clone") || method.getName().equals("wait") || method.getName().equals("getClass") || method.getName().equals("hashCode") || method.getName().equals("notify") || method.getName().equals("notifyAll");
    }
}

