/*
 * File: sfo_07_reconstruct_binary_tree_s1.cpp
 * Created Time: 2021-12-09
 * Author: Krahets (krahets@163.com)
 */

#include "../include/include.hpp"

// ===== Solution Code =====
class Solution {
  public:
    TreeNode *buildTree(vector<int> &preorder, vector<int> &inorder) {
        this->preorder = preorder;
        for (int i = 0; i < inorder.size(); i++)
            dic[inorder[i]] = i;
        return recur(0, 0, inorder.size() - 1);
    }

  private:
    vector<int> preorder;
    unordered_map<int, int> dic;
    TreeNode *recur(int root, int left, int right) {
        if (left > right)
            return nullptr;                                     // 递归终止
        TreeNode *node = new TreeNode(preorder[root]);          // 建立根节点
        int i = dic[preorder[root]];                            // 划分根节点、左子树、右子树
        node->left = recur(root + 1, left, i - 1);              // 开启左子树递归
        node->right = recur(root + i - left + 1, i + 1, right); // 开启右子树递归
        return node;                                            // 回溯返回根节点
    }
};

int main() {
    // ======= Test Case =======
    vector<int> preorder = {3, 9, 20, 15, 7};
    vector<int> inorder = {9, 3, 15, 20, 7};
    // ====== Driver Code ======
    Solution *slt = new Solution();
    TreeNode *res = slt->buildTree(preorder, inorder);
    PrintUtil::printTree(res);

    return 0;
}
