/*
 * File: sfo_40_the_smallest_k_numbers_s2.cpp
 * Created Time: 2021-12-09
 * Author: Krahets (krahets@163.com)
 */

#include "../include/include.hpp"

// ===== Solution Code =====
class Solution {
  public:
    vector<int> getLeastNumbers(vector<int> &arr, int k) {
        if (k >= arr.size())
            return arr;
        return quickSort(arr, k, 0, arr.size() - 1);
    }

  private:
    vector<int> quickSort(vector<int> &arr, int k, int l, int r) {
        int i = l, j = r;
        while (i < j) {
            while (i < j && arr[j] >= arr[l])
                j--;
            while (i < j && arr[i] <= arr[l])
                i++;
            swap(arr[i], arr[j]);
        }
        swap(arr[i], arr[l]);
        if (i > k)
            return quickSort(arr, k, l, i - 1);
        if (i < k)
            return quickSort(arr, k, i + 1, r);
        vector<int> res;
        res.assign(arr.begin(), arr.begin() + k);
        return res;
    }
};

int main() {
    // ======= Test Case =======
    vector<int> arr = {3, 2, 1};
    int k = 2;
    // ====== Driver Code ======
    Solution *slt = new Solution();
    vector<int> res = slt->getLeastNumbers(arr, k);
    PrintUtil::printVector(res);

    return 0;
}
