/*
 * File: sfo_51_reversed_pairs_in_an_array_s1.cpp
 * Created Time: 2021-12-09
 * Author: Krahets (krahets@163.com)
 */

#include "../include/include.hpp"

// ===== Solution Code =====
class Solution {
  public:
    int reversePairs(vector<int> &nums) {
        vector<int> tmp(nums.size());
        return mergeSort(0, nums.size() - 1, nums, tmp);
    }

  private:
    int mergeSort(int l, int r, vector<int> &nums, vector<int> &tmp) {
        // 终止条件
        if (l >= r)
            return 0;
        // 递归划分
        int m = (l + r) / 2;
        int res = mergeSort(l, m, nums, tmp) + mergeSort(m + 1, r, nums, tmp);
        // 合并阶段
        int i = l, j = m + 1;
        for (int k = l; k <= r; k++)
            tmp[k] = nums[k];
        for (int k = l; k <= r; k++) {
            if (i == m + 1)
                nums[k] = tmp[j++];
            else if (j == r + 1 || tmp[i] <= tmp[j])
                nums[k] = tmp[i++];
            else {
                nums[k] = tmp[j++];
                res += m - i + 1; // 统计逆序对
            }
        }
        return res;
    }
};

int main() {
    // ======= Test Case =======
    vector<int> nums = {7, 5, 6, 4};
    // ====== Driver Code ======
    Solution *slt = new Solution();
    int res = slt->reversePairs(nums);
    cout << res << endl;

    return 0;
}
