"""
File: sfo_37_serialize_and_deserialize_a_binary_tree_s1.py
Created Time: 2021-12-09
Author: Krahets (krahets@163.com)
"""

from include import *


# ===== Solution Code =====
class Codec:
    def serialize(self, root: TreeNode) -> str:
        if not root:
            return "[]"
        queue = collections.deque()
        queue.append(root)
        res = []
        while queue:
            node = queue.popleft()
            if node:
                res.append(str(node.val))
                queue.append(node.left)
                queue.append(node.right)
            else:
                res.append("null")
        return "[" + ",".join(res) + "]"

    def deserialize(self, data: str) -> TreeNode:
        if data == "[]":
            return
        vals, i = data[1:-1].split(","), 1
        root = TreeNode(int(vals[0]))
        queue = collections.deque()
        queue.append(root)
        while queue:
            node = queue.popleft()
            if vals[i] != "null":
                node.left = TreeNode(int(vals[i]))
                queue.append(node.left)
            i += 1
            if vals[i] != "null":
                node.right = TreeNode(int(vals[i]))
                queue.append(node.right)
            i += 1
        return root


# ======= Test Case =======
data = "[1,2,3,null,null,4,5,null,null,null,null]"
# ====== Driver Code ======
codec = Codec()
root = codec.deserialize(data)
res = codec.serialize(root)
print_tree(root)
print(res)
