"""
This is a matlab style functional interface the matplotlib.

"""

from matplotlib.figure import *


class Gca:
    __shared_state = {}
    def __init__(self):
        self.__dict__ = self.__shared_state
        self._a = None

    def set(self, a):
        self._a = a

    def __call__(self):
        if self._a is None:            
            self._a = Subplot(111)
            gcf().add_axis(self._a)
        return self._a
        
            

class Gcf:
    __shared_state = {}
    def __init__(self):
        self.__dict__ = self.__shared_state
        self._f = None

    def set(self, f):
        self._f = f

    def __call__(self):
        if self._f is None: self._f = Figure()
        return self._f


gcf = Gcf()
gca = Gca()

def plot(*args):
    gca().plot(*args)
    return gca()

def vlines(*args):    
    gca().vlines(*args)
    return gca()



def axis(*v):

    # with no args, return the current axis as a length 4 vector
    # [xmin xmax ymin ymax]
    try: v[0]
    except IndexError:
        xlim = gca().get_xlim()
        ylim = gca().get_ylim()
        return [xlim[0], xlim[1], ylim[0], ylim[1]]
    
    v = v[0]
    if len(v) != 4:
        raise ValueError, 'v must contain [xmin xmax ymin ymax]' 

    gca().set_xlim([v[0], v[1]])
    gca().set_ylim([v[2], v[3]])

def xlabel(s):
    try: gca().set_xlabel(s)
    except AttributeError: pass

def title(s):
    try: gca().set_title(s)
    except AttributeError: pass

def show():
    
    win = gtk.Window()
    win.set_name("Test Input")
    win.connect("destroy", gtk.mainquit)
    win.set_border_width(5)

    vbox = gtk.VBox(spacing=3)
    win.add(vbox)
    vbox.show()

    gcf().show()
    vbox.pack_start(gcf())

    win.show()
    gtk.mainloop()


def subplot(*args):
    
    gca.set( Subplot(*args) )
    gcf().add_axis( gca() )

    return gca()
    

def set(h, s, val):
    func = 'h.set_%s(val)' % s
    eval(func, {}, {'h':h, 'val':val})

