
class SquareLine2D(SymbolLine2D):
    def __init__(self, x, y, *args, **kargs):
        SymbolLine2D.__init__(self, x, y, symbolSize=4, *args, **kargs)
        
    def _draw(self, xt, yt, widget, gc):
        for (x,y) in zip(xt, yt):
            p = RegularPolygon((x,y), numVertices=4,
                               radius=self._symbolSize,
                               orientation=-numpy.pi/4,
                               edgeColor=self._color,
                               faceColor=self._color,
                               )
            p.set_fill(self._symbolFill)
            p.draw(widget, gc)


class TriangleLine2D(SymbolLine2D):
    def __init__(self, x, y, *args, **kargs):
        SymbolLine2D.__init__(self, x, y, symbolSize=4, *args, **kargs)

    def _draw(self, xt, yt, widget, gc):
        for (x,y) in zip(xt, yt):
            p = RegularPolygon((x,y), numVertices=3,
                               radius=self._symbolSize,
                               orientation=self.orientation,
                               edgeColor=self._color,
                               faceColor=self._color,
                               )
            p.set_fill(self._symbolFill)
            p.draw(widget, gc)
            
    
class TriangleUpLine2D(TriangleLine2D):
    def __init__(self, x, y, *args, **kargs):
        TriangleLine2D.__init__(self, x, y, *args, **kargs)
        self.orientation = -numpy.pi/2

class TriangleDownLine2D(TriangleLine2D):
    def __init__(self, x, y, *args, **kargs):
        TriangleLine2D.__init__(self, x, y, *args, **kargs)
        self.orientation = numpy.pi/2

class TriangleLeftLine2D(TriangleLine2D):
    def __init__(self, x, y, *args, **kargs):
        TriangleLine2D.__init__(self, x, y, *args, **kargs)
        self.orientation = numpy.pi

class TriangleRightLine2D(TriangleLine2D):
    def __init__(self, x, y, *args, **kargs):
        TriangleLine2D.__init__(self, x, y, *args, **kargs)
        self.orientation = 0

