from __future__ import division
import os
import gtk, gtk.glade
import gtk
from gtk import gdk
from matplotlib.figure import Figure
from Numeric import array, Float, reshape


def popup_error(msg):
    
    d = gtk.Dialog('Error!', flags=gtk.DIALOG_MODAL)
    l = gtk.Label(msg)
    l.show()
    d.vbox.pack_start(l)

    b.connect('clicked', d.destroy)
    b.show()
    d.vbox.pack_start(b)
    d.show()

class GladeWrapper:
    def __init__(self, gladeFile):
        self.widgets = gtk.glade.XML (gladeFile)

        self.widgets.signal_autoconnect(
            self._get_handler_dict())
        
    def _get_handler_dict(self):
        m = {}
        for name in dir(self):
            if name[0]!='_' and callable(getattr(self, name)):
                m[name] = getattr(self, name)
        return m

class MainWindow(GladeWrapper):
    def __init__(self, axisGeometry):
        GladeWrapper.__init__(self, 'main2.glade')
        self.fig = Figure()

        self.axisGeometry = axisGeometry
        for a in reshape(axisGeometry, (-1,)):
            xmin, xmax = a.get_xlim()
            ymin, ymax = a.get_ylim()
            xticks = a.get_xticks()
            yticks = a.get_yticks()
            a.saveExcursion = {'xmin' : xmin,
                               'xmax' : xmax,
                               'ymin' : ymin,
                               'ymax' : ymax,
                               }


            self.fig.add_axis(a)

        self._make_navigation_table()

        self.fig.show()

    def _make_navigation_table(self):
        # interactively update the gtk.Table toolbar widget: make a
        # check button for each axis that the navigation controls
        # apply to

        axesTable = self.widgets.get_widget('tableAxes')
        numRows, numCols = self.axisGeometry.shape
        axesTable.resize(numRows, numCols)
        count = 0
        for row in range(numRows):
            for col in range(numCols):
                count+=1
                button = gtk.CheckButton(str(count))
                button.show()
                button.set_active(1)
                button.connect("toggled", self._update_navigation_axes)
                axesTable.attach(button, row, row+1, col, col+1)
                self.axisGeometry[row,col].button = button

        self._update_navigation_axes()
        
    def _update_navigation_axes(self, event=None):
        # keep a list of which axes are checked for the navigation
        # toolbar

        self.selectedAxes = []
        for a in self.fig.get_axes():
            if a.button.get_active():
                self.selectedAxes.append(a)
                
        return gtk.TRUE

        
    def _get_axis_under_mouse(self, x, y):
        for a in self.fig.get_axes():
            if a.in_axes(x, y):
                return a
        return None


    def on_buttonPanX_scroll_event(self, widget, event):
        for a in self.selectedAxes:
            xmin, xmax = a.get_xlim()
            xticks = a.get_xticks()
            xstep = xticks[1] - xticks[0]
            if event.direction == gdk.SCROLL_UP:
                xmin += 2*xstep
                xmax += 2*xstep
            elif event.direction == gdk.SCROLL_DOWN:
                xmin -= 2*xstep
                xmax -= 2*xstep

            a.set_xlim(array([xmin, xmax], Float))
            a.draw()
        return gtk.TRUE


    def on_buttonPanY_scroll_event(self, widget, event):
        for a in self.selectedAxes:
            ymin, ymax = a.get_ylim()
            yticks = a.get_yticks()
            ystep = yticks[1] - yticks[0]
            if event.direction == gdk.SCROLL_UP:
                ymin += 2*ystep
                ymax += 2*ystep
            elif event.direction == gdk.SCROLL_DOWN:
                ymin -= 2*ystep
                ymax -= 2*ystep

            a.set_ylim(array([ymin, ymax], Float))
            a.draw()
        return gtk.TRUE



    def on_buttonZoomX_scroll_event(self, widget, event):

        if event.direction == gdk.SCROLL_UP:
            sign = -1
        elif event.direction == gdk.SCROLL_DOWN:
            sign = 1

        for a in self.selectedAxes:
            xmin, xmax = a.get_xlim()
            frac = 0.1
            d = xmax - xmin
            xmin -= sign*frac*d
            xmax += sign*frac*d
            a.set_xlim(array([xmin, xmax], Float))
            a.draw()

        return gtk.TRUE

    def on_buttonZoomY_scroll_event(self, widget, event):
        if event.direction == gdk.SCROLL_UP:
            sign = -1
        elif event.direction == gdk.SCROLL_DOWN:
            sign = 1

        for a in self.selectedAxes:
            ymin, ymax = a.get_ylim()
            frac = 0.1
            d = ymax - ymin
            ymin -= sign*frac*d
            ymax += sign*frac*d
            a.set_ylim(array([ymin, ymax], Float))

            a.draw()
        return gtk.TRUE

    def on_buttonSaveExcusion_clicked(self, event):
        for a in self.selectedAxes:
            xmin, xmax = a.get_xlim()
            ymin, ymax = a.get_ylim()
            a.saveExcursion = {'xmin' : xmin,
                               'xmax' : xmax,
                               'ymin' : ymin,
                               'ymax' : ymax,}
        return gtk.TRUE
    
    def on_buttonRestoreExcursion_clicked(self, event):
        for a in self.selectedAxes:
            xmin = a.saveExcursion['xmin']
            xmax = a.saveExcursion['xmax']
            ymin = a.saveExcursion['ymin']
            ymax = a.saveExcursion['ymax']
            a.set_xlim(array([xmin, xmax], Float))
            a.set_ylim(array([ymin, ymax], Float))
            a.draw()
        return gtk.TRUE
    
    def on_buttonJumpToTime_clicked(self, event):
        try:
            val = float(self.widgets.get_widget('entryJumpToTime').get_text())
        except ValueError:
            popup_error('Value must be a time in seconds')
        else:
            for a in self.selectedAxes:
                xmin, xmax = a.get_xlim()
                d = xmax - xmin
                xmin = val
                xmax = xmin + d
                a.set_xlim(array([xmin, xmax], Float))
                a.draw()
        return gtk.TRUE


    def on_drawingArea_expose_event(self, widget, event):
        self.fig.expose_event(widget, event)
        return gtk.TRUE
    
    def on_drawingArea_configure_event(self, widget, event):
        self.fig.configure_event(widget, event)
        return gtk.TRUE
    
    def on_drawingArea_motion_notify_event(self, widget, event):
        a = self._get_axis_under_mouse(event.x, event.y)
        if a is None:
            return gtk.TRUE
        x, y = a.transform_win_to_data(event.x, event.y)
        self.widgets.get_widget('labelXPosition').set_label(
            '  X: %+1.3f' % x)
        self.widgets.get_widget('labelYPosition').set_label(
            '  Y: %+1.3f' % y)
        return gtk.TRUE


    def on_drawingArea_button_press_event(self, widget, event):
        print 'press'
        self.fig.button_press_event(widget, event)
        return gtk.TRUE

    
    def on_drawingArea_button_release_event(self, widget, event):
        print 'release'
        self.fig.button_release_event(widget, event)
        return gtk.TRUE

    def on_menuSaveAs_activate(self, event):
        return gtk.TRUE

    def on_menuAbout_activate(self, event):
        return gtk.TRUE

    def on_menuQuit_activate(self, event):
        gtk.mainquit()

    def on_menuOpen_activate(self, event):
        return gtk.TRUE

    def on_menuNew_activate(self, event):
        return gtk.TRUE

    def on_menuSave_activate(self, event):
        return gtk.TRUE














