from matplotlib.matlab import *
from Numeric import arange, sin, exp, multiply, pi

def f(t):
    s1 = sin(2*pi*t)
    e1 = exp(-t)
    return multiply(s1,e1)

t1 = arange(0.0, 5.0, 0.1)
t2 = arange(0.0, 5.0, 0.02)
t3 = arange(0.0, 2.0, 0.01)

subplot(211)
plot(t1, f(t1), 'bo', t2, f(t2), 'k')
title('A tale of 2 subplots')

subplot(212)
plot(t3, sin(2*pi*t3), 'r--')
xlabel('time (s)')

# show the figure
show()
