"""
This is a matlab style functional interface the matplotlib.

"""

# bring all the MLab and mlab symbols in so folks can import them from
# matplotlib.matlab in one fell swoop
from Numeric import *
from MLab import *
from mlab import *

import pygtk
pygtk.require('2.0')
import gtk
from gtk import gdk
from Numeric import arange, array, ones, zeros, Float

from matplotlib.figure import Figure, Subplot, to_arrays

#so I can override hist, psd, etc...
import matplotlib.mlab


class Gca:
    __shared_state = {}
    def __init__(self):
        self.__dict__ = self.__shared_state
        self._a = None

    def set(self, a):
        self._a = a

    def __call__(self):
        if self._a is None:            
            self._a = Subplot(111)
            gcf().add_axis(self._a)
        return self._a
        
            

class Gcf:
    __shared_state = {}
    def __init__(self):
        self.__dict__ = self.__shared_state
        self._f = None

    def set(self, f):
        self._f = f

    def __call__(self):
        if self._f is None: self._f = Figure()
        return self._f


gcf = Gcf()
gca = Gca()





def axis(*v):

    # with no args, return the current axis as a length 4 vector
    # [xmin xmax ymin ymax]
    try: v[0]
    except IndexError:
        xlim = gca().get_xlim()
        ylim = gca().get_ylim()
        return [xlim[0], xlim[1], ylim[0], ylim[1]]
    
    v = v[0]
    if len(v) != 4:
        raise ValueError, 'v must contain [xmin xmax ymin ymax]' 

    gca().set_xlim([v[0], v[1]])
    gca().set_ylim([v[2], v[3]])

def xlabel(s):
    try: gca().set_xlabel(s)
    except AttributeError: pass

def title(s):
    try: gca().set_title(s)
    except AttributeError: pass

def show():
    
    win = gtk.Window()
    win.set_name("Test Input")
    win.connect("destroy", gtk.mainquit)
    win.set_border_width(5)

    vbox = gtk.VBox(spacing=3)
    win.add(vbox)
    vbox.show()

    gcf().show()
    vbox.pack_start(gcf())

    win.show()
    gtk.mainloop()


def subplot(*args):
    
    gca.set( Subplot(*args) )
    gcf().add_axis( gca() )

    return gca()
    

def set(h, s, val):
    func = 'h.set_%s(val)' % s
    eval(func, {}, {'h':h, 'val':val})



def plot(*args):
    return gca().plot(*args)

def vlines(*args):    
    return gca().vlines(*args)

def hlines(*args):    
    return gca().hlines(*args)

def bar(*args):
    return gca().bar(*args)

def errorbar(x, y, e, u=None, fmt='b-'):
    """

    Plot x versus y with error bars in e.  if u is not None, then u
    gives the upper error bars and e gives the lower error bars.
    Otherwise e the error bars are symmetrix about y and given in the
    array e.
    
    fmt is the plot format symbol for y

    Return value is a length 2 tuple.  The first element is a list of
    y symbol lines.  The second element is a list of error bar lines.
    
    """
    
    l0 = plot(x,y,fmt)

    e = to_arrays(Float, e)
    if u is None: u = e
    upper = y+u
    lower = y-e
    width = (max(x)-min(x))*0.005
    l1 = gca().vlines(x, y, lower)
    l2 = gca().vlines(x, y, upper)
    l3 = gca().hlines(upper, x-width, x+width)
    l4 = gca().hlines(lower, x-width, x+width)

    l1.extend(l2)
    l3.extend(l4)
    l1.extend(l3)

    return (l0, l1)


def hist(x, bins=10, fmt='o'):
    n,bins = matplotlib.mlab.hist(x, bins)
    return plot(bins, n, fmt)



    
