from __future__ import division
import pygtk
pygtk.require('2.0')
import gtk
from Numeric import array, arange, sin, cos, pi
from matplotlib.colors import ColorDispatcher


def _identity_transform(*args):
    return args

class Patch:
    """
    A patch is a 2D thingy with a face color and an edge color
    """
    
    def __init__(self,
                 edgeColor=ColorDispatcher().get('k'),
                 faceColor=ColorDispatcher().get('b'),
                 fill=1,
                 ):

        self.edgeColor = edgeColor
        self.faceColor = faceColor
        self.fill = fill


    def get_extent(self):
        """Return the bounding box as xmin,xmax,ymin,ymax in data coords"""
        raise NotImplementedError, "Derived must override"

    def set_edgecolor(self, c):
        self.edgeColor = c

    def set_facecolor(self, c):
        self.faceColor = c

    def set_fill(self, b):
        self.fill = b

    def draw(self, widget, gc, transpoint, transscale):
        self._draw(widget, gc, transpoint, transscale)

    def _draw(widget, gc, transpoint, transscale):
        raise NotImplementedError, 'Derived must override'

class Rectangle(Patch):
    """
    Draw a rectangle with lower left at xy=(x,y) with specified
    width and height
    """

    def __init__(self, xy, width, height, *args, **kargs):
        Patch.__init__(self, *args, **kargs)

        # todo: verify that xy sets lower left
        self.extent = xy[0], xy[0]+width, xy[1], xy[1]+height
        self.xy  = xy
        self.width, self.height = width, height
        
    def _draw(self, widget, gc, transpoint, transscale):
        x, y  = transpoint(self.xy[0], self.xy[1])
        width, height = transscale(self.width, self.height)

        gcFace = gc
        gcFace.foreground = self.faceColor
        if self.fill:
            widget.window.draw_rectangle(gcFace, filled=1,
                                         x=x, y=y-height,
                                         width=width, height=height)

        gcEdge = gc
        gcEdge.foreground = self.edgeColor
        gcEdge.line_width = 2
        widget.window.draw_rectangle(gcEdge, filled=0,
                                     x=x, y=y-height,
                                     width=width, height=height)

    def get_extent(self):
        """Return the bounding box as xmin,xmax,ymin,ymax in data coords"""
        return self.extent


class RegularPolygon(Patch):
    """
    A regular polygon patch.  xy is a length 2 tuple (the center)
    numVertices is the number of vertices.  Radius is the distance
    from the center to each of the vertices.  Orientation is in
    radians and rotates the polygon.
    """
    def __init__(self, xy, numVertices, radius=5, orientation=0,
                 *args, **kargs):

        Patch.__init__(self, *args, **kargs)
        self.xy = xy
        self.numVertices = numVertices
        self.radius = radius
        self.orientation = orientation
        self._compute_vertices()        
        
    def _compute_vertices(self):
        theta = 2*pi/self.numVertices*arange(self.numVertices) + \
                self.orientation

        xs = self.xy[0] + self.radius*cos(theta)
        ys = self.xy[1] + self.radius*sin(theta)
        self.vertices = zip(xs, ys)
        #print self.vertices
        
    def _draw(self, widget, gc):
        gcFace = gc
        gcFace.foreground = self.faceColor
        if self.fill:
            widget.window.draw_polygon(gcFace, filled=1,
                                       points=self.vertices)
        gcEdge = gc
        gcEdge.foreground = self.edgeColor
        widget.window.draw_polygon(gcFace, filled=0,
                                   points=self.vertices)

