"""

These are utility functions used by the rest of the code.  Several are
borrowed directly from the Python Cookbook.  I have tried to give
credit where credit is due in these cases


"""

from __future__ import generators
from __future__ import division
import sys



# Alex's Indexable pattern from The Python Cookbook.  Soon to be
# obsolete in python2.3
indices = xrange(sys.maxint)

    
def iterable(obj):
    """
    Return true if object is iterable.  From The Python Cookbook
    """
    try: iter(obj)
    except: return 0
    return 1
      

def is_string_like(obj):
    """
    Return true if obj looks like a string.
    
    From: The Python Cookbook, with minor modification to catch
    ValueError when testing numpy objects
    """
    try: obj + ''
    except (TypeError, ValueError): return 0
    return 1

def is_scalar(obj):
    """
    Return true if obj looks like a scalar.
    
    From: The Python Cookbook
    """
    return is_string_like(obj) or not iterable(obj)

def flatten(seq, scalarp=is_scalar):
    """
    this generator flattens nested containers such as

    >>> l=( ('John', 'Hunter'), (1,23), [[[[42,(5,23)]]]])

    so that

    >>> for i in flatten(l): print i,
    John Hunter 1 23 42 5 23

    By: Composite of Holger Krekel and Luther Blissett
    From: http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/121294
    and Recipe 1.12 in cookbook
    """
    for item in seq:
        if scalarp(item): yield item
        else:
            for subitem in flatten(item, scalarp):
                yield subitem


class CmpTrue:
    """
    Return true on any comparison.  This is useful when you want to
    set a default variable at initialization that will be overridden
    on first comparison, as in

    minVal = None
    for seq in allSeqs:
      minSeq = min(seq)
      if minVal is None:
        minVal = minSeq
        break
      if minSeq < minVal: minVal = minSeq

    This song and dance can be simplified in CmpTrue to
    minVal = CmpTrue()
    for seq in allSeqs:
      minSeq = min(seq)
      if minSeq < minVal: minVal = minSeq

    With the arithmetic functions defined to return a CmpTrue object,
    you can do things like

    minVal = CmpTrue()
    for seq in allSeqs:
      minSeq = min(seq)
      if 2*minSeq-1 < minVal: minVal = minSeq

    Use with caution!
    
    """

    __returnTrue = ['__lt__', '__le__', '__eq__', '__ne__', '__gt__',
                    '__ge__', '__cmp__', '__rcmp__']



    __returnSelf = ['__add__', '__sub__', '__mul__', '__div__',
                    '__mod__', '__divmod__', '__pow__', '__lshift__',
                    '__rshift__', '__rsub__', '__rmul__', '__rdiv__',
                    '__rmod__', '__rdivmod__', '__rpow__',
                    '__rlshift__', '__rrshift__']


    def __init__(self):

        for func in self.__returnTrue:
            self.__dict__[func] = self.__return_true

        for func in self.__returnSelf:
            self.__dict__[func] = self.__return_self

    def __return_self(self, arg=None):
        return self

    def __return_true(self, arg=None):
        return 1

    def __str__(self):
        return "It's true, really"


class Range:
    "A utility class for dealing with a range (min,max)"

    def __init__(self, xmin=CmpTrue(), xmax=CmpTrue()):
        self._xmin, self._xmax = xmin, xmax

    def update(self,x):
        thisMin, thisMax = min(x), max(x)
        if thisMin<self._xmin: self._xmin = thisMin
        if thisMax>self._xmax: self._xmax = thisMax

    def get_min(self):
        if isinstance(self._xmin, CmpTrue):
            raise RuntimeError, 'You must first update the data range. xmin undefined'
        return self._xmin

    def get_max(self):
        if isinstance(self._xmax, CmpTrue):
            raise RuntimeError, 'You must first update the data range. xmax undefined'
        return  self._xmax

    def set_min(self, m):
        self._xmin = m

    def set_max(self, m):
        self._xmax = m

    def get_range(self):
        return (self.get_min(), self.get_max())

    def get_distance(self):
        return self.get_max() - self.get_min()

    def set_range(self, range):
        self._xmin, self._xmax = range[0], range[1]

    def __str__(self):
        try: mins = str(self.get_min())
        except RuntimeError: mins = "Undefined"
        try: maxs = str(self.get_max())
        except RuntimeError: maxs = "Undefined"
        return "Range: (%s, %s)" % (mins, maxs)

    def contains(self, val):
        xmin, xmax = self.get_min(), self.get_max()
        if xmax>xmin:
            return val >= xmin and val <= xmax
        else:
            return val <= xmin and val >= xmax


