import tradepy
from TradeUtils import to_days
from math import floor
from Numeric import zeros, Float, put
import Numeric as numpy
db = tradepy.Dbase('nitace', 'jdhunter', 'nnyams58', 'quotes')

dateb = '2002-09-01'
datee = '2002-11-01'

ticker1 = 'INTC'
ticker2 = 'AAPL'
(t1, p1, v1) = db.get_quotes(ticker1, dateb, datee)
(t2, p2, v2) = db.get_quotes(ticker2, dateb, datee)

d1 = to_days(t1)
d2 = to_days(t2)

# norm the prices by open
p1 = p1/p1[0]
p2 = p2/p2[0]

M1 = zeros( (len(p1),2), Float)
M2 = zeros( (len(p2),2), Float)

M1[:,0] = d1
M1[:,1] = p1
M2[:,0] = d2
M2[:,1] = p2

outFile1 = file('../demo/data/%s.dat' % ticker1, 'wb')
outFile1.write(M1.tostring())
outFile1.close()

outFile2 = file('../demo/data/%s.dat' % ticker2, 'wb')
outFile2.write(M2.tostring())
outFile2.close()

