# This file generates the matplotlib web page logo
from matplotlib.matlab import *


# convert data to mV
x = 1000*0.1*fromstring(file('data/membrane.dat').read(), typecode=Float32)
# 0.0005 is the sample interval
t = 0.0005*arange(len(x))
figure(1, size=(700,100))
subplot(111, axisbg='y')
plot(t, x)
text(1.1,-55,'matplotlib', color='r', fontsize=50, fontname='Courier')
axis([1, 1.72,-60, 10])
set(gca(), 'xticklabels', [])
set(gca(), 'yticklabels', [])
savefig('logo.png', size=(700,100))
show()
