from Numeric import Int16, array
class Artist:
    "Abstract base class for someone who renders into a Figure"

    def __init__(self):
        self._drawingArea = None
        self._drawable = None
        self._lod = 0
    def clip_gc(self, gc):
        "The gc clipping function; no clip by default"        
        pass

    def get_child_artists(self):
        'Return all artists contained in self'
        return []


    def get_window_extent(self):
        """
        Return the bounding box as left, bottom, width, height in
        window coords
        """
        l, b, w, h = self.get_data_extent()
        w, h = self.transform_scale_to_win(w, h)
        l, b = self.transform_points_to_win(l, b)
        return l, b, w, h
        

    def get_data_extent(self):
        """
        Return the bounding box as left, bottom, width, height in
        data coords of the area
        """
        raise NotImplementedError, "Derived must override"

    def transform_points_to_win(self, x, y):
        """
        Transform the points x, y to window coords. Default is convert
        to int
        """
        x = array(x)
        y = array(y)
        return x.astype(Int16), y.astype(Int16)

    def transform_scale_to_win(self, xscale, yscale):
        """
        Transform the xscale, yscale to window coords. Default is
        convert to int
        """
        x = array(xscale)
        y = array(yscale)
        return x.astype(Int16), y.astype(Int16)

    def draw(self, drawable=None, *args, **kwargs):
        'Derived classes drawing method'
        if drawable is None: drawable = self._drawable
        if drawable is None: return
        self._draw(drawable, *args, **kwargs)

    def _draw(self, drawable, *args, **kwargs):
        'Derived classes drawing method'
        raise NotImplementedError, 'Derived must override'

    def set_drawing_area(self, da):
        'Set the drawing area that you render into'
        self._drawingArea = da
        self._drawable = da.window
        for artist in self.get_child_artists():
            artist.set_drawing_area(da)

    def set_lod(self, on):
        """
        Set Level of Detail on or off.  If on, the artists may examine
        things like the pixel width of the axes and draw a subset of
        their contents accordingly
        """
        self._lod = on

        
    def wash_brushes(self):
        'Erase any state vars that would impair a draw to a clean palette'

        for artist in self.get_child_artists():
            artist.wash_brushes()

            
