import pygtk
pygtk.require('2.0')
import gtk
from gtk import gdk
from cbook import is_string_like

class ProgressBarDialog(gtk.Dialog):
    "Use attribute bar to control the progress bar"
    def __init__(self, title, parent, msg='Almost there....', size=(300, 40)):
        gtk.Dialog.__init__(self, title=title, flags=gtk.DIALOG_MODAL)

        if parent is not None:
            self.set_transient_for(parent)

        self.bar = gtk.ProgressBar()
        self.bar.set_size_request(size[0], size[1])

        self.bar.set_text(msg)
        self.bar.set_fraction(0)
        self.bar.show()
        self.vbox.pack_start(self.bar)

def raise_msg_to_str(msg):
    """msg is a return arg from a raise.  Join with new lines"""
    if not is_string_like(msg):
        msg = '\n'.join(map(str, msg))
    return msg
    
def error_msg(msg, parent=None):
    dialog = gtk.MessageDialog(
        parent         = None,
        type           = gtk.MESSAGE_ERROR,
        buttons        = gtk.BUTTONS_OK,
        message_format = msg)
    if parent is not None:
        dialog.set_transient_for(parent)
    dialog.show()
    dialog.run()
    dialog.destroy()
    return None

def simple_msg(msg, parent=None):
    dialog = gtk.MessageDialog(
        parent         = None,
        type           = gtk.MESSAGE_INFO,
        buttons        = gtk.BUTTONS_OK,
        message_format = msg)
    if parent is not None:
        dialog.set_transient_for(parent)

    dialog.show()
    dialog.run()
    dialog.destroy()
    return None

def _get_label(l):
    if type(l)==type(''): return l
    else: return l.get_label()
        
def str2num_or_err(s, labelWidget, parent=None):
    label = _get_label(labelWidget)
    try: return float(s)
    except ValueError:
        return error_msg('%s entry must be a number; you entered "%s"' %
                  (label, s), parent)

def str2posnum_or_err(s, labelWidget, parent=None):
    label = _get_label(labelWidget)
    val = str2num_or_err(s, labelWidget, parent)
    if val > 0 or val is None: return val

    msg = '%s must be a positive number.\nYou supplied "%s"' %\
          (label, s)

    return error_msg(msg, parent)

def str2negnum_or_err(s, labelWidget, parent=None):
    label = _get_label(labelWidget)
    val = str2num_or_err(s, labelWidget, parent)
    if val < 0 or val is None: return val

    msg = '%s must be a positive number.\nYou supplied "%s"' %\
          (label, s)

    return error_msg(msg, parent)

def str2int_or_err(s, labelWidget, parent=None):
    label = _get_label(labelWidget)
    try: return int(s)
    except ValueError:
        if s.find('0x')==0: # looks like hex
            try: return int(s, 16)
            except ValueError: # ok, I give up
                msg = '%s must be an integer.\nYou supplied "%s"' %\
                      (label, s)

    return error_msg(msg, parent)

def str2posint_or_err(s, labelWidget, parent=None):
    label = _get_label(labelWidget)
    val = str2int_or_err(s, labelWidget, parent)
    if val > 0 or val is None: return val

    msg = '%s must be a positive integer.\nYou supplied "%s"' %\
          (label, s)

    return error_msg(msg, parent)

def str2negint_or_err(s, labelWidget, parent=None):
    label = _get_label(labelWidget)
    val = str2int_or_err(s, labelWidget, parent)
    if val < 0 or val is None: return val

    msg = '%s must be a negative integer.\nYou supplied "%s"' %\
          (label, s)

    return error_msg(msg, parent)


