
class Artist:
    "Abstract base class for someone who renders into a Figure"

    def __init__(self):
        self._drawable = None
        self._lod = 0
        self._dpi = 72
        
    def clip_gc(self, gc):
        "The gc clipping function; no clip by default"        
        #print 'artist do nothing'
        pass

    def set_dpi(self, dpi):
        self._dpi = dpi
        
    def set_child_attr(self, attr, val):
        """
        Set attribute attr for self, and all child artists
        """
        setattr(self, attr, val)
        for c in self.get_child_artists():
            c.set_child_attr(attr, val)

    def get_child_artists(self):
        'Return all artists contained in self'
        return []


    def get_window_extent(self):
        """
        Return the bounding box as left, bottom, width, height in
        window coords
        """
        l, b, w, h = self.get_data_extent()
        w, h = self.transform_xyscale_to_display(w, h)
        l, b = self.transform_xy_to_display(l, b)
        return l, b, w, h
         

    def get_data_extent(self):
        """
        Return the bounding box as left, bottom, width, height in
        data coords of the area
        """
        raise NotImplementedError, "Derived must override"

    def transform_xy_to_display(self, x, y):
        """
        Transform the points x, y to window coords. Default is convert
        to int
        """
        return x,y

    def transform_xyscale_to_display(self, xscale, yscale):
        """
        Transform the xscale, yscale to window coords. Default is
        convert to int
        """
        return xscale, yscale

    def transform_xy_to_user(self, x, y):
        """
        Transform the points x, y to user coords from window. Default
        is convert to int
        """
        return x,y

    def transform_xyscale_to_user(self, xscale, yscale):
        """
        Transform the xscale, yscale to user coords from window
        coords. Default is convert to int
        """
        return xscale, yscale

    def get_dpi(self):
        """
        Get the DPI of the display
        """
        return self._dpi


    def set_size(self, figsize, dpi):
        """
        Set the figsize and dpi
        """
        self._figsize = figsize
        self._dpi = dpi

        for a in self.get_child_artists():
            a.set_size(figsize, dpi)

    def draw(self, drawable=None, *args, **kwargs):
        'Derived classes drawing method'
        if drawable is None: drawable = self._drawable
        if drawable is None: return
        self._draw(drawable, *args, **kwargs)

    def _draw(self, drawable, *args, **kwargs):
        'Derived classes drawing method'
        raise NotImplementedError, 'Derived must override'

    def set_renderer(self, renderer):
        'Set the renderer'
        self._drawable = renderer
        for a in self.get_child_artists():
            a.set_renderer(renderer)

    def set_lod(self, on):
        """
        Set Level of Detail on or off.  If on, the artists may examine
        things like the pixel width of the axes and draw a subset of
        their contents accordingly
        """
        self._lod = on

        
    def wash_brushes(self):
        'Erase any state vars that would impair a draw to a clean palette'

        for artist in self.get_child_artists():
            artist.wash_brushes()

            
