"""
A gd backend http://newcenturycomputers.net/projects/gdmodule.html

Right now this does nothing and is just a place holder for backend to
come!
"""

import sys, os, math
import distutils.sysconfig

try: import gd
except ImportError:
    print >>sys.stderr, 'You must first install the gd module http://newcenturycomputers.net/projects/gdmodule.html'


from matplotlib.backend_bases import RendererBase, GraphicsContextBase,\
     FigureBase, AxisTextBase, _process_text_args, error_msg
from matplotlib._matlab_helpers import FigureManagerBase, GcfBase

defaultDPI =     150     # the default dots per inch resolution
defaultFigSize = (7,5)   # the default canvas size in inches
#defaultFigSize = (10,10)


def error_msg_template(msg, *args):
    """
    Signal an error condition -- in a GUI, popup a error dialog
    """
    print >>sys.stderr, 'Error:', msg
    sys.exit()
    
class RendererGD(RendererBase):
    """
    The renderer handles all the drawing primitives using a graphics
    context instance that controls the colors/styles
    """

    # todo: can gd support cap and join styles?
    def __init__(self, im):
        "Initialize the renderer with a gd image instance"
        self.im = im
        self._cached = {}  # a map from get_color args to colors

        self.width, self.height = im.size()
        
    def draw_arc(self, gc, filled, x, y, width, height, angle1, angle2):
        """
        Draw an arc centered at x,y with width and height and angles
        from 0.0 to 360.0
        """
        # todo: are angles in degrees or radians?
        color = self.get_gd_color(gc)
        center = int(x), self.height-int(y)
        wh = int(width), int(height)

        #print angle1, angle2
        self.im.arc(center, wh, int(angle1), int(angle2), color)
        if filled: self.im.fill( center, color)

    def draw_line(self, gc, x1, y1, x2, y2):
        """
        Draw a single line from x1,y1 to x2,y2
        """
        self._set_gd_style(gc)        
        self.im.line((int(x1),self.height-int(y1)),
                     (int(x2), self.height-int(y2)),
                     gd.gdStyled)
    
    def draw_lines(self, gc, x, y):
        """
        x and y are equal length arrays, draw lines connecting each
        point in x, y
        """
        self._set_gd_style(gc)
        points = [ (int(thisx),self.height-int(thisy))
                   for thisx,thisy in zip(x,y)]
        self.im.lines(points, gd.gdStyled)

    
    def draw_polygon(self, gc, filled, points):
        """
        Draw a polygon.  points is a len vertices tuple, each element
        giving the x,y coords a vertex
        """

        color = self.get_gd_color(gc)

        points = [(int(x), self.height-int(y)) for x,y in points]

        if filled:
            self.im.filledPolygon(points, color)
        else:
            self.im.polygon(points, color)

        

    def draw_rectangle(self, gc, filled, x, y, width, height):
        """
        Draw a rectangle at lower left x,y with width and height
        If filled=True, fill the rectangle with the gc foreground
        gc is a GraphicsContext instance
        """

        lb = int(x), self.height-int(y)
        ur = int(x+width), self.height-int((y+height))
        color = self.get_gd_color(gc)
        if filled:
            self.im.filledRectangle(ur, lb, color)
        else:
            self.im.rectangle(ur, lb, color)

    def draw_point(self, gc, x, y):
        """
        Draw a single point at x,y
        """
        self.im.setPixel((int(x),self.height-int(y)),
                         self.get_gd_color(gc))


    def finish(self):
        pass
        #self.im.writePng( file('xx.png', 'w') )

    def new_gc(self):
        """
        Return an instance of a GraphicsContextGD
        """
        #size = self.im.size()
        #return GraphicsContextGD( gd.image(size) )
        return GraphicsContextGD( self.im )

    def get_gd_color(self, gc):
        """
        RGB is a unit RGB tuple, return a gd color
        """

        rgb = gc.get_rgb()
        try: return self._cached[rgb]
        except KeyError: pass
        
        r,g,b = rgb
        color = self.im.colorAllocate( (int(r*255),int(g*255),int(b*255)) )
        self._cached[rgb] = color
        return color

    def _set_gd_style(self, gc):
        color = self.get_gd_color(gc)
        offset, dashes = gc.get_dashes()

        if dashes is not None:
            style = []
            for on, off in zip(dashes[:-1], dashes[1:]):
                style.extend([color]*int(on))
                style.extend([gd.gdTransparent]*int(off))
        else: style=[color]
        self.im.setStyle(style)

        
class GraphicsContextGD(GraphicsContextBase):
    """
    The graphics context provides the color, line styles, etc...  See
    the gtk and postscript backends for examples of mapping the
    graphics context attributes (cap styles, join styles, line widths,
    colors) to a particular backend.      """
    def __init__(self, im):
        """
        Initialize with a gd image
        """
        GraphicsContextBase.__init__(self)
        self.im = im
        
              
class FigureGD(FigureBase):
    """
    The figure is the main object -- it contains the Axes and Text,
    which in turn contain lines, patches, and more text
    """
    def __init__(self, figsize=defaultFigSize, dpi=defaultDPI):
        FigureBase.__init__(self, figsize, dpi)
        self._isRealized = False
        self._width = int(self._width)
        self._height = int(self._height)


    def draw(self, drawable, *args, **kwargs):
        """
        Render the figure using RendererGD instance drawable
        """
        # draw the figure bounding box, perhaps none for white figure
        #self._figurePatch.draw(drawable)

        # render the axes
        for a in self.axes:
            a.wash_brushes()
            a.draw(drawable)

        # render the figure text
        for t in self._text:
            t.draw(drawable)
    
    def print_figure(self, filename, dpi):
        """
        Render the figure to hardcopy using self.drawable as the
        renderer if neccessary

        # todo -- how should we handle dpi?
        """

        self.dpi = dpi
        self._width, self._height = self.figsize[0]*dpi, self.figsize[1]*dpi

        self._figurePatch.set_width(self._width)
        self._figurePatch.set_height(self._height)
        im = gd.image((int(self._width), int(self._height)))
        drawable = RendererGD(im)
        for a in self.axes:
            a.set_child_attr('_im', im)
            a.set_size(self.figsize, dpi) # todo redundant

        for t in self._text:
            t.set_child_attr('_im', im)
            t.set_size(self.figsize, dpi) # todo redundant


        self.draw(drawable)
        drawable.finish()

        basename, ext = os.path.splitext(filename)
        if not len(ext): filename += '.png'
        im.writePng( file(filename, 'w') )
        # todo allow write jpg based on identified extension


    def realize(self, *args):
        """
        This method will be called when the system is ready to draw,
        eg when a GUI window is realized
        """
        # nothing to do cause we have no display
        pass
    
    def text(self, x, y, s, *args, **kwargs):
        """
        Add text to figure at location x,y (relative 0-1 coords) See
        the help for matlab text command for the meaning of the other arguments
        """
        # Something like the following

        def to_display(x,y):
            # your actual conversion func to display coords here
            return self._width*x, self._height*y 

        def clip_gc(gc):
            # your actual gc clip func here
            gc.set_clip_rectangle( (0, 0, self._width, self._height) )

        override = _process_text_args({}, *args, **kwargs)
        t = AxisTextGD( x=x, y=y, text=s, **override)
        t.transform_xy_to_display = to_display
        t.clip_gc = clip_gc
        self._text.append(t)
        return t




class AxisTextGD(AxisTextBase):    
    """
    Handle storing and drawing of text
    """

    def __init__(self, x=0, y=0, text='',
                 color='k',
                 verticalalignment='bottom',
                 horizontalalignment='left',
                 fontname='Vera',
                 fontsize=10,
                 fontweight='normal',
                 fontangle='normal',
                 rotation=None,
                 ):
        AxisTextBase.__init__(
            self, x, y, text, color,
            verticalalignment, horizontalalignment,
            fontname, fontsize, fontweight, fontangle,
            rotation)
        #print self._fontname
        self._font = fontManager.findfont(fontname, fontweight, fontangle)
        
    def _compute_offsets(self):
        """
        Return the (x,y) offsets to adjust for the alignment
        specifications
        """
        scale = self._dpi/96.0
        #scale = 1.0
        try:
            llx, lly, lrx, lry, urx, ury, ulx, uly = \
                 self._im.get_bounding_rect(
                self._font, scale*self._fontsize, 0.0, (0,0), self._text)
        except ValueError:
            error_msg('Could not load font %s.  Try setting GDFONTPATH to include this font' % self._font)
            
        w = lrx - llx
        h = lry - ury
        #print self._text, llx, lrx, lry, ury
        if self._rotation=='vertical':
            w, h = h, w
            if self._horizontalalignment=='center': offsetx = -w/2
            elif self._horizontalalignment=='right': offsetx = -w
            else: offsetx = 0

            if self._verticalalignment=='center': offsety = -h/2
            elif self._verticalalignment=='top': offsety = -h
            else: offsety = 0
        else:
            if self._horizontalalignment=='center': offsetx = -w/2
            elif self._horizontalalignment=='right': offsetx = -w
            else: offsetx = 0

            if self._verticalalignment=='center': offsety = -h/2
            elif self._verticalalignment=='top': offsety = -h
            else: offsety = 0

        #print self._text, (offsetx, offsety) 
        return (offsetx, offsety)

    def _draw(self, drawable, *args, **kwargs):
        """
        Render the text using the RendererGD instance
        """

        if self._reset: self._set_font()
        x, y = self.transform_xy_to_display(self._x, self._y)
        ox, oy = self._compute_offsets()

        pos = int(x+ox), drawable.height-int(y+oy)
        gc = drawable.new_gc()
        self.clip_gc(gc)
        gc.set_foreground(self._color)
        color = drawable.get_gd_color(gc)

        if self._rotation=='vertical': angle=math.pi/2.0
        else: angle = 0

        scale = self._dpi/96.0
        #print self._text, self._font, self._fontsize, self._font
        self._im.string_ft(self._font, scale*self._fontsize, angle,
                            pos, self._text, color)

        #self._im.string(2, pos, self._text, color)
        self._drawable = drawable
         
    def get_data_extent(self):
        """
        Return the ink extent of the text as (lower, bottom, width, height)
        """
        scale = self._dpi/96.0
        #scale = 1.0
        x, y = self.transform_xy_to_display(self._x, self._y)
        ox, oy = self._compute_offsets()
        llx, lly, lrx, lry, urx, ury, ulx, uly = \
             self._im.get_bounding_rect(
            self._font, scale*self._fontsize, 0.0, (0,0), self._text)
        
        return (int(x+ox), int(y+oy), lrx-llx, lly-uly)
    
    def _set_font(self):
        """
        Update any font information; this function will be called if
        font state (eg, fontsize, fontweight) has been changed
        """
        self._font = fontManager.findfont(
            self._fontname, self._fontweight, self._fontangle)
        
########################################################################
#    
# The following functions and classes are for matlab compatibility
# mode (matplotlib.matlab) and implement figure managers, etc...
#
########################################################################

def draw_if_interactive():
    """
    This should be overriden in a windowing environment if drawing
    should be done in interactive python mode
    """
    pass

def show():
    """
    This is usually the last line of a matlab script and tells the
    backend that it is time to draw.  In interactive mode, this may be
    a do nothing func.  See the GTK backend for an example of how to
    handle interactive versus batch mode
    """
    for figwin in GcfGD.get_all_figwins():
        figwin.figure.realize()


class GcfGD(GcfBase):
    """
    This class wraps the current figure instance and instantiates new
    figures if noe are current
    """
    def __init__(self, num=None, pagesize=(7,5), dpi=300):
        GcfBase.__init__(
            self, num, defaultFigSize, defaultDPI)

        
    def newfig(self, num=None, figsize=defaultFigSize, dpi=defaultDPI):
        """
        Add a new figure num (default autoincrement).  For GUI
        backends, you'll need to instantiate a new window and embed
        the figure in it.
        """
        if num is None:
            if len(self.figs)>0:
                num = max(self.figs.keys())+1
            else:
                num = 1
        
        thisFig = FigureGD(figsize=figsize, dpi=dpi)
        figwin = FigureManagerGD(thisFig, num)
        self.figs[num] = figwin
        return figwin

class FigureManagerGD(FigureManagerBase):
    """
    This class manages all the figures for matlab mode
    """
    pass

class FontManager:
    from ttfquery import ttffiles, describe
    from ttfquery._scriptregistry import registry, registryFile

    paths = [os.path.join(distutils.sysconfig.PREFIX, 'share', 'matplotlib')]
 
    if os.environ.has_key('GDFONTPATH'):
        gdpath = os.environ['GDFONTPATH']
        if gdpath.find(';')>0: #win32 style
            paths.extend(gdpath.split(';'))
        elif gdpath.find(':')>0: # unix style
            paths.extend(gdpath.split(':'))
        else:
            paths.append(gdpath)
    #print 'PATHS', paths
    new, failed = registry.scan( paths, printErrors = 1, force = 0)
    registry.save(registryFile)

    cache = {}

    def findfont(self, fontname, weight, italics):
        origname = fontname
        fontname = fontname.lower()

        if italics.find('ital')>=0: italics = 1
        elif italics.find('oblique')>=0: italics = 1 # todo fixme for oblique
        else: italics = None
        
        try: return self.cache[ (fontname, weight, italics) ]
        except KeyError: pass
        
        for name, table in self.registry.fonts.items():
            if name.lower().find(fontname)<0: continue

            items = table.items()
            items.sort()

            if weight is not None:
                weight = self.describe.weightNumber( weight )
                items = [item for item in items if item[0][0]==weight]
            if italics is not None:
                items = [item for item in items if item[0][1]==italics]
            if len(items):
                match = items[0][1][0]
                fullpath = self.registry.fontFile( match )
                head, tail = os.path.split(fullpath)
                fname, ext = os.path.splitext(tail)
                self.cache[ (fontname, weight, italics) ] = fullpath
                return fullpath
        default = self.get_default_font(origname)
        self.cache[ (fontname, weight, italics) ] = default
        return default

    def get_default_font(self, fontname):
        print >>sys.stderr, 'Could not find requested font %s\n' % fontname + \
        'Please set environment var GDFONTPATH to point to your true type fonts (*.ttf)'

        if fontname.lower()=='vera':
            error_msg('Could not find any fonts or the default Vera\n' +
                      'Please check your GDFONTPATH')
        print >>sys.stderr, 'Could not find %s; falling back on Vera' % fontname
        return os.path.join(distutils.sysconfig.PREFIX,
                            'share', 'matplotlib', 'Vera.ttf')


fontManager = FontManager()

########################################################################
#    
# Now just provide the standard names that backend.__init__ is expecting
# 
########################################################################

Gcf = GcfGD
FigureManager = FigureManagerGD
AxisText = AxisTextGD
Figure = FigureGD
error_msg = error_msg_template
         
