from __future__ import division

import os

try:  # todo: test this with default RHL8 install.
    import pygtk
    pygtk.require('2.0')
except:
    print >>sys.stderr, 'matplotlib requires pygtk-1.99.16 or greater -- trying anyway.  Please hold on'


import gobject
import gtk
from gtk import gdk
import pango

from Numeric import array, Int16
from matplotlib.cbook import iterable, is_string_like, flatten, enumerate
from matplotlib.backend_bases import RendererBase, GraphicsContextBase,\
     AxisTextBase, FigureBase, _process_text_args
from matplotlib._matlab_helpers import FigureManagerBase, GcfBase
from matplotlib.artist import Artist

class ColorManagerGTK:
    _cached = {}  # a map from get_color args to colors
    _cmap = None
    
    def set_drawing_area(self, da):
        self._cmap = da.get_colormap()

    def get_color(self, rgb):
        """
        RGB is a unit RGB tuple, return a gtk.gdk.Color
        """

        try: return self._cached[tuple(rgb)]
        except KeyError: pass
        
        if self._cmap is None:
            raise RuntimeError('First set the drawing area!')

        #print 'rgb is', rgb
        r,g,b = rgb
        color = self._cmap.alloc_color(int(r*65025),int(g*65025),int(b*65025))
        self._cached[tuple(rgb)] = color
        return color

colorManager = ColorManagerGTK()

class RendererGTK(RendererBase):
    def __init__(self, gdkDrawable):
        self.gdkDrawable = gdkDrawable
        self.width, self.height = self.gdkDrawable.get_size()

    def draw_arc(self, gc, filled, x, y, width, height, angle1, angle2):
        """
        Draw an arc centered at x,y
        """
        self.gdkDrawable.draw_arc(
            gc.gdkGC, filled,
            int(x-0.5*width), self.height-int(y+0.5*height),
            int(width)+1, int(height)+1,
            int(angle1*64), int(angle2*64))


    def draw_line(self, gc, x1, y1, x2, y2):
        """
        Draw a single line from x1,y1 to x2,y2
        """
        self.gdkDrawable.draw_line(
            gc.gdkGC, int(x1), self.height-int(y1),
            int(x2), self.height-int(y2))


    def draw_lines(self, gc, x, y):
        # todo: change signature to draw_lines(self, gc, x, y)
        # todo: this is darn ineffiencient!
        y = self.height - y.astype(Int16)
        x = x.astype(Int16)
        self.gdkDrawable.draw_lines(gc.gdkGC, zip(x,y))

    def draw_point(self, gc, x, y):
        """
        Draw a single point at x,y
        """
        self.gdkDrawable.draw_point(
            gc.gdkGC, int(x), self.height-int(y))

    def draw_polygon(self, gc, filled, points):
        """
        Draw a polygon.  points is a len vertices tuple, each element
        giving the x,y coords a vertex
        """
        points = [(int(x), self.height-int(y)) for x,y in points]
        self.gdkDrawable.draw_polygon(
            gc.gdkGC, filled, points)

    def draw_rectangle(self, gc, filled, x, y, width, height):
        """
        Draw a rectangle at lower left x,y with width and height
        If filled=True, fill the rectangle with the gc foreground
        gc is a GraphicsContext instance
        """
        self.gdkDrawable.draw_rectangle(
            gc.gdkGC, filled, int(x), self.height-int(y+height),
            int(width), int(height))

    def new_gc(self):
        return GraphicsContextGTK(self.gdkDrawable.new_gc(), self)


class GraphicsContextGTK(GraphicsContextBase):

    _joind = {
        'bevel' : gdk.JOIN_BEVEL,
        'miter' : gdk.JOIN_MITER,
        'round' : gdk.JOIN_ROUND,
        }

    _capd = {
        'butt' : gdk.CAP_BUTT,
        'projecting' : gdk.CAP_PROJECTING,
        'round' : gdk.CAP_ROUND,
        }

        
    def __init__(self, gdkGC, drawable):
            GraphicsContextBase.__init__(self)
            self.gdkGC = gdkGC
            self.drawable = drawable

    def set_clip_rectangle(self, rectangle):
        GraphicsContextBase.set_clip_rectangle(self, rectangle)
        l,b,w,h = rectangle
        rectangle = (int(l), self.drawable.height-int(b+h),
                     int(w), int(h))
        self.gdkGC.set_clip_rectangle(rectangle)        


    def set_dashes(self, dash_offset, dash_list):
        GraphicsContextBase.set_dashes(self, dash_offset, dash_list)
        self.gdkGC.line_style = gdk.LINE_ON_OFF_DASH
        dl = [int(val) for val in dash_list]
        self.gdkGC.set_dashes(dash_offset, dl)
        
    def set_foreground(self, fg):
        """
        Set the foreground color.  fg can be a matlab format string, a
        html hex color string, an rgb unit tuple, or a float between 0
        and 1.  In the latter case, grayscale is used.
        """
        GraphicsContextBase.set_foreground(self, fg)
        self.gdkGC.foreground = self._get_gdk_color()

    def set_graylevel(self, frac):
        """
        Set the foreground color to be a gray level with frac frac
        """
        GraphicsContextBase.set_graylevel(self, frac)
        self.gdkGC.foreground = self._get_gdk_color()
        

    def set_linewidth(self, w):
        if w>0 and w<1: w = 1
        GraphicsContextBase.set_linewidth(self, w)
        self.gdkGC.line_width = self._linewidth

    def set_capstyle(self, cs):
        """
        Set the capstyle as a string in ('butt', 'round', 'projecting')
        """
        GraphicsContextBase.set_capstyle(self, cs)
        self.gdkGC.cap_style = self._capd[self._capstyle]

    def set_joinstyle(self, js):
        """
        Set the join style to be one of ('miter', 'round', 'bevel')
        """
        GraphicsContextBase.set_joinstyle(self, js)
        self.gdkGC.join_style = self._joind[self._joinstyle]

    def _get_gdk_color(self):
        return colorManager.get_color(self.get_rgb())


    def _update_gc_line_attributes(self):
        lw = self._linewidth
        js = self._joind[self._joinstyle]
        cs = self._capd[self._capstyle]
        
class FigureGTK(FigureBase, gtk.DrawingArea):
    def __init__(self, figsize, dpi):
        FigureBase.__init__(self, figsize, dpi)
        gtk.DrawingArea.__init__(self)
        self.set_double_buffered(False)
        w = figsize[0]*dpi
        h = figsize[1]*dpi

        self.set_size_request(w,h)

        #self.connect('focus_in_event', self.focus_in_event)
        self.connect('expose_event', self.expose_event)
        self.connect('configure_event', self.configure_event)
        self.connect('realize', self.realize)
        self.connect('motion_notify_event', self.motion_notify_event)
        self.connect('button_press_event', self.button_press_event)
        self.connect('button_release_event', self.button_release_event)

        self.set_events(
            #gdk.FOCUS_CHANGE_MASK|
                        gdk.EXPOSURE_MASK |
                        gdk.LEAVE_NOTIFY_MASK |
                        gdk.BUTTON_PRESS_MASK |
                        gdk.BUTTON_RELEASE_MASK |
                        gdk.POINTER_MOTION_MASK )
        

        self.inExpose = 0
        self.isConfigured=0
        self.isRealized=0
        self.printQued = []
        self.drawingArea = None


        self.grey = ( 0.7, 0.7, 0.7)
        self._drawingArea = None

    def add_axis(self, a):
        FigureBase.add_axis(self, a)
        if self.isConfigured:
            a.set_fig_bgcolor(self.grey)
            a.set_size( self.figsize, self.dpi)
            a.set_dpi( self.dpi)
            a.set_child_attr('_drawingArea', self.drawingArea)
            a.set_renderer(self.drawable)


    def button_press_event(self, widget, event):
        pass
    def button_release_event(self, widget, event):
        pass
    def motion_notify_event(self, widget, event):
        pass
        
        
    def configure_event(self, widget, event=None):
        self.drawingArea = widget
        self.drawable = RendererGTK(self.drawingArea.window)
        colorManager.set_drawing_area(widget)

        self.width, self.height = self.drawable.gdkDrawable.get_size()
        
        # handle window resizes properly
        if not self.isConfigured:
            self._origWidth, self._origHeight = self.width, self.height

        scalew = self.width/self._origWidth
        scaleh = self.height/self._origHeight
        figsize = self.figsize[0]*scalew,self.figsize[1]*scaleh
        for a in self.axes:
            a.set_fig_bgcolor(self.grey)
            a.set_size( figsize, self.dpi)
            a.set_dpi( self.dpi)
            a.set_child_attr('_drawingArea', widget)
            a.set_renderer(self.drawable)

        def clip_gc(gc):
            gc.set_clip_rectangle( (0, 0, self.width, self.height) )

        for t in self._text:
            t.clip_gc = clip_gc
            t.set_child_attr('_drawingArea', widget)
            t.set_dpi( self.dpi)
            t.set_renderer(self.drawable)

        self.isConfigured=True
        if self.isConfigured and self.isRealized:
            self.draw()

        return True
        

    def draw(self, drawable=None, *args, **kwargs):
        if drawable is None: drawable=self.drawable
        if drawable is None: return 
        self.drawable = drawable
        if not self.isRealized: return 
        
        gc = drawable.new_gc()

        pixmap = RendererGTK(gtk.gdk.Pixmap(
            self.drawable.gdkDrawable, self.width, self.height))
        
        if self.inExpose:
            # override the clip
            gc.set_clip_rectangle((0, 0, self.width, self.height))
            
        gc.set_foreground(self.grey)
        pixmap.gdkDrawable.draw_rectangle(
            gc.gdkGC, 1, 0, 0, self.width, self.height)

        for a in self.axes:
            a.wash_brushes()
            a.draw(pixmap)
        for t in self._text:
            t.draw(pixmap)
            
        drawable.gdkDrawable.draw_drawable(
            gc.gdkGC, pixmap.gdkDrawable, 0, 0, 0, 0, self.width, self.height)


    def expose_event(self, widget, event):
        if self.isConfigured and self.isRealized:
            self.inExpose = 1
            for a in self.axes:
                a.wash_brushes()
            self.draw()
            self.inExpose = 0
        return True

    def focus_in_event(self, widget, event):
        return True


    def print_figure(self, filename, dpi=300):
        "Print figure to filename; png or jpeg"

        
        root, ext = os.path.splitext(filename)
        ext = ext.lower()[1:]
        if not len(ext):
            filename = filename + '.png'
            ext = 'png'
        
        if ext=='png': type = 'png'
        elif ext in ('jpg', 'jpeg'): type = 'jpeg'
        else:
            error_msg_gtk('Can only save to formats png or jpeg')            
            return

        if not self.isRealized:
            self.printQued.append((filename, dpi))
            return


        for a in self.axes:
            a.wash_brushes()
            a.set_size( self.figsize, dpi)

        for t in self._text:
            t.set_size( self.figsize, dpi)


        width, height = self.figsize[0]*dpi, self.figsize[1]*dpi

        gc = self.drawable.new_gc()
        gc.set_foreground('w')
        gdrawable = self.drawable.gdkDrawable
        ggc = gc.gdkGC
        
        pixmap = RendererGTK(gtk.gdk.Pixmap(gdrawable, width, height))

        pixmap.draw_rectangle(gc, True, 0, 0, width, height)

        def new_to_win(x,y):
            return  width*x, height*y

        old_to_win = []

        
        for axis in self.axes:
             axis.set_size(self.figsize, dpi)

        for t in self._text:
            old_to_win.append(t.transform_xy_to_display)
            t.transform_xy_to_display = new_to_win



        for axis in self.axes:
            axis.draw(pixmap)
        for t in self._text:
            t.draw(pixmap)
        #TODO reset figure text clip gc here?
             
        pixbuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, 0, 8, width, height)
        pixbuf.get_from_drawable(pixmap.gdkDrawable, gdrawable.get_colormap(),
                                 0, 0, 0, 0, width, height)

        try: pixbuf.save(filename, type)
        except gobject.GError, msg:
            self.configure_event(self.drawingArea, 'configure')
            self.draw()
            msg = raise_msg_to_str(msg)
            # note the error must be displayed here because trapping
            # the error on a call or print_figure may not work because
            # printing can be qued and called from realize
            error_msg_gtk('Could not save figure to %s\n\n%s' % (
                filename, msg))
        else:
            # successful draw, reset
            self.configure_event(self.drawingArea, 'configure')
            self.draw()

        for t,f in zip(self._text,old_to_win):
            t.transform_xy_to_display = f

    def realize(self, widget):
        if widget is None: return 
        self.drawable = RendererGTK(widget.window)

        for a in self.axes:
            a.set_renderer(self.drawable)
            a.set_child_attr('_drawingArea', widget)
        for t in self._text:
            t.set_renderer(self.drawable)
            t.set_child_attr('_drawingArea', widget)


        self.isRealized = True
        for fname, dpi in self.printQued:
            self.print_figure(fname, dpi)
        self.printQued = []

        return True


    def is_realized(self):
        return self.isRealized


    def text(self, x, y, s, *args, **kwargs):
        """
        Add text to figure at location x,y (relative 0-1 coords) See
        the help for Axis text for the meaning of the other arguments

        """

        def to_win(x,y):
            size = self.drawable.gdkDrawable.get_size()
            #print 'drawing with size', size
            width, height = size
            return  width*x, height*y

        def identity(x,y):
            return x,y

        def noclip(gc):
            #print 'doing nothing'
            pass

        def clip_gc(gc):
            gc.set_clip_rectangle( (0, 0, self._width, self._height) )

        
        override = _process_text_args({}, *args, **kwargs)
        t = AxisTextGTK(
            x=x, y=y, text=s,
            **override)
        t.transform_xy_to_display = to_win
        t.transform_xyscale_to_display = identity
        t.clip_gc = clip_gc
        t.set_child_attr('_drawingArea', self._drawingArea)
        self._text.append(t)
        return t



def raise_msg_to_str(msg):
    """msg is a return arg from a raise.  Join with new lines"""
    if not is_string_like(msg):
        msg = '\n'.join(map(str, msg))
    return msg
    
def error_msg_gtk(msg, parent=None):
    dialog = gtk.MessageDialog(
        parent         = None,
        type           = gtk.MESSAGE_ERROR,
        buttons        = gtk.BUTTONS_OK,
        message_format = msg)
    if parent is not None:
        dialog.set_transient_for(parent)
    dialog.show()
    dialog.run()
    dialog.destroy()
    return None


class AxisTextGTK(AxisTextBase):
    """
    Handle storing and drawing of text in window or data coordinates
    """
    fontweights = {'normal' : pango.WEIGHT_NORMAL,
                   'bold' : pango.WEIGHT_BOLD,
                   'heavy' : pango.WEIGHT_HEAVY,
                   'light' : pango.WEIGHT_LIGHT,
                   'normal' : pango.WEIGHT_NORMAL,
                   'ultrabold' : pango.WEIGHT_ULTRABOLD,
                   'ultralight' : pango.WEIGHT_ULTRALIGHT,
                   }
    fontangles = {
        'italic': pango.STYLE_ITALIC,
        'normal' : pango.STYLE_NORMAL,
        'oblique' : pango.STYLE_OBLIQUE,
        }


    def __init__(self, x=0, y=0, text='',
                 color='k',
                 verticalalignment='bottom',
                 horizontalalignment='left',
                 fontname='Sans',
                 fontsize=10,
                 fontweight='normal',
                 fontangle='normal',
                 rotation=None,
                 ):
        AxisTextBase.__init__(
            self, x, y, text, color,
            verticalalignment, horizontalalignment,
            fontname, fontsize, fontweight, fontangle,
            rotation)
        self._drawingArea = None # will be set by set_child_attr in figure

    def _compute_offsets(self):
        """
        Return the (x,y) offsets to adjust for the alignment
        specifications
        """
        if self._drawable and self._drawingArea is None: return 0,0
        try: self._width
        except AttributeError: self._set_font()

        
        if self._rotation=='vertical':
            w, h = self._height, self._width
            if self._horizontalalignment=='center': offsetx = -w/2
            elif self._horizontalalignment=='right': offsetx = -w
            else: offsetx = 0

            if self._verticalalignment=='center': offsety = -h/2
            elif self._verticalalignment=='top': offsety = 0
            else: offsety = -h
        else:
            if self._horizontalalignment=='center': offsetx = -self._width/2
            elif self._horizontalalignment=='right': offsetx = -self._width
            else: offsetx = 0

            if self._verticalalignment=='center': offsety = self._height/2
            elif self._verticalalignment=='top': offsety = 0
            else: offsety = self._height

        return (offsetx, offsety)

    def _draw(self, drawable, *args, **kwargs):
        """
        Render the text to the drawable (or defaul drawable is drawable is None
        """
        if drawable is None and self._drawingArea is None and self._drawable is None: return 
        if drawable is not None: self._drawable = drawable


        if self._text=='': return
        if self._reset: self._set_font()
        
        x, y = self.transform_xy_to_display(self._x, self._y)
        ox, oy = self._compute_offsets()

        gc = drawable.new_gc()
        self.clip_gc(gc)
        gc.set_foreground(self._color)

        if self._rotation=='vertical':            
            drawn = self.draw_rotated(drawable, gc)
            if not drawn: return 
        else:
            inkRect, logicalRect = self._layout.get_pixel_extents()
            w, h = logicalRect[2], logicalRect[3]
            if y+oy<0:
                print 'Warning: text label "%s" is outside window extent' % self._text
            if x+ox<0:
                print 'Warning: text label "%s" is outside window extent' % self._text
                

            xox = int(x+ox)
            yoy = drawable.height - int(y+oy)

            drawable.gdkDrawable.draw_layout(
                gc.gdkGC, x=xox, y=yoy,
                layout=self._layout)

        self._reset = 0

    def draw_rotated(self, drawable, gc):
        """
        Draw the text rotated 90 degrees
        """

        gdrawable = drawable.gdkDrawable
        ggc = gc.gdkGC
        
        inkRect, logicalRect = self._layout.get_pixel_extents()
        w, h = int(logicalRect[2]), int(logicalRect[3])

        # get the background image
        ox, oy = self._compute_offsets()
        x, y = self.transform_xy_to_display(self._x, self._y)
        y = drawable.height-y

        xox = max(0,int(x+ox))
        yoy = max(0,int(y+oy))

        imgBack = gdrawable.get_image(xox, yoy, h, w)
        if imgBack is None: return 0

        pixmap = gtk.gdk.Pixmap(self._drawingArea.window, w, h)
        

        # rotate the background image to horizontal to fill the pixmap
        # background
        imageHoriz = gtk.gdk.Image(type=0,
                                   visual=pixmap.get_visual(),
                                   width=w, height=h)
        imageHoriz.set_colormap(imgBack.get_colormap())
        for i in range(w):
            for j in range(h):
                imageHoriz.put_pixel(i, j, imgBack.get_pixel(j,w-i-1) )
                



        pixmap.draw_image(ggc, imageHoriz, 0, 0, 0, 0, w, h)

        pixmap.draw_layout(ggc, x=0, y=0, layout=self._layout)
        imageIn = pixmap.get_image(x=0, y=0, width=w, height=h)
        imageOut = gtk.gdk.Image(type=0,
                                 visual=pixmap.get_visual(),
                                 width=h, height=w)
        imageOut.set_colormap(imageIn.get_colormap())
        for i in range(w):
            for j in range(h):
                imageOut.put_pixel(j, i, imageIn.get_pixel(w-i-1,j) )


        pixbuf = gtk.gdk.Pixbuf(colorspace=gtk.gdk.COLORSPACE_RGB,
                                has_alpha=0, bits_per_sample=8,
                                width=h, height=w)
        pixbuf.get_from_image(src=imageOut, cmap=imageIn.get_colormap(),
                              src_x=0, src_y=0, dest_x=0, dest_y=0,
                              width=h, height=w)

        pixbuf.render_to_drawable(gdrawable, ggc,
                                  src_x=0, src_y=0,
                                  dest_x=xox, dest_y=yoy,
                                  width=h, height=w,
                                  dither=0, x_dither=0, y_dither=0)
        return 1

    def get_data_extent(self):
        'Get the pixel extents left, bottom, width, height'
        if self._drawingArea is None:
            return 0,0,0,0

        try: self._width
        except AttributeError: self._set_font()
        ox, oy = self._compute_offsets()
        inkRect, logicalRect = self._layout.get_pixel_extents()
        w, h = int(logicalRect[2]), int(logicalRect[3])
        x, y = self._x, self._y
        if self._rotation=='vertical':
            return (x+ox, y+oy+w, h, w)
        else:
            return (x+ox, y+oy-h, w, h)

    def __get_window_extent(self):
        try: self._layout
        except AttributeError: self._set_font()

        inkRect, logicalRect = self._layout.get_pixel_extents()
        return logicalRect
        
    def set_size(self, figsize, dpi):
        Artist.set_size(self, figsize, dpi)
        self._set_font()
        
    def _set_font(self):
        "Update the pango layout"
        if self._drawingArea is None: return

        self._font = pango.FontDescription(
            '%s' % self._fontname)
        self._font.set_weight(self.fontweights[self._fontweight])
        self._font.set_style(self.fontangles[self._fontangle])
        scale = self._dpi/screenDPI
        
        #print scale, self._dpi, screenDPI
        #print pango.SCALE
        self._font.set_size(int(scale*self._fontsize*1024))
        #self._font.set_size(int(scale*self._fontsize*pango.SCALE))
        self._context = self._drawingArea.create_pango_context()
        self._layout  = self._drawingArea.create_pango_layout(self._text)
        self._layout.set_font_description(self._font)    

        inkRect, logicalRect = self._layout.get_pixel_extents()
        
        self._width = int(logicalRect[2])
        self._height = int(logicalRect[3])


        return 1


class ShowOn:
    show = 0
    _mainloopOn = 0
    __sharedState = {}
    def __init__(self):
        self.__dict__= self.__sharedState

    def set(self, on):
        # show all the fig wins
        
        if not self.show:
            for figwin in GcfGTK.get_all_figwins():
                figwin.window.show()
                figwin.figure.draw()
            
        if on: self.show = 1
        else: self.show = 0
    def get(self):
        return self.show

    def enter_mainloop(self):
        self.set(1)
        self._mainloopOn = 1
        gtk.mainloop()

    def is_mainloop_on(self):
        return self._mainloopOn



def draw_if_interactive():
    if ShowOn().get():
        gcf =  Gcf().get_current_figwin().figure
        gcf.draw()
        gcf.queue_draw()


def show():
    """
    Show all the figures and enter the gtk mainloop

    This should be the last line of your script
    """
    ShowOn().enter_mainloop()


# what point to pixel coversion does GTK use?
screenDPI = 100
class GcfGTK(GcfBase):
    def __init__(self, num=None, figsize=(5,4), dpi=screenDPI):
        GcfBase.__init__(self, num, figsize, dpi)
        fig = self._get_active()
        win = fig.window.window

    def destroy(num):
        GcfBase.destroy(num)
        if GcfGTK.get_num_figwins()==0 and ShowOn().is_mainloop_on():
            gtk.mainquit()
    destroy = staticmethod(destroy)
    

    
    def newfig(self, num=None, figsize=(5,4), dpi=screenDPI):
        if num is None:
            if len(self.figs)>0:
                num = max(self.figs.keys())+1
            else:
                num = 1
        
        thisFig = FigureGTK(figsize=figsize, dpi=dpi)
        thisFig.show()
        win = gtk.Window()
        win.set_title("Figure %d" % num)
        win.set_border_width(5)

        vbox = gtk.VBox(spacing=3)
        win.add(vbox)
        vbox.show()
        vbox.pack_start(thisFig)

        def destroy(*args):
            GcfGTK.destroy(num)
        win.connect("destroy", lambda *args: destroy())
        toolbar = NavigationToolbar( thisFig, win)
        toolbar.show()
        vbox.pack_start(toolbar, gtk.FALSE, gtk.FALSE )
        figwin = FigureManagerGTK(thisFig, num, win, vbox, toolbar)
        self.figs[num] = figwin
        if ShowOn().get():
            win.show()
        return figwin

class FigureManagerGTK(FigureManagerBase):
    def __init__(self, figure, num, window, vbox, toolbar):
        FigureManagerBase.__init__(self, figure, num)

        self.window = window
        self.vbox = vbox
        self.toolbar = toolbar

    def add_subplot(self, *args, **kwargs):
        a = FigureManagerBase.add_subplot(self, *args, **kwargs)
        self.toolbar.update()
        return a
    
    def add_axes(self, rect, axisbg):
        a = FigureManagerBase.add_axes(self, rect, axisbg)
        self.toolbar.update()
        return a
    
    def set_current_axes(self, a):
        if a not in self.axes.values():
            error_msg_gtk('Axes is not in current figure')
        FigureManagerBase.set_current_axes(self, a)

        
class Dialog_MeasureTool(gtk.Dialog):
    def __init__(self):
        gtk.Dialog.__init__(self)
        self.set_title("Axis measurement tool")
        self.vbox.set_spacing(1)
        tooltips = gtk.Tooltips()

        self.posFmt =   'Position: x=%1.4f y=%1.4f'
        self.deltaFmt = 'Delta   : x=%1.4f y=%1.4f'

        self.positionLabel = gtk.Label(self.posFmt % (0,0))
        self.vbox.pack_start(self.positionLabel)
        self.positionLabel.show()
        tooltips.set_tip(self.positionLabel,
                         "Move the mouse to data point over axis")

        self.deltaLabel = gtk.Label(self.deltaFmt % (0,0))
        self.vbox.pack_start(self.deltaLabel)
        self.deltaLabel.show()

        tip = "Left click and hold while dragging mouse to measure " + \
              "delta x and delta y"
        tooltips.set_tip(self.deltaLabel, tip)
                         
        self.show()

    def update_position(self, x, y):
        self.positionLabel.set_text(self.posFmt % (x,y))

    def update_delta(self, dx, dy):
        self.deltaLabel.set_text(self.deltaFmt % (dx,dy))


class NavigationToolbar(gtk.Toolbar):
    
    def __init__(self, figure, win=None):
        """
        figure is the Figure instance that the toolboar controls

        win, if not None, is the gtk.Window the Figure is embedded in
        
        """
        gtk.Toolbar.__init__(self)
        self.win = win
        self.figure = figure
        iconSize = gtk.ICON_SIZE_SMALL_TOOLBAR
        self.set_border_width(5)
        self.set_style(gtk.TOOLBAR_ICONS)


        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_GO_BACK, iconSize)
        self.bLeft = self.append_item(
            'Left',
            'Pan left with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.panx,
            -1)
        self.bLeft.connect("scroll_event", self.panx)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_GO_FORWARD, iconSize)
        self.bRight = self.append_item(
            'Right',
            'Pan right with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.panx,
            1)
        self.bRight.connect("scroll_event", self.panx)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_ZOOM_IN, iconSize)
        self.bZoomInX = self.append_item(
            'Zoom In X',
            'Zoom in X (shrink the x axis limits) with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.zoomx,
            1)
        self.bZoomInX.connect("scroll_event", self.zoomx)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_ZOOM_OUT, iconSize)
        self.bZoomOutX = self.append_item(
            'Zoom Out X',
            'Zoom Out X (expand the x axis limits) with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.zoomx,
            -1)
        self.bZoomOutX.connect("scroll_event", self.zoomx)

        self.append_space()
        
        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_GO_UP, iconSize)
        self.bUp = self.append_item(
            'Up',
            'Pan up with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.pany,
            1)
        self.bUp.connect("scroll_event", self.pany)


        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_GO_DOWN, iconSize)
        self.bDown = self.append_item(
            'Down',
            'Pan down with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.pany,
            -1)
        self.bDown.connect("scroll_event", self.pany)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_ZOOM_IN, iconSize)
        self.bZoomInY = self.append_item(
            'Zoom In Y',
            'Zoom in Y (shrink the y axis limits) with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.zoomy,
            1)
        self.bZoomInY.connect("scroll_event", self.zoomy)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_ZOOM_OUT, iconSize)
        self.bZoomOutY = self.append_item(
            'Zoom Out Y',
            'Zoom Out Y (expand the y axis limits) with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.zoomy,
            -1)
        self.bZoomOutY.connect("scroll_event", self.zoomy)

        self.append_space()

        def draw(button):
            # prepare the axes for a clean redraw
            for a in figure.axes:
                a.wash_brushes()
            figure.draw()
        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_CLEAR, iconSize)
        b = self.append_item(
            'Draw',
            'Redraw the figure',
            'Private',
            iconw,
            draw)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_SAVE, iconSize)
        self.bSave = self.append_item(
            'Save',
            'Save the figure',
            'Private',
            iconw,
            self.save_figure)

        self.append_space()


        def destroy_clicked(button):
            if win is not None: win.destroy()
            else: gtk.mainquit()
        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_QUIT, iconSize)
        self.bQuit = self.append_item(
            'Close',
            'Close the figure',
            'Private',
            iconw,
            destroy_clicked)

        self.append_space()

        self.update()
    def make_axis_menu(self):

        def toggled(item, label):
            if item==itemAll:
                for item in items: item.set_active(1)
            elif item==itemInvert:
                for item in items:
                    item.set_active(not item.get_active())

            ind = [i for i,item in enumerate(items) if item.get_active()]
            self.set_active(ind)


                        
            
        menu = gtk.Menu()

        label = "All"
        itemAll = gtk.MenuItem(label)
        menu.append(itemAll)
        itemAll.connect("activate", toggled, label)
        itemAll.show()

        label = "Invert"
        itemInvert = gtk.MenuItem(label)
        menu.append(itemInvert)
        itemInvert.connect("activate", toggled, label)
        itemInvert.show()

        items = []
        for i in range(len(self._axes)):
            
            label = "Axis %d" % (i+1)
            item = gtk.CheckMenuItem(label)
            menu.append(item)
            item.connect("toggled", toggled, label)
            item.show()
            item.set_active(1)
            items.append(item)

        return menu

    def set_active(self, ind):
        self._ind = ind
        self._active = [ self._axes[i] for i in self._ind ]
        #for a in self._axes:
        #    a.wash_brushes()
        #self.figure.draw()
        
    def panx(self, button, arg):
        try: arg.direction
        except AttributeError: direction = arg
        else:
            if arg.direction == gdk.SCROLL_UP: direction=1
            else: direction=-1

        for a in self._active:
            a.panx(direction)
        self.figure.draw()
        return gtk.TRUE

    def pany(self, button, arg):
        try: arg.direction
        except AttributeError: direction = arg
        else:
            if arg.direction == gdk.SCROLL_UP: direction=1
            else: direction=-1
        for a in self._active:
            a.pany(direction)
        self.figure.draw()

    def zoomx(self, button, arg):
        try: arg.direction
        except AttributeError: direction = arg
        else:            
            if arg.direction == gdk.SCROLL_UP: direction=1
            else: direction=-1

        for a in self._active:
            a.zoomx(direction)
        self.figure.draw()
        return gtk.TRUE

    def zoomy(self, button, arg):
        try: arg.direction
        except AttributeError: direction = arg
        else:
            if arg.direction == gdk.SCROLL_UP: direction=1
            else: direction=-1

        for a in self._active:
            a.zoomy(direction)
        self.figure.draw()
        return gtk.TRUE

    def menu_clicked(self, button):
        if event.button==3:
            self._axisMenu.popup(None, None, None, 0, 0)


    def save_figure(self, button):
                
        def print_ok(button):
            fname = fs.get_filename()
            self.lastDir = os.path.dirname(fname)
            fs.destroy()
            try: self.figure.print_figure(fname)
            except IOError, msg:                
                err = '\n'.join(map(str, msg))
                msg = 'Failed to save %s: Error msg was\n\n%s' % (
                    fname, err)
            
        fs = gtk.FileSelection(title='Save the figure')
        if self.win is not None:
            fs.set_transient_for(self.win)
        try: self.lastDir
        except AttributeError: pass
        else: fs.set_filename(self.lastDir + os.sep)

        fs.ok_button.connect("clicked", print_ok)
        fs.cancel_button.connect("clicked", lambda b: fs.destroy())
        fs.show()


    def update(self):
        self._axes = self.figure.get_axes()
        self.set_active(range(len(self._axes)))
        if len(self._axes)>1:

            try: self.omenu
            except AttributeError:
                self.omenu = gtk.OptionMenu()
                self.omenu.set_border_width(3)
                self.omenu.show()
                self.insert_widget(
                    self.omenu,
                    'Select axes that controls affect',
                    'Private', 0)
                
            # set up the axis menu
            menu = self.make_axis_menu()
            self.omenu.set_menu(menu)
        self.set_active(range(len(self._axes)))

Gcf = GcfGTK
FigureManager = FigureManagerBase
AxisText = AxisTextGTK
Figure = FigureGTK
error_msg = error_msg_gtk
