import sys
import axes


defaultDPI=300
defaultFigSize = (5,4)

def error_msg(msg):
    print >>sys.stderr, msgs

class GcfBase(object):
    __shared_state = {}
    _activeQue = []
    figs = {}

    def __init__(self, num=None, pagesize=defaultFigSize, dpi=defaultDPI):
        self.pagesize=pagesize
        self.dpi = dpi

        self.__dict__ = self.__shared_state

        if num is None and self._get_active() is not None:
            # nothing to do
            return

        if self.figs.has_key(num):
            fig = self.figs[num]
        else:
            fig = self.newfig(num, pagesize, dpi)
        self._set_active(fig)


    def destroy(num):
        if not GcfBase.has_fignum(num): return
        figwin = GcfBase.figs[num]

        oldQue = GcfBase._activeQue[:]
        GcfBase._activeQue = []
        for f in oldQue:
            if f != figwin: GcfBase._activeQue.append(f)

        del GcfBase.figs[num]
        #figwin.window.destroy()
    destroy = staticmethod(destroy)
    
    def has_fignum(num):
        return GcfBase.figs.has_key(num)
    has_fignum = staticmethod(has_fignum)

    def get_current_figwin(self):
        fig = self._get_active()
        if fig is None:
            fig = self.newfig()
            self._set_active(fig)
        return fig
            
    def get_all_figwins():
        return GcfBase.figs.values()
    get_all_figwins = staticmethod(get_all_figwins)

    def get_num_figwins():
        return len(GcfBase.figs.values())
    get_num_figwins = staticmethod(get_num_figwins)
    
    def newfig(self, num=None, figsize=defaultFigSize, dpi=defaultDPI):
        raise NotImplementedError, 'Derveid must override'        
        
    def _get_active(self):
        if len(GcfBase._activeQue)==0:
            return None
        else: return self._activeQue[-1]

    def _set_active(self, fig):
        oldQue = self._activeQue[:]
        GcfBase._activeQue = []
        for f in oldQue:
            if f != fig: GcfBase._activeQue.append(f)
        GcfBase._activeQue.append(fig)

class FigureManagerBase:
    def __init__(self, figure, num):
        self.figure = figure
        self.num = num
        self.axes = {}

    def add_subplot(self, *args, **kwargs):
        """
        Add a subplot to the current figure
        """
        if self.axes.has_key(args):
            self.currentAxis = self.axes[args]
        else:
            a = axes.Subplot(*args, **kwargs)
            self.figure.add_axis(a)
            self.axes[args] = a
            self.currentAxis = a
            return a
        
    def add_axes(self, rect, axisbg):
        """
        Add an axes to the current figure
        """
        rect = tuple(rect)
        if self.axes.has_key(rect):
            self.currentAxis = self.axes[rect]
            return self.currentAxis
        else:
            a = axes.Axes(position=rect, axisbg=axisbg)
            self.figure.add_axis(a)
            self.axes[rect] = a
            self.currentAxis = a
            return a

    def get_current_axis(self):
        """
        Return the current axes
        """
        try:
            return self.currentAxis
        except AttributeError:
            self.add_subplot(111)
            return self.currentAxis

    def set_current_axes(self, a):
        """
        Set the current axes to be a
        """
        if a not in self.axes.values():
            error_msg('Axes is not in current figure')
        self.currentAxis = a
