from __future__ import division
import sys

from cbook import True, False, enumerate
from transforms import RWRef

class DPI(RWRef):
    'DPI as a read/write reference'
    pass
    
    
class Artist:
    """
    Abstract base class for someone who renders into a Figure

    Public attributes
      dpi  : a DPI instance
      bbox : a Bound2D instance in display coords
      transform : a Transform instance
      renderer  : the last renderer used to draw, or None
    """

    aname = 'Artist'
    def __init__(self, dpi, bbox):        
        self.renderer = None
        self._lod = False
        self.dpi = dpi
        self.bbox = bbox
        self._clipOn = True
        self._alpha = 1.0
        self._visible = True
        
    def get_alpha(self):
        """
        Return the alpha value used for blending - not supported on
        all backends
        """
        return self._alpha

    def get_visible(self):
        "return the artist's visiblity"
        return self._visible 

    def get_clip_on(self):
        'Return whether artist uses clipping'
        return self._clipOn

    def set_clip_on(self, b):
        'Set whether artist is clipped to bbox'        
        self._clipOn = b

    def set_visible(self, b):
        "set the artist's visiblity"
        self._visible = b
    
    def set_child_attr(self, attr, val):
        """
        Set attribute attr for self, and all child artists
        """
        setattr(self, attr, val)
        for c in self.get_child_artists():
            c.set_child_attr(attr, val)


    def get_child_artists(self):
        'Return all artists contained in self'
        return []

    def get_window_extent(self, renderer=None):
        'Return the window extent of the Artist as a Bound2D instance'
        raise NotImplementedError('Derived must override')


    def get_dpi(self):
        """
        Get the DPI of the display
        """
        return self.dpi


    def draw(self, renderer=None, *args, **kwargs):
        'Derived classes drawing method'
        if not self._visible: return 
        if renderer is None: renderer = self.renderer
        if renderer is None: return
        self.renderer = renderer
        
        self._draw(renderer, *args, **kwargs)

    def _draw(self, renderer, *args, **kwargs):
        'Derived classes drawing method'
        raise NotImplementedError, 'Derived must override'

    def set_alpha(self, alpha):
        """
        Set the alpha value used for blending - not supported on
        all backends
        """
        self._alpha = alpha

    def set_lod(self, on):
        """
        Set Level of Detail on or off.  If on, the artists may examine
        things like the pixel width of the axes and draw a subset of
        their contents accordingly
        """
        self._lod = on

        


