"""
Render to gtk from agg
"""
from __future__ import division

import os, sys

from matplotlib.cbook import enumerate, True, False
from matplotlib.figure import Figure

from backend_agg import FigureCanvasAgg
from backend_gtk import gtk, FigureManagerGTK, FigureCanvasGTK,\
     show, draw_if_interactive,\
     error_msg, NavigationToolbar, PIXELS_PER_INCH

from _gtkagg import agg_to_gtk_drawable


def new_figure_manager(num, *args):
    """
    Create a new figure manager instance
    """
    thisFig = Figure(*args)
    canvas = FigureCanvasGTKAgg(thisFig)
    return FigureManagerGTK(canvas, num)

class FigureCanvasGTKAgg(FigureCanvasGTK):

    def draw(self):
        """
        Draw to the Agg backend and then copy the image to the
        gtk.gdk.drawable.

        """
        drawable = self.window
        if drawable is None: return

        agg = self.switch_backends(FigureCanvasAgg)
        agg.draw()

        w, h = agg.renderer.width, agg.renderer.height
        agg_to_gtk_drawable(drawable, agg.renderer._renderer)

        
    def print_figure(self, filename, dpi=150,
                     facecolor='w', edgecolor='w',
                     orientation='portrait'):
        
        origDPI = self.figure.dpi.get()
        root, ext = os.path.splitext(filename)

        if ext.find('ps')>=0 or ext.find('ep') >= 0:
            # import here for effciency
            from backend_ps import FigureCanvasPS
            ps = self.switch_backends(FigureCanvasPS)
            ps.print_figure(filename, 72, facecolor, edgecolor, orientation)
        else:
            agg = self.switch_backends(FigureCanvasAgg)
            agg.print_figure(filename, dpi, facecolor, edgecolor, orientation)

        self.figure.dpi.set(origDPI)
        for a in self.figure.axes: a.resize()

    def configure_event(self, widget, event=None):
        if widget.window is None: return 

        w,h = widget.window.get_size()
        if w==1 or h==1: return # empty fig

        self.figure.bbox.set_bounds(0, 0, w, h)
        for a in self.figure.axes: a.resize()
        
        return gtk.TRUE
    
    def expose_event(self, widget, event):
        if widget.window is None: return 

        def callback(w):
            self.draw()
            self._idleID=0
            return gtk.FALSE

        if self._idleID==0:
            self._idleID = gtk.idle_add(callback, self)


        return gtk.TRUE
