"""numerix  imports either Numeric or numarray based on various selectors.

0.  If the value "--numarray" or "--Numeric" is specified on the
command line, then numerix imports the specified array package.

1. The value of numerix in ~/.matplotlibrc: either Numeric or numarray

2.  If the environment variable NUMERIX is defined as either "Numeric"
or as "numarray", then numerix will import from the specified array package.

3.  If the file numerix or .numerix in the HOME directory of the current
user contains a single line specifying either "Numeric" or "numarray",
then the specified array package is imported.

4. If none of the above is done, the default array package is Numeric.

5. If the Numeric is selected and the import fails,  numarray is tried.

To summarize: the commandline is examined first, the rc file seconds,
the environment third, the configuration file next, and the default
array package is Numeric.  If everything else fails, numarray is tried.

"""

import sys, os
from matplotlib import rcParams

def get_which(home, file):
    path=os.path.join(home, file)
    which = open(path).readlines()[0]
    return which, "config file"

which = None, None

# First, see if --numarray or --Numeric was specified on the command
# line:
if hasattr(sys, 'argv'):        #Once again, Apache mod_python has no argv
    for a in sys.argv:
        if a in ["--Numeric", "--numeric", "--NUMERIC",
                 "--Numarray", "--numarray", "--NUMARRAY"]:
            which = a[2:], "command line"
            break

which = rcParams['numerix'], "rc"

# Next try getting the selector from the environment
if which[0] is None:
    which = os.getenv("NUMERIX"), "environment"

# Next try getting the selector from the file "numerix" or ".numerix" in $HOME
if which[0] is None:  
    HOME = os.getenv("HOME")
    FILE = "numerix"
    try:
        which = get_which(HOME, FILE)
    except IOError:
        try:
            FILE = "." + FILE
            which = get_which(HOME, FILE)
        except IOError:
            pass

# If all the above fail, default to Numeric.        
if which[0] is None:
    which = "Numeric", "defaulted"

which = which[0].strip().lower(), which[1]
if which[0] not in ["numeric", "numarray"]:
    print >>sys.stderr, __doc__
    raise ValueError("numerix selector must be either 'Numeric' or 'numarray' but the value obtained from the %s was '%s'." % (which[1], which[0]))

if which[0] == "numarray":
    from numarray import *
    import numarray.linear_algebra as LinearAlgebra
    import numarray.linear_algebra.mlab as MLab
    from numarray.linear_algebra import inverse, eigenvectors
    from numarray.linear_algebra.mlab import *
    from numarray.convolve import convolve
    from numarray.fft import fft
    import numarray.random_array as RandomArray
elif which[0] == "numeric":
    try:
        from Numeric import *
        import MLab
        from MLab import *
        from FFT import fft
        import LinearAlgebra
        from LinearAlgebra import inverse, eigenvectors
        import RandomArray
        from Matrix import Matrix        
    except ImportError:  # exact copy of "numarray" imports above
        if which[1] != "defaulted":
            print >>sys.stderr, "Numeric import failed... trying numarray."
            which = "numarray", "Numeric import error"
        else:
            which = "numarray", "defaulted"
        from numarray import *
        import numarray.linear_algebra as LinearAlgebra
        import numarray.linear_algebra.mlab as MLab
        from numarray.linear_algebra import inverse, eigenvectors
        from numarray.linear_algebra.mlab import *
        from numarray.convolve import convolve
        from numarray.fft import fft
        import numarray.random_array as RandomArray
else:
    raise RuntimeError("invalid numerix selector")
