from __future__ import division

import os, sys, math

try:  # todo: test this with default RHL8 install.
    import pygtk
    pygtk.require('2.0')
except:
    print sys.exc_info()[1]
    print >>sys.stderr, 'matplotlib requires pygtk-1.99.16 or greater -- trying anyway.  Please hold on'


import gobject
import gtk
from gtk import gdk
import pango

import matplotlib
from matplotlib.numerix import asarray, fromstring, UInt8, zeros, \
     where, transpose, nonzero, indices, max, ones, nx

from matplotlib.cbook import is_string_like,  enumerate, True, False
from matplotlib.font_manager import fontManager

from matplotlib.backend_bases import \
     RendererBase, GraphicsContextBase, FigureManagerBase, FigureCanvasBase
from matplotlib._matlab_helpers import Gcf
from matplotlib.figure import Figure

# make if 0 to disable mathtext
if 1:
    try:
        from matplotlib.mathtext import math_parse_s_ft2font
    except ImportError:
        print >>sys.stderr, 'backend_gtk could not import mathtext (build with ft2font)'
        useMathText = False
    else:
        useMathText = True
else:
    useMathText = False

# the true dots per inch on the screen; should be display dependent
# see http://groups.google.com/groups?q=screen+dpi+x11&hl=en&lr=&ie=UTF-8&oe=UTF-8&safe=off&selm=7077.26e81ad5%40swift.cs.tcd.ie&rnum=5 for some info about screen dpi
PIXELS_PER_INCH = 96


def round(x):
    return int(math.floor(x+0.5))


class ColorManagerGTK:
    _cached = {}  # a map from get_color args to colors
    _cmap = None
    
    def set_drawing_area(self, da):
        self._cmap = da.get_colormap()

    def get_color(self, rgb):
        """
        RGB is a unit RGB tuple, return a gtk.gdk.Color
        """

        try: return self._cached[tuple(rgb)]
        except KeyError: pass
        
        if self._cmap is None:
            raise RuntimeError('First set the drawing area!')

        #print 'rgb is', rgb
        r,g,b = rgb
        color = self._cmap.alloc_color(int(r*65025),int(g*65025),int(b*65025))
        self._cached[tuple(rgb)] = color
        return color

    def get_rgb(self, color):
        """
        RGB is a unit RGB tuple, return a gtk.gdk.Color
        """

        return [val/65535 for val in (color.red, color.green, color.blue)]

colorManager = ColorManagerGTK()

class RendererGTK(RendererBase):

    fontweights = {
        100          : pango.WEIGHT_ULTRALIGHT,
        200          : pango.WEIGHT_LIGHT,
        300          : pango.WEIGHT_LIGHT,
        400          : pango.WEIGHT_NORMAL,
        500          : pango.WEIGHT_NORMAL,
        600          : pango.WEIGHT_BOLD,
        700          : pango.WEIGHT_BOLD,
        800          : pango.WEIGHT_HEAVY,
        900          : pango.WEIGHT_ULTRABOLD,
        'ultralight' : pango.WEIGHT_ULTRALIGHT,
        'light'      : pango.WEIGHT_LIGHT,
        'normal'     : pango.WEIGHT_NORMAL,
        'medium'     : pango.WEIGHT_NORMAL,
        'semibold'   : pango.WEIGHT_BOLD,
        'bold'       : pango.WEIGHT_BOLD,
        'heavy'      : pango.WEIGHT_HEAVY,
        'ultrabold'  : pango.WEIGHT_ULTRABOLD,
        'black'      : pango.WEIGHT_ULTRABOLD,
                   }
    fontangles = {
        'italic'  : pango.STYLE_ITALIC,
        'normal'  : pango.STYLE_NORMAL,
        'oblique' : pango.STYLE_OBLIQUE,
        }

    # cache for efficiency, these must be at class, not instance level
    layoutd = {}  # a map from text prop tups to pango layouts
    extentd = {}  # a map from text prop tups to text extents
    offsetd = {}  # a map from text prop tups to text offsets
    rotated = {}  # a map from text prop tups to rotated text pixbufs

    def __init__(self, gtkDA, gdkDrawable, dpi):
        self.gtkDA = gtkDA
        self.gdkDrawable = gdkDrawable
        self.width, self.height = self.gdkDrawable.get_size()
        self.dpi = dpi

    def flipy(self):
        return True

    def offset_text_height(self):
        return True

    def get_text_width_height(self, s, prop, ismath):
        """
        get the width and height in display coords of the string s
        with FontPropertry prop
        """
        if ismath:
            width, height, fonts = math_parse_s_ft2font(
                s, self.dpi.get(), prop.get_size_in_points())
            return width, height

        layout = self.get_pango_layout(s, prop)
        inkRect, logicalRect = layout.get_pixel_extents()
        rect = inkRect
        #rect = logicalRect
        l, b, w, h = rect
        return w, h+1

    def get_canvas_width_height(self):
        'return the canvas width and height in display coords'
        return self.width, self.height

    

    
    def draw_arc(self, gc, rgbFace, x, y, width, height, angle1, angle2):
        """
        Draw an arc centered at x,y with width and height
        """
        x, y = int(x-0.5*width), self.height-int(y+0.5*height)
        w, h = int(width)+1, int(height)+1
        a1, a2 = int(angle1*64), int(angle2*64)
        
        if rgbFace is not None:
            edgecolor = gc.gdkGC.foreground
            facecolor = colorManager.get_color(rgbFace)
            gc.gdkGC.foreground = facecolor
            self.gdkDrawable.draw_arc(gc.gdkGC, True, x, y, w, h, a1, a2)
            gc.gdkGC.foreground = edgecolor
        self.gdkDrawable.draw_arc(gc.gdkGC, False, x, y, w, h, a1, a2)

    def draw_image(self, x, y, im):
        """
        Draw the Image instance into the current axes; x, y is the
        upper left hand corner of the image
        """
        #print 'draw_image'

        rows, cols, s = im.as_str()
        X = fromstring(s, UInt8)
        X.shape = cols, rows, 4
        pb=gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB,
                          has_alpha=1, bits_per_sample=8,
                          width=rows, height=cols)
        try: pa = pb.get_pixels_array()
        except AttributeError: pa = pb.pixel_array

        pa[:,:,:] = X

        gc = self.new_gc()
        pb.render_to_drawable(self.gdkDrawable, gc.gdkGC, 0, 0,
                              int(x), int(self.height-y), rows, cols,
                              gdk.RGB_DITHER_NONE, 0, 0)

            
    def draw_line(self, gc, x1, y1, x2, y2):
        """
        Draw a single line from x1,y1 to x2,y2
        """
        self.gdkDrawable.draw_line(
            gc.gdkGC, int(x1), self.height-int(y1),
            int(x2), self.height-int(y2))


    def draw_lines(self, gc, x, y):
        x = x.astype(nx.Int16)
        y = self.height*ones(y.shape, nx.Int16) - y.astype(nx.Int16)  

        self.gdkDrawable.draw_lines(gc.gdkGC, zip(x,y))

    def draw_point(self, gc, x, y):
        """
        Draw a single point at x,y
        """
        self.gdkDrawable.draw_point(
            gc.gdkGC, int(x), self.height-int(y))

    def draw_polygon(self, gc, rgbFace, points):
        """
        Draw a polygon.  points is a len vertices tuple, each element
        giving the x,y coords a vertex

        If gcFace is not None, fill the rectangle with it.  gcEdge
        is a GraphicsContext instance

        """
        points = [(int(x), self.height-int(y)) for x,y in points]
        if rgbFace is not None:
            edgecolor = gc.gdkGC.foreground
            facecolor = colorManager.get_color(rgbFace)
            gc.gdkGC.foreground = facecolor
            self.gdkDrawable.draw_polygon(gc.gdkGC, True, points)
            gc.gdkGC.foreground = edgecolor

        self.gdkDrawable.draw_polygon(gc.gdkGC, False, points)


    def draw_rectangle(self, gc, rgbFace, x, y, width, height):
        """
        Draw a rectangle at lower left x,y with width and height
        If filled=True, fill the rectangle with the gc foreground
        gc is a GraphicsContext instance
        """
        x, y = int(x), self.height-int(y+height)
        #x, y = int(x), self.height-int(math.ceil(y+height))
        w, h = int(math.ceil(width)), int(math.ceil(height))


        if rgbFace is not None:
            edgecolor = gc.gdkGC.foreground
            facecolor = colorManager.get_color(rgbFace)
            gc.gdkGC.foreground = facecolor
            self.gdkDrawable.draw_rectangle(gc.gdkGC, True, x, y, w, h)
            gc.gdkGC.foreground = edgecolor
            
        self.gdkDrawable.draw_rectangle(gc.gdkGC, False, x, y, w, h)


    def _draw_rotated_text(self, gc, x, y, s, prop, angle, ismath):
        """
        Draw the text rotated 90 degrees
        """

        gdrawable = self.gdkDrawable
        ggc = gc.gdkGC

        layout = self.get_pango_layout(s, prop)
        inkRect, logicalRect = layout.get_pixel_extents()
        rect = inkRect
        l, b, w, h = rect

        x = int(x-h)
        y = int(y-w)
        # get the background image

        # todo: cache rotation for dynamic redraw until pygtk mem leak
        # fixed
        key = (x,y,s,angle,hash(prop))
        imageOut = self.rotated.get(key)
        if imageOut is not None:
            gdrawable.draw_image(ggc, imageOut, 0, 0, x, y, h, w)
            return

        # save the background
        imageBack = gdrawable.get_image(x, y, w, h)
        imageVert = gdrawable.get_image(x, y, h, w)

        # transform the vertical image, write it onto the renderer,
        # and draw the layout onto it
        imageFlip = gtk.gdk.Image(type=gdk.IMAGE_NORMAL,
                                  visual=gdrawable.get_visual(),
                                  width=w, height=h)
        if imageFlip is None or imageBack is None or imageVert is None:
            print >> sys.stderr, "Could not renderer vertical text", s
            return
        imageFlip.set_colormap(gdrawable.get_colormap())
        for i in range(w):
            for j in range(h):
                imageFlip.put_pixel(i, j, imageVert.get_pixel(j,w-i-1) )

        gdrawable.draw_image(ggc, imageFlip, 0, 0, x, y, w, h)
        gdrawable.draw_layout(ggc, x, y-b, layout)

        # now get that image and flip it vertical
        imageIn = gdrawable.get_image(x, y, w, h)
        imageOut = gtk.gdk.Image(type=gdk.IMAGE_NORMAL,
                                 visual=gdrawable.get_visual(),
                                 width=h, height=w)
        imageOut.set_colormap(gdrawable.get_colormap())
        for i in range(w):
            for j in range(h):
                imageOut.put_pixel(j, i, imageIn.get_pixel(w-i-1,j) )

        # draw the old background and the flipped text
        gdrawable.draw_image(ggc, imageBack, 0, 0, x, y, w, h)
        gdrawable.draw_image(ggc, imageOut, 0, 0, x, y, h, w)
        self.rotated[key] = imageOut
        return True


    def draw_mathtext(self, gc, x, y, s, prop, angle):

        size = prop.get_size_in_points()
        width, height, fonts = math_parse_s_ft2font(
            s, self.dpi.get(), size)

        x = int(x)
        y = int(y)
        
        rgb = gc.get_rgb()
        rgba = (rgb[0], rgb[1], rgb[2], gc.get_alpha())        

        imw, imh, s = fonts[0].image_as_str()
        N = imw*imh

        # a numpixels by num fonts array
        Xall = zeros((N,len(fonts)), typecode=UInt8)

        for i, font in enumerate(fonts):
            imw, imh, s = font.image_as_str()
            Xall[:,i] = fromstring(s, UInt8)  

        # get the max alpha at each pixel
        Xs = max(Xall,1)

        # convert it to it's proper shape
        Xs.shape = imh, imw
                

        imw = min([imw, self.width-x])
        imh = min([imh, y])

        pb=gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB,
                          has_alpha=1, bits_per_sample=8, width=imw, height=imh)

        try: pbpix = pb.get_pixels_array()
        except AttributeError: pbpix = pb.pixel_array


        pbpix[:,:,0]=int(rgb[0]*255)
        pbpix[:,:,1]=int(rgb[1]*255)
        pbpix[:,:,2]=int(rgb[2]*255)
        pbpix[:,:,3]=Xs
        
        pb.render_to_drawable(self.gdkDrawable, gc.gdkGC, 0, 0,
                              x, int(y-height), imw, imh,
                              gdk.RGB_DITHER_NONE, 0, 0)

        
    def draw_text(self, gc, x, y, s, prop, angle, ismath):

        
        if ismath:
            return self.draw_mathtext(gc, x, y, s, prop, angle)

        w, h = self.get_text_width_height(s, prop, ismath)
        x = int(x)
        y = int(y)

        if angle==90:
            self._draw_rotated_text(gc, x, y, s, prop, angle, ismath)
            return
        layout = self.get_pango_layout(s, prop)
        inkRect, logicalRect = layout.get_pixel_extents()
        rect = inkRect
        l, b, w, h = rect

        self.gdkDrawable.draw_layout(
            gc.gdkGC, x=x, y=y-h-b,
            layout=layout)


        
    def get_pango_layout(self, s, prop):
        """
        Return a pango layout instance for Text instance t.  cache to
        layoutd
        """

        key = self.dpi.get(), s, hash(prop)
        layout = self.layoutd.get(key)
        if layout is not None: return layout

        fontname = prop.get_name()
        #if fontname.lower()=='times': fontname = "serif"
        
        font = pango.FontDescription('%s' % fontname)
        
        font.set_weight(self.fontweights[prop.get_weight()])
        font.set_style(self.fontangles[prop.get_style()])

        scale = self.get_text_scale()
        size  = prop.get_size_in_points()
        font.set_size(int(scale*size*1024))
        context = self.gtkDA.create_pango_context()
        layout  = self.gtkDA.create_pango_layout(s)
        layout.set_font_description(font)    

        self.layoutd[key] = layout
        return layout



    def get_text_scale(self):
        """
        Return the scale factor for fontsize taking screendpi and pixels per
        inch into account
        """
        return self.dpi.get()/PIXELS_PER_INCH
        #return self.dpi.get()/72.0

    def new_gc(self):
        return GraphicsContextGTK(self.gdkDrawable.new_gc(), self)

    def points_to_pixels(self, points):
        """
        convert point measures to pixes using dpi and the pixels per
        inch of the display
        """
        return points*(PIXELS_PER_INCH/72.0*self.dpi.get()/72.0)
        #return points*(self.dpi.get()/72.0)


class GraphicsContextGTK(GraphicsContextBase):

    _joind = {
        'bevel' : gdk.JOIN_BEVEL,
        'miter' : gdk.JOIN_MITER,
        'round' : gdk.JOIN_ROUND,
        }

    _capd = {
        'butt' : gdk.CAP_BUTT,
        'projecting' : gdk.CAP_PROJECTING,
        'round' : gdk.CAP_ROUND,
        }

              
    def __init__(self, gdkGC, renderer):
            GraphicsContextBase.__init__(self)
            self.gdkGC = gdkGC
            self.renderer = renderer


    def set_clip_rectangle(self, rectangle):
        GraphicsContextBase.set_clip_rectangle(self, rectangle)
        l,b,w,h = rectangle
        rectangle = (int(l), self.renderer.height-int(b+h)+1,
                     int(w), int(h))
        #rectangle = (int(l), self.renderer.height-int(b+h),
        #             int(w+1), int(h+2))
        self.gdkGC.set_clip_rectangle(rectangle)        


    def set_dashes(self, dash_offset, dash_list):
        GraphicsContextBase.set_dashes(self, dash_offset, dash_list)

        def one_or_round(val):
            if val<1: return 1
            else: return round(val)

        if dash_list is not None:
            pixels = self.renderer.points_to_pixels(asarray(dash_list))
            self.gdkGC.line_style = gdk.LINE_ON_OFF_DASH
            
            dl = [one_or_round(val) for val in pixels]
            self.gdkGC.set_dashes(dash_offset, dl)
        else:
            self.gdkGC.line_style = gdk.LINE_SOLID

    def set_foreground(self, fg):
        """
        Set the foreground color.  fg can be a matlab format string, a
        html hex color string, an rgb unit tuple, or a float between 0
        and 1.  In the latter case, grayscale is used.
        """
        GraphicsContextBase.set_foreground(self, fg)
        self.gdkGC.foreground = self._get_gdk_color()

    def set_graylevel(self, frac):
        """
        Set the foreground color to be a gray level with frac frac
        """
        GraphicsContextBase.set_graylevel(self, frac)
        self.gdkGC.foreground = self._get_gdk_color()
        

    def set_linewidth(self, lw):
        GraphicsContextBase.set_linewidth(self, lw)

        pixels = self.renderer.points_to_pixels(lw)
        if pixels<1: pixels = 1
        else: pixels = round(pixels)

        self.gdkGC.line_width = pixels

    def set_linestyle(self, style):
        GraphicsContextBase.set_linestyle(self, style)
                                               
    def set_capstyle(self, cs):
        """
        Set the capstyle as a string in ('butt', 'round', 'projecting')
        """
        GraphicsContextBase.set_capstyle(self, cs)
        self.gdkGC.cap_style = self._capd[self._capstyle]

    def set_joinstyle(self, js):
        """
        Set the join style to be one of ('miter', 'round', 'bevel')
        """
        GraphicsContextBase.set_joinstyle(self, js)
        self.gdkGC.join_style = self._joind[self._joinstyle]

    def _get_gdk_color(self):
        return colorManager.get_color(self.get_rgb())


    def _update_gc_line_attributes(self):
        lw = self._linewidth
        js = self._joind[self._joinstyle]
        cs = self._capd[self._capstyle]


        

def raise_msg_to_str(msg):
    """msg is a return arg from a raise.  Join with new lines"""
    if not is_string_like(msg):
        msg = '\n'.join(map(str, msg))
    return msg
    
def error_msg_gtk(msg, parent=None):
    dialog = gtk.MessageDialog(
        parent         = None,
        type           = gtk.MESSAGE_ERROR,
        buttons        = gtk.BUTTONS_OK,
        message_format = msg)
    if parent is not None:
        dialog.set_transient_for(parent)
    dialog.show()
    dialog.run()
    dialog.destroy()
    return None



def draw_if_interactive():
    if matplotlib.is_interactive():
        figManager =  Gcf.get_active()
        if figManager is not None:
            figManager.canvas.draw()
            #fig.queue_draw()


def show(mainloop=True):
    """
    Show all the figures and enter the gtk mainloop

    This should be the last line of your script
    """

    for manager in Gcf.get_all_fig_managers():
        manager.window.show()
        
    if mainloop: gtk.mainloop()


def _quit_after_print_xvfb(*args):

    for manager in Gcf.get_all_fig_managers():
        if len(manager.canvas._printQued): break
    else: gtk.mainquit()

def show_xvfb():
    """
    Print the pending figures only then quit, no screen draw
    """
    for manager in Gcf.get_all_fig_managers():
        manager.canvas.set_do_plot(False)
        manager.window.show()
        
    gtk.idle_add(_quit_after_print_xvfb)
    gtk.mainloop()                


def new_figure_manager(num, *args):
    """
    Create a new figure manager instance
    """
    figure = Figure(*args)

    canvas = FigureCanvasGTK(figure)
    return FigureManagerGTK(canvas, num)

class FigureCanvasGTK(gtk.DrawingArea, FigureCanvasBase):
    def __init__(self, figure):
        FigureCanvasBase.__init__(self, figure)
        gtk.DrawingArea.__init__(self)

        self._inExpose = False
        self._isConfigured = False
        self._isRealized = False
        self._gpixmap = None
        self._doplot = True
        self._printQued = []
        self._idleID = 0 

        w = figure.bbox.width()
        h = figure.bbox.height()
        self.set_size_request(int(w), int(h))
        self.set_double_buffered(gtk.FALSE)
        self.connect('key_press_event', self.key_press_event)
        self.connect('key_release_event', self.key_release_event)
        self.connect('expose_event', self.expose_event)
        self.connect('configure_event', self.configure_event)
        self.connect('realize', self.realize)
        self.connect('motion_notify_event', self.motion_notify_event)
        self.connect('button_press_event', self.button_press_event)
        self.connect('button_release_event', self.button_release_event)

        self.set_events(
            #gdk.FOCUS_CHANGE_MASK|
            gdk.KEY_PRESS_MASK|
            gdk.KEY_RELEASE_MASK|
            gdk.EXPOSURE_MASK |
            gdk.LEAVE_NOTIFY_MASK |
            gdk.BUTTON_PRESS_MASK |
            gdk.BUTTON_RELEASE_MASK |
            gdk.POINTER_MOTION_MASK )

    
    def button_press_event(self, widget, event):  pass
    def button_release_event(self, widget, event): pass
    def motion_notify_event(self, widget, event): pass
    def key_press_event(self, widget, event): pass
    def key_release_event(self, widget, event): pass
                
    def configure_event(self, widget, event=None):

        if widget.window is None: return 

        w,h = widget.window.get_size()
        if w==1 or h==1: return # empty fig

        # compute desired figure size in inches
        dpival = self.figure.dpi.get()
        winch = w/dpival
        hinch = h/dpival
        self.figure.set_figsize_inches(winch, hinch)
        
        if self._isConfigured and self._isRealized:
            self.draw()

        self._isConfigured = True
        return gtk.TRUE
        

    def draw(self):
        if not self._doplot: return
        drawable = self.window        
        if drawable is None: return
        
        width = int(self.figure.bbox.width())
        height = int(self.figure.bbox.height())

        gpixmap = gtk.gdk.Pixmap( drawable, width, height)
        pixmap = RendererGTK(self, gpixmap, self.figure.dpi)

        self.figure.draw(pixmap)

        ggc = drawable.new_gc()
        drawable.draw_drawable(
            ggc, gpixmap, 0, 0, 0, 0, width, height)
        self._gpixmap = gpixmap
        self._ggc = ggc

    def expose_event(self, widget, event):

        if widget.window is None: return 

        if self._gpixmap is not None:
            r = event.area
            # redraw from pixmap
            widget.window.draw_drawable(
                self._ggc, self._gpixmap,
                r.x, r.y, r.x, r.y, r.width, r.height)
        else: self.draw()

        return gtk.TRUE


    def print_figure(self, filename, dpi=150,
                     facecolor='w', edgecolor='w',
                     orientation='portrait'):

        if is_string_like(filename): isFileName = True
        else: isFileName = False

        if isFileName:
            root, ext = os.path.splitext(filename)        
            ext = ext.lower()[1:]
            if not len(ext):
                filename = filename + '.png'
                ext = 'png'

            if ext=='png': type = 'png'
            elif ext in ('jpg', 'jpeg'): type = 'jpeg'
            elif ext.find('ps')>=0: pass
            else:
                error_msg_gtk('Can only save to formats PNG, JPEG, PS or EPS')            
                return
        else: type='png'
        
        if not self._isRealized:
            self._printQued.append((filename, dpi, facecolor, edgecolor))
            return


        if isFileName and ext.find('ps')>=0:
            
            # enable ps save from gtk backend do the import here so we
            # don't have to import afm unless necessary
            from backend_ps import FigureCanvasPS

            origDPI = self.figure.dpi.get()
            ps = self.switch_backends(FigureCanvasPS)
            ps.figure.dpi.set(72)
            ps.print_figure(filename, 72, facecolor, edgecolor)
            self.figure.dpi.set(origDPI)
            return

        origDPI = self.figure.dpi.get()
        origfacecolor = self.figure.get_facecolor()
        origedgecolor = self.figure.get_edgecolor()

        self.figure.dpi.set(dpi)        
        self.figure.set_facecolor(facecolor)
        self.figure.set_edgecolor(edgecolor)

        l,b,width, height = self.figure.bbox.get_bounds()

        width = int(width)
        height = int(height)
        gdrawable = self.window
        ggc = gdrawable.new_gc()

        gpixmap = gtk.gdk.Pixmap(gdrawable, width, height)
        pixmap = RendererGTK(
            self, gpixmap, self.figure.dpi)

        self.figure.draw(pixmap)
        
        pixbuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, 0, 8, width, height)
        pixbuf.get_from_drawable(gpixmap, gdrawable.get_colormap(),
                                 0, 0, 0, 0, width, height)
        
        self.figure.set_facecolor(origfacecolor)
        self.figure.set_edgecolor(origedgecolor)
        self.figure.dpi.set(origDPI)

        self.configure_event(self, 'configure')
            
        try: pixbuf.save(filename, type)
        except gobject.GError, msg:
            msg = raise_msg_to_str(msg)
            # note the error must be displayed here because trapping
            # the error on a call or print_figure may not work because
            # printing can be qued and called from realize
            if isFileName:
                error_msg_gtk('Could not save figure to %s\n\n%s' % (
                    filename, msg))
            else:
                error_msg_gtk('Could not save figure\n%s' % msg)
                
    def realize(self, widget):
        if widget is None: return 
        colorManager.set_drawing_area(widget)

        self._isRealized = True
        for fname, dpi, facecolor, edgecolor in self._printQued:
            self.print_figure(fname, dpi, facecolor, edgecolor)
        self._printQued = []
        return gtk.TRUE


    def is_realized(self):
        return self._isRealized


    def set_do_plot(self, b):
        'True if you want to render to screen, False is hardcopy only'
        self._doplot = b


class FigureManagerGTK(FigureManagerBase):
    """
    Public attributes

    canvas      : The FigureCanvas instance
    num         : The Figure number
    toolbar     : The gtk.Toolbar
    window      : The gtk.Window
    
    """
    def __init__(self, canvas, num):
        FigureManagerBase.__init__(self, canvas, num)
        

        self.window = gtk.Window()
        self.window.set_title("Figure %d" % num)
        self.window.set_border_width(5)

        vbox = gtk.VBox(spacing=3)
        self.window.add(vbox)
        vbox.show()

        self.canvas.show()
        vbox.pack_start(self.canvas, gtk.TRUE, gtk.TRUE)

        # must be inited after the window, drawingArea and figure
        # attrs are set
        self.toolbar = NavigationToolbar( canvas, self.window )
        self.toolbar.show()
        vbox.pack_end(self.toolbar, gtk.FALSE, gtk.FALSE )

        def destroy(*args): Gcf.destroy(num)
        self.window.connect("destroy", destroy)

        if matplotlib.is_interactive():
            self.window.show()


    def add_subplot(self, *args, **kwargs):
        a = FigureManagerBase.add_subplot(self, *args, **kwargs)
        self.toolbar.update()
        return a
    
    def add_axes(self, rect, **kwargs):
        a = FigureManagerBase.add_axes(self, rect, **kwargs)
        self.toolbar.update()
        return a
    
    def destroy(self, *args):
        self.window.destroy()
        if Gcf.get_num_fig_managers()==0 and not matplotlib.is_interactive():
            gtk.mainquit()


        

        
class Dialog_MeasureTool(gtk.Dialog):
    def __init__(self):
        gtk.Dialog.__init__(self)
        self.set_title("Axis measurement tool")
        self.vbox.set_spacing(1)
        tooltips = gtk.Tooltips()

        self.posFmt =   'Position: x=%1.4f y=%1.4f'
        self.deltaFmt = 'Delta   : x=%1.4f y=%1.4f'

        self.positionLabel = gtk.Label(self.posFmt % (0,0))
        self.vbox.pack_start(self.positionLabel)
        self.positionLabel.show()
        tooltips.set_tip(self.positionLabel,
                         "Move the mouse to data point over axis")

        self.deltaLabel = gtk.Label(self.deltaFmt % (0,0))
        self.vbox.pack_start(self.deltaLabel)
        self.deltaLabel.show()

        tip = "Left click and hold while dragging mouse to measure " + \
              "delta x and delta y"
        tooltips.set_tip(self.deltaLabel, tip)
                         
        self.show()

    def update_position(self, x, y):
        self.positionLabel.set_text(self.posFmt % (x,y))

    def update_delta(self, dx, dy):
        self.deltaLabel.set_text(self.deltaFmt % (dx,dy))


class NavigationToolbar(gtk.Toolbar):
    """
    Public attriubutes

      canvas   - the FigureCanvas  (gtk.DrawingArea)
      win   - the gtk.Window

    """
    def __init__(self, canvas, window=None):
        """
        figManager is the FigureManagerGTK instance that contains the
        toolbar, with attributes figure, window and drawingArea
        
        """
        gtk.Toolbar.__init__(self)


        self.canvas = canvas
        self.win = window
        
        iconSize = gtk.ICON_SIZE_SMALL_TOOLBAR
        self.set_border_width(5)
        self.set_style(gtk.TOOLBAR_ICONS)


        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_GO_BACK, iconSize)
        self.bLeft = self.append_item(
            'Left',
            'Pan left with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.panx,
            -1)
        self.bLeft.connect("scroll_event", self.panx)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_GO_FORWARD, iconSize)
        self.bRight = self.append_item(
            'Right',
            'Pan right with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.panx,
            1)
        self.bRight.connect("scroll_event", self.panx)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_ZOOM_IN, iconSize)
        self.bZoomInX = self.append_item(
            'Zoom In X',
            'Zoom in X (shrink the x axis limits) with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.zoomx,
            1)
        self.bZoomInX.connect("scroll_event", self.zoomx)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_ZOOM_OUT, iconSize)
        self.bZoomOutX = self.append_item(
            'Zoom Out X',
            'Zoom Out X (expand the x axis limits) with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.zoomx,
            -1)
        self.bZoomOutX.connect("scroll_event", self.zoomx)

        self.append_space()
        
        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_GO_UP, iconSize)
        self.bUp = self.append_item(
            'Up',
            'Pan up with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.pany,
            1)
        self.bUp.connect("scroll_event", self.pany)


        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_GO_DOWN, iconSize)
        self.bDown = self.append_item(
            'Down',
            'Pan down with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.pany,
            -1)
        self.bDown.connect("scroll_event", self.pany)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_ZOOM_IN, iconSize)
        self.bZoomInY = self.append_item(
            'Zoom In Y',
            'Zoom in Y (shrink the y axis limits) with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.zoomy,
            1)
        self.bZoomInY.connect("scroll_event", self.zoomy)

        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_ZOOM_OUT, iconSize)
        self.bZoomOutY = self.append_item(
            'Zoom Out Y',
            'Zoom Out Y (expand the y axis limits) with click or wheel mouse (bidirectional)',
            'Private',
            iconw,
            self.zoomy,
            -1)
        self.bZoomOutY.connect("scroll_event", self.zoomy)

        self.append_space()


        iconw = gtk.Image()
        iconw.set_from_stock(gtk.STOCK_SAVE, iconSize)
        self.bSave = self.append_item(
            'Save',
            'Save the figure',
            'Private',
            iconw,
            self.save_figure)

        self.append_space()

        self.omenu = gtk.OptionMenu()
        self.omenu.set_border_width(3)
        self.insert_widget(
            self.omenu,
            'Select axes that controls affect',
            'Private', 0)
        
        self.update()

    def make_axis_menu(self):

        menu = gtk.Menu()

        label = "All"
        self.itemAll = gtk.MenuItem(label)
        menu.append(self.itemAll)

        label = "Invert"
        self.itemInvert = gtk.MenuItem(label)
        menu.append(self.itemInvert)

        def toggled(item, label):
            if item==self.itemAll:
                for item in items: item.set_active(1)
            elif item==self.itemInvert:
                for item in items:
                    item.set_active(not item.get_active())

            ind = [i for i,item in enumerate(items) if item.get_active()]
            self.set_active(ind)


                        
            
        self.itemAll.connect("activate", toggled, label)
        self.itemAll.show()

        self.itemInvert.connect("activate", toggled, label)
        self.itemInvert.show()

        items = []
        for i in range(len(self._axes)):
            
            label = "Axis %d" % (i+1)
            item = gtk.CheckMenuItem(label)
            menu.append(item)
            item.connect("toggled", toggled, label)
            item.show()
            item.set_active(1)
            items.append(item)

        self.omenuItems = items
        return menu

    def set_active(self, ind):
        self._ind = ind
        self._active = [ self._axes[i] for i in self._ind ]
        
    def panx(self, button, arg):

        try: arg.direction
        except AttributeError: direction = arg
        else:
            if arg.direction == gdk.SCROLL_UP: direction=1
            else: direction=-1

        for a in self._active:
            a.panx(direction)
        self.canvas.draw()

        return gtk.TRUE
    
    def pany(self, button, arg):
        try: arg.direction
        except AttributeError: direction = arg
        else:
            if arg.direction == gdk.SCROLL_UP: direction=1
            else: direction=-1
        for a in self._active:
            a.pany(direction)
        self.canvas.draw()
        return gtk.TRUE
    
    def zoomx(self, button, arg):
        try: arg.direction
        except AttributeError: direction = arg
        else:            
            if arg.direction == gdk.SCROLL_UP: direction=1
            else: direction=-1

        for a in self._active:
            a.zoomx(direction)
        self.canvas.draw()
        return gtk.TRUE

    def zoomy(self, button, arg):
        try: arg.direction
        except AttributeError: direction = arg
        else:
            if arg.direction == gdk.SCROLL_UP: direction=1
            else: direction=-1

        for a in self._active:
            a.zoomy(direction)
        self.canvas.draw()
        return gtk.TRUE

    def menu_clicked(self, button):
        if event.button==3:
            self._axisMenu.popup(None, None, None, 0, 0)


    def save_figure(self, button):
                
        def print_ok(button):
            fname = fs.get_filename()
            self.lastDir = os.path.dirname(fname)
            fs.destroy()
            try: self.canvas.print_figure(fname)
            except IOError, msg:                
                err = '\n'.join(map(str, msg))
                msg = 'Failed to save %s: Error msg was\n\n%s' % (
                    fname, err)
                error_msg_gtk(msg)
            
        fs = gtk.FileSelection(title='Save the figure')
        win = self.win
        if win is not None:
            fs.set_transient_for(win)
        try: self.lastDir
        except AttributeError: pass
        else: fs.set_filename(self.lastDir + os.sep)

        fs.ok_button.connect("clicked", print_ok)
        fs.cancel_button.connect("clicked", lambda b: fs.destroy())
        fs.show()


    def update(self):
        self._axes = self.canvas.figure.axes
        self.set_active(range(len(self._axes)))
        if len(self._axes)>1:                
            # set up the axis menu
            self.omenu.show()
            menu = self.make_axis_menu()
            self.omenu.set_menu(menu)
        self.set_active(range(len(self._axes)))

FigureManager = FigureManagerGTK
error_msg = error_msg_gtk
