"""
This is a proof-of-concept backend to illustrate mixing a GUI frontend
with a different image rendering backend. I use all the event handling
and widget construction from backend_gtk, and use backend_gd for the
image rendering.

In real production code the image copy step gd->gtk will have to be
done in C since it's god awful slow, but this is just a test of the
new backend setup.

Note that backend_gtkgd does not define or import the Renderer or
GraphicsContext.  It doesn't need one since all the drawing is done by
the gd backend.  
"""
from __future__ import division

import os, sys

from matplotlib.cbook import enumerate, True, False
from matplotlib.figure import Figure

from backend_gd import FigureCanvasGD
from backend_gtk import gtk, FigureManagerGTK, FigureCanvasGTK,\
     show, draw_if_interactive,\
     error_msg, NavigationToolbar, colorManager, PIXELS_PER_INCH

try: from _gtkgd import gd_to_gtk_drawable
except ImportError:
    print 'Using pure python -- s l o w'
    def gd_to_gtk_drawable(drawable, gdImage):
        """
        Draw to a gtk.gdk.Drawable from a gd.Image.   drawable must be
        the same size as image
        """
        w, h = gdImage.size()
        gc = drawable.new_gc()
        for i in range(w):
            for j in range(h):
                ind = gdImage.getPixel((i,j))
                r, g, b = gdImage.colorComponents(ind)
                color = colorManager.get_color( (r/255, g/255, b/255) )
                gc.set_foreground(color)
                drawable.draw_point(gc, i, j)


def new_figure_manager(num, *args):
    """
    Create a new figure manager instance
    """
    thisFig = Figure(*args)
    canvas = FigureCanvasGTKGD(thisFig)
    return FigureManagerGTK(canvas, num)

class FigureCanvasGTKGD(FigureCanvasGTK):

    def draw(self):
        """
        Draw to the GD backend and then copy the image to the
        gtk.gdk.drawable.  This is a proof of concept demo to show how
        to plug image backends into GUI frontends.

        To make this usable the image copy will have to be done in C
        """
        drawable = self.window
        if drawable is None: return

        gd = self.switch_backends(FigureCanvasGD)
        gdImage = gd.draw()

        w, h = gdImage.size()


        pixmap = gtk.gdk.Pixmap(drawable, w, h)
        gc = pixmap.new_gc()
        gd_to_gtk_drawable(pixmap, gdImage)
        drawable.draw_drawable(
            gc, pixmap, 0, 0, 0, 0, w, h)
        self._gpixmap = pixmap
        self._ggc = gc
        return gdImage
        
    def print_figure(self, filename, dpi=150,
                     facecolor='w', edgecolor='w',
                     orientation='portrait'):
        
        origDPI = self.figure.dpi.get()
        root, ext = os.path.splitext(filename)

        if ext.find('ps')>=0:
            # import here for effciency
            from backend_ps import FigureCanvasPS
            ps = self.switch_backends(FigureCanvasPS)
            ps.print_figure(filename, 72, facecolor, edgecolor)
        else:
            gd = self.switch_backends(FigureCanvasGD)
            gd.print_figure(filename, dpi, facecolor, edgecolor)

        self.figure.dpi.set(origDPI)
        for a in self.figure.axes: a.resize()
    
