/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.File;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import php.java.bridge.DynamicHttpURLConnectionHandler;
import php.java.bridge.Util;

public class DynamicClassLoader
extends SecureClassLoader {
    protected static Map classLoaderCache = Collections.synchronizedMap(new HashMap());
    protected static Map parentCacheMap = new WeakHashMap();
    public static long defaultCacheTimeout = 2000L;
    public static boolean defaultLazy = true;
    protected static final String nf = "not found";
    private static int instanceCount = 0;
    private static long debugStart = System.currentTimeMillis();
    private static String ENTRY_SEPARATOR = ";";
    protected int instanceIndex;
    protected HashMap classLoaders;
    protected LinkedList classPaths;
    protected LinkedList urlsToAdd;
    protected long cacheTimeout;
    protected boolean lazy;
    protected HashMap parentCache;
    private URLClassLoaderFactory factory = new URLClassLoaderFactory();
    private static final ReferenceQueue TEMP_FILE_QUEUE = new ReferenceQueue();
    private static final Set DELETE_TEMP_FILE_ACTIONS = Collections.synchronizedSet(new HashSet());
    static final TempFileObserver THE_TEMP_FILE_OBSERVER = new TempFileObserver("JavaBridgeTempFileObserver");
    static /* synthetic */ Class class$php$java$bridge$DynamicClassLoader;
    static /* synthetic */ Class class$php$java$bridge$SessionFactory;

    protected String arrayToString(URL[] uRLArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < uRLArray.length; ++i) {
            stringBuffer.append(String.valueOf(uRLArray[i]));
            if (i + 1 == uRLArray.length) continue;
            stringBuffer.append(ENTRY_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    static void debugMsg(String string) {
        if (Util.logLevel > 5) {
            Util.logDebug(System.currentTimeMillis() - debugStart + "::" + string);
        }
    }

    static void clearCache() {
        classLoaderCache.clear();
    }

    public static void invalidate(URL[] uRLArray) {
        DynamicClassLoader.invalidate(DynamicClassLoader.getStringFromURLArray(uRLArray));
    }

    public static void invalidate(String string) {
        if (Util.logLevel > 5) {
            Util.logDebug("DynamicClassLoader.invalidate(" + string + ")\n");
        }
        classLoaderCache.remove(string);
    }

    static final String getStringFromURLArray(URL[] uRLArray) {
        if (uRLArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(uRLArray[0].toExternalForm());
        for (int i = 1; i < uRLArray.length; ++i) {
            stringBuffer.append(';');
            stringBuffer.append(uRLArray[i].toExternalForm());
        }
        return stringBuffer.toString();
    }

    static final URL[] getURLArrayFromString(String string) throws MalformedURLException {
        URL[] uRLArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray = stringTokenizer.nextToken();
            URL uRL = new URL((String)uRLArray);
            arrayList.add(uRL);
        }
        uRLArray = new URL[arrayList.size()];
        arrayList.toArray(uRLArray);
        return uRLArray;
    }

    private void init() {
        this.classLoaders = new HashMap();
        this.classPaths = new LinkedList();
        this.urlsToAdd = new LinkedList();
    }

    protected void copyInto(DynamicClassLoader dynamicClassLoader) {
        dynamicClassLoader.instanceIndex = this.instanceIndex;
        dynamicClassLoader.classLoaders = this.classLoaders;
        dynamicClassLoader.classPaths = this.classPaths;
        dynamicClassLoader.urlsToAdd = this.urlsToAdd;
        dynamicClassLoader.cacheTimeout = this.cacheTimeout;
        dynamicClassLoader.lazy = this.lazy;
        dynamicClassLoader.parentCache = this.parentCache;
    }

    protected DynamicClassLoader(DynamicClassLoader dynamicClassLoader) {
        super(dynamicClassLoader.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DynamicClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.init();
        this.cacheTimeout = defaultCacheTimeout;
        this.lazy = defaultLazy;
        this.instanceIndex = instanceCount++;
        Map map = parentCacheMap;
        synchronized (map) {
            this.parentCache = (HashMap)parentCacheMap.get(classLoader);
            if (this.parentCache == null) {
                this.parentCache = new HashMap();
                parentCacheMap.put(classLoader, this.parentCache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DynamicClassLoader() {
        this.init();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        this.cacheTimeout = defaultCacheTimeout;
        this.lazy = defaultLazy;
        Map map = parentCacheMap;
        synchronized (map) {
            this.parentCache = (HashMap)parentCacheMap.get(classLoader);
            if (this.parentCache == null) {
                this.parentCache = new HashMap();
                parentCacheMap.put(classLoader, this.parentCache);
            }
        }
    }

    protected void clearLoader() {
        if (Util.logLevel > 5) {
            Util.logDebug("DynamicClassLoader(" + System.identityHashCode(this) + ").clear()\n");
        }
        this.classLoaders.clear();
        this.classPaths.clear();
        this.urlsToAdd.clear();
    }

    protected void setLazy(boolean bl) {
        this.lazy = bl;
    }

    protected void setCacheTimeout(long l) {
        this.cacheTimeout = l;
    }

    protected void addURLs(URL[] uRLArray) {
        this.addURLs(DynamicClassLoader.getStringFromURLArray(uRLArray), uRLArray, this.lazy);
    }

    protected void addURLs(URL[] uRLArray, boolean bl) {
        this.addURLs(DynamicClassLoader.getStringFromURLArray(uRLArray), uRLArray, bl);
    }

    protected void addURLs(String string) throws MalformedURLException {
        this.addURLs(string, DynamicClassLoader.getURLArrayFromString(string), this.lazy);
    }

    protected void addURLs(String string, boolean bl) throws MalformedURLException {
        this.addURLs(string, DynamicClassLoader.getURLArrayFromString(string), bl);
    }

    protected void addURL(URL uRL, boolean bl) {
        URL[] uRLArray = new URL[]{uRL};
        this.addURLs(uRLArray, bl);
    }

    protected void addURL(URL uRL) {
        URL[] uRLArray = new URL[]{uRL};
        this.addURLs(uRLArray, this.lazy);
    }

    protected void addURLs(String string, URL[] uRLArray, boolean bl) {
        if (bl) {
            this.lazyAddURLs(string, uRLArray);
        } else {
            this.realAddURLs(string, uRLArray);
        }
    }

    protected URLClassLoaderEntry realAddURLs(String string, URL[] uRLArray) {
        URLClassLoaderEntry uRLClassLoaderEntry;
        if (Util.logLevel > 5) {
            Util.logDebug("DynamicClassLoader(" + System.identityHashCode(this) + ").realAddURLs(\"" + string + "\"," + DynamicClassLoader.getStringFromURLArray(uRLArray) + ")\n");
        }
        if ((uRLClassLoaderEntry = this.getClassPathFromCache(string)) == null) {
            uRLClassLoaderEntry = this.createURLClassLoader(string, uRLArray);
        } else {
            long l;
            long l2 = System.currentTimeMillis();
            if (uRLClassLoaderEntry.lastModified + this.cacheTimeout < l2 && (l = this.getLastModified(uRLArray)) > uRLClassLoaderEntry.lastModified) {
                uRLClassLoaderEntry = this.createURLClassLoader(string, uRLArray);
            }
        }
        if (uRLClassLoaderEntry != null) {
            if (!this.classLoaders.containsKey(string)) {
                this.classPaths.add(string);
            }
            this.classLoaders.put(string, uRLClassLoaderEntry);
        }
        return uRLClassLoaderEntry;
    }

    protected void lazyAddURLs(String string, URL[] uRLArray) {
        if (Util.logLevel > 5) {
            Util.logDebug("DynamicClassLoader(" + System.identityHashCode(this) + ").lazyAddURLs(\"" + string + "\"," + DynamicClassLoader.getStringFromURLArray(uRLArray) + ")\n");
        }
        Object[] objectArray = new Object[]{string, uRLArray};
        this.urlsToAdd.add(objectArray);
    }

    protected URLClassLoaderEntry addDelayedURLs() {
        if (this.urlsToAdd.isEmpty()) {
            return null;
        }
        Object[] objectArray = (Object[])this.urlsToAdd.getFirst();
        this.urlsToAdd.removeFirst();
        return this.realAddURLs((String)objectArray[0], (URL[])objectArray[1]);
    }

    protected long getLastModified(URL[] uRLArray) {
        long l = 0L;
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL = uRLArray[i];
            long l2 = 0L;
            try {
                Object object;
                if (uRL.getProtocol().equals("file")) {
                    object = new File(uRL.getPath());
                    if (((File)object).isFile()) {
                        l2 = ((File)object).lastModified();
                    } else if (((File)object).isDirectory()) {
                        return 0L;
                    }
                } else {
                    object = uRL.openConnection();
                    l2 = ((URLConnection)object).getLastModified();
                }
                if (l2 <= l) continue;
                l = l2;
                continue;
            }
            catch (IOException iOException) {
                Util.printStackTrace(iOException);
            }
        }
        return l;
    }

    protected void setUrlClassLoaderFactory(URLClassLoaderFactory uRLClassLoaderFactory) {
        this.factory = uRLClassLoaderFactory;
    }

    public static final void destroyObserver() {
        THE_TEMP_FILE_OBSERVER.interrupt();
    }

    private static URL[] rewriteURLs(URL[] uRLArray, List list) {
        URL[] uRLArray2 = new URL[uRLArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL = uRLArray[i];
            String string = uRL.getProtocol();
            if (!"file".equals(string) && !"jar".equals(string)) {
                try {
                    DynamicHttpURLConnectionHandler dynamicHttpURLConnectionHandler = new DynamicHttpURLConnectionHandler();
                    uRL = new URL("jar", null, -1, uRL.toExternalForm() + "!/", dynamicHttpURLConnectionHandler);
                    list.add(dynamicHttpURLConnectionHandler);
                }
                catch (MalformedURLException malformedURLException) {
                    Util.printStackTrace(malformedURLException);
                }
            }
            uRLArray2[i] = uRL;
        }
        return uRLArray2;
    }

    private SoftReference getReference(URLClassLoaderEntry uRLClassLoaderEntry, List list) {
        if (list.isEmpty()) {
            return new SoftReference<URLClassLoaderEntry>(uRLClassLoaderEntry);
        }
        return new DeleteTempFileAction(uRLClassLoaderEntry, TEMP_FILE_QUEUE, list);
    }

    protected URLClassLoaderEntry createURLClassLoader(String string, URL[] uRLArray) {
        LinkedList linkedList = new LinkedList();
        uRLArray = DynamicClassLoader.rewriteURLs(uRLArray, linkedList);
        if (Util.logLevel > 5) {
            Util.logDebug("DynamicClassLoader(" + System.identityHashCode(this) + ").createURLClassLoader(\"" + string + "\"," + DynamicClassLoader.getStringFromURLArray(uRLArray) + ")\n");
        }
        URLClassLoader uRLClassLoader = this.factory.createUrlClassLoader(string, uRLArray, this.getParent());
        URLClassLoaderEntry uRLClassLoaderEntry = new URLClassLoaderEntry(uRLClassLoader, System.currentTimeMillis());
        SoftReference softReference = this.getReference(uRLClassLoaderEntry, linkedList);
        classLoaderCache.put(string, softReference);
        return uRLClassLoaderEntry;
    }

    protected URLClassLoaderEntry getClassPathFromCache(String string) {
        Object object = this.classLoaders.get(string);
        if (object == null && (object = classLoaderCache.get(string)) != null) {
            object = ((SoftReference)object).get();
        }
        return (URLClassLoaderEntry)object;
    }

    protected void addURLClassLoader(String string, URLClassLoader uRLClassLoader, long l) {
        URLClassLoaderEntry uRLClassLoaderEntry = (URLClassLoaderEntry)this.classLoaders.get(string);
        if (uRLClassLoaderEntry == null) {
            uRLClassLoaderEntry = new URLClassLoaderEntry(uRLClassLoader, l);
            this.classLoaders.put(string, uRLClassLoaderEntry);
        } else if (uRLClassLoaderEntry.lastModified < l) {
            uRLClassLoaderEntry.cl = uRLClassLoader;
            uRLClassLoaderEntry.lastModified = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String string) throws ClassNotFoundException {
        HashMap hashMap;
        Class<?> clazz = null;
        if (Util.logLevel > 5) {
            Util.logDebug("DynamicClassLoader(" + System.identityHashCode(this) + ").loadClass(" + string + ")\n");
        }
        if (Util.logLevel > 5) {
            Util.logDebug("Trying parent\n");
        }
        Object var3_3 = null;
        Object object = this.parentCache;
        synchronized (object) {
            var3_3 = this.parentCache.get(string);
            if (var3_3 != nf && var3_3 != null) {
                return var3_3;
            }
        }
        object = this.classPaths.iterator();
        URLClassLoaderEntry uRLClassLoaderEntry = null;
        while (object.hasNext()) {
            uRLClassLoaderEntry = (URLClassLoaderEntry)this.classLoaders.get(object.next());
            if (Util.logLevel > 5) {
                Util.logDebug("Trying " + System.identityHashCode(uRLClassLoaderEntry.cl) + "\n");
            }
            hashMap = uRLClassLoaderEntry.cache;
            synchronized (hashMap) {
                var3_3 = uRLClassLoaderEntry.cache.get(string);
                if (var3_3 != nf) {
                    if (var3_3 != null) {
                        return var3_3;
                    }
                    try {
                        clazz = uRLClassLoaderEntry.cl.loadClass(string);
                        uRLClassLoaderEntry.cache.put(string, clazz);
                        return clazz;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        uRLClassLoaderEntry.cache.put(string, nf);
                    }
                }
            }
        }
        uRLClassLoaderEntry = this.addDelayedURLs();
        while (uRLClassLoaderEntry != null) {
            if (Util.logLevel > 5) {
                Util.logDebug("Trying " + System.identityHashCode(uRLClassLoaderEntry.cl) + "\n");
            }
            hashMap = uRLClassLoaderEntry.cache;
            synchronized (hashMap) {
                var3_3 = uRLClassLoaderEntry.cache.get(string);
                if (var3_3 != nf) {
                    if (var3_3 != null) {
                        return var3_3;
                    }
                    try {
                        clazz = uRLClassLoaderEntry.cl.loadClass(string);
                        uRLClassLoaderEntry.cache.put(string, clazz);
                        return clazz;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        uRLClassLoaderEntry.cache.put(string, nf);
                    }
                }
            }
            uRLClassLoaderEntry = this.addDelayedURLs();
        }
        try {
            clazz = super.loadClass(string);
            this.parentCache.put(string, clazz);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.parentCache.put(string, nf);
            if (clazz == null) {
                throw new ClassNotFoundException("Class " + string + " not found");
            }
            return clazz;
        }
    }

    protected Enumeration findResources(String string) throws IOException {
        Vector<URL> vector = new Vector<URL>();
        Enumeration<URL> enumeration = super.findResources(string);
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        Iterator iterator = this.classPaths.iterator();
        URLClassLoaderEntry uRLClassLoaderEntry = null;
        while (iterator.hasNext()) {
            uRLClassLoaderEntry = (URLClassLoaderEntry)this.classLoaders.get(iterator.next());
            enumeration = uRLClassLoaderEntry.cl.findResources(string);
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        uRLClassLoaderEntry = this.addDelayedURLs();
        while (uRLClassLoaderEntry != null) {
            enumeration = uRLClassLoaderEntry.cl.findResources(string);
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
            uRLClassLoaderEntry = this.addDelayedURLs();
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL findResource(String string) {
        HashMap hashMap;
        String string2 = "@" + string;
        URL uRL = null;
        Object object = this.parentCache;
        synchronized (object) {
            uRL = (URL)this.parentCache.get(string2);
            if (uRL != nf && uRL != null) {
                return uRL;
            }
        }
        object = this.classPaths.iterator();
        URLClassLoaderEntry uRLClassLoaderEntry = null;
        while (object.hasNext()) {
            uRLClassLoaderEntry = (URLClassLoaderEntry)this.classLoaders.get(object.next());
            hashMap = uRLClassLoaderEntry.cache;
            synchronized (hashMap) {
                uRL = uRLClassLoaderEntry.cache.get(string2);
                if (uRL != nf && uRL != null) {
                    return uRL;
                }
                uRL = uRLClassLoaderEntry.cl.findResource(string);
                if (uRL != null) {
                    uRLClassLoaderEntry.cache.put(string2, uRL);
                    return uRL;
                }
                uRLClassLoaderEntry.cache.put(string2, nf);
            }
        }
        uRLClassLoaderEntry = this.addDelayedURLs();
        while (uRLClassLoaderEntry != null) {
            hashMap = uRLClassLoaderEntry.cache;
            synchronized (hashMap) {
                uRL = uRLClassLoaderEntry.cache.get(string2);
                if (uRL != nf && uRL != null) {
                    return uRL;
                }
                uRL = uRLClassLoaderEntry.cl.findResource(string);
                if (uRL != null) {
                    uRLClassLoaderEntry.cache.put(string2, uRL);
                    return uRL;
                }
                uRLClassLoaderEntry.cache.put(string2, nf);
            }
            uRLClassLoaderEntry = this.addDelayedURLs();
        }
        uRL = super.findResource(string);
        if (uRL != null) {
            this.parentCache.put(string2, uRL);
            return uRL;
        }
        this.parentCache.put(string2, nf);
        return null;
    }

    private static class DeleteTempFileAction
    extends SoftReference {
        List handlers;

        public DeleteTempFileAction(Object object, ReferenceQueue referenceQueue, List list) {
            super(object, referenceQueue);
            this.handlers = list;
            DELETE_TEMP_FILE_ACTIONS.add(this);
            if (Util.logLevel > 4) {
                int n = 0;
                int n2 = 0;
                Iterator iterator = DELETE_TEMP_FILE_ACTIONS.iterator();
                while (iterator.hasNext()) {
                    SoftReference softReference = (SoftReference)iterator.next();
                    ++n;
                    if (softReference.get() != null) continue;
                    ++n2;
                }
                Util.logDebug("classloader stats: entries: " + n + " orphaned: " + n2);
            }
        }

        public void command() {
            Iterator iterator = this.handlers.iterator();
            while (iterator.hasNext()) {
                DynamicHttpURLConnectionHandler dynamicHttpURLConnectionHandler = (DynamicHttpURLConnectionHandler)iterator.next();
                dynamicHttpURLConnectionHandler.deleteTempFile();
            }
        }
    }

    private static final class TempFileObserver
    extends Thread {
        public TempFileObserver(String string) {
            super(string);
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            block5: {
                if (Util.logLevel > 5) {
                    System.out.println("lifecycle: init observer " + System.identityHashCode(class$php$java$bridge$DynamicClassLoader == null ? (class$php$java$bridge$DynamicClassLoader = DynamicClassLoader.class$("php.java.bridge.DynamicClassLoader")) : class$php$java$bridge$DynamicClassLoader));
                }
                try {
                    while (!TempFileObserver.interrupted()) {
                        DeleteTempFileAction deleteTempFileAction = (DeleteTempFileAction)TEMP_FILE_QUEUE.remove();
                        deleteTempFileAction.command();
                        DELETE_TEMP_FILE_ACTIONS.remove(deleteTempFileAction);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (Util.logLevel <= 5) break block5;
                    System.out.println("lifecycle: observer got interrupt" + System.identityHashCode(class$php$java$bridge$SessionFactory == null ? (class$php$java$bridge$SessionFactory = DynamicClassLoader.class$("php.java.bridge.SessionFactory")) : class$php$java$bridge$SessionFactory));
                }
            }
            if (Util.logLevel > 5) {
                System.out.println("lifecycle: observer terminating " + System.identityHashCode(class$php$java$bridge$DynamicClassLoader == null ? (class$php$java$bridge$DynamicClassLoader = DynamicClassLoader.class$("php.java.bridge.DynamicClassLoader")) : class$php$java$bridge$DynamicClassLoader));
            }
        }
    }

    protected static class URLClassLoaderFactory {
        protected URLClassLoaderFactory() {
        }

        public URLClassLoader createUrlClassLoader(String string, URL[] uRLArray, ClassLoader classLoader) {
            return new URLClassLoader(uRLArray, classLoader);
        }
    }

    protected class URLClassLoaderEntry {
        URLClassLoader cl;
        long lastModified;
        HashMap cache = new HashMap();

        public String toString() {
            return String.valueOf(DynamicClassLoader.this.arrayToString(this.cl.getURLs()));
        }

        protected URLClassLoaderEntry(URLClassLoader uRLClassLoader, long l) {
            this.cl = uRLClassLoader;
            this.lastModified = l;
        }
    }
}

