/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import php.java.bridge.ISession;
import php.java.bridge.JavaBridge;
import php.java.bridge.NotImplementedException;
import php.java.bridge.Request;
import php.java.bridge.SimpleJavaBridgeClassLoader;
import php.java.bridge.Util;
import php.java.bridge.http.Context;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.IContextFactoryVisitor;

public class SimpleContextFactory
implements IContextFactoryVisitor {
    protected ISession session;
    protected ContextFactory visited;
    protected IContext context;
    private boolean isContextRunnerRunning = false;
    private boolean isValid = true;
    private boolean isManaged;
    private ClassLoader loader;

    protected SimpleContextFactory(String string, boolean bl) {
        this.isManaged = bl;
        this.visited = new ContextFactory(string, bl);
        this.visited.accept(this);
        this.setClassLoader(Util.getContextClassLoader());
    }

    public void recycle(String string) {
        this.visited.recycle(string);
    }

    public void destroy() {
        this.visited.destroy();
        this.session = null;
    }

    public synchronized void invalidate() {
        this.isValid = false;
        this.notifyAll();
    }

    public synchronized void initialize() {
        this.isContextRunnerRunning = true;
        this.getContext().setAttribute("php.java.bridge.JavaBridge", this.getBridge(), 100);
    }

    public synchronized void releaseManaged() throws InterruptedException {
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: servlet is waiting for ContextRunner " + System.identityHashCode(this));
        }
        if (this.isContextRunnerRunning) {
            while (this.isValid) {
                this.wait();
            }
            if (Util.logLevel > 4) {
                Util.logDebug("contextfactory: servlet done waiting for ContextRunner " + System.identityHashCode(this));
            }
        } else {
            if (Util.logLevel > 4) {
                Util.logDebug("contextfactory: servlet done w/o ContextRunner " + System.identityHashCode(this));
            }
            if (this.isManaged) {
                this.destroy();
            } else {
                this.release();
            }
        }
    }

    public synchronized void waitFor(long l) throws InterruptedException {
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: servlet waitFor() ContextFactory " + System.identityHashCode(this) + " for " + l + " ms");
        }
        if (this.isValid) {
            this.wait(l);
        }
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: servlet waitFor() ContextRunner " + System.identityHashCode(this));
        }
        if (this.isContextRunnerRunning && this.isValid) {
            this.wait();
        }
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: servlet done waitFor() ContextRunner " + System.identityHashCode(this));
        }
    }

    public String getId() {
        return this.visited.getId();
    }

    public String toString() {
        return "ContextFactory: " + this.visited + ", SimpleContextFactory: " + this.getClass() + ", current loader: " + this.loader;
    }

    protected IContext createContext() {
        return new Context();
    }

    public IContext getContext() {
        if (this.context == null) {
            this.setContext(this.createContext());
        }
        return this.context;
    }

    public boolean isNew() {
        return this.visited.isNew();
    }

    public JavaBridge getBridge() {
        return this.visited.getBridge();
    }

    public void visit(ContextFactory contextFactory) {
        this.visited = contextFactory;
    }

    public ISession getSession(String string, boolean bl, int n) {
        if (this.session != null) {
            return this.session;
        }
        this.session = this.visited.getSimpleSession(string, bl, n);
        return this.session;
    }

    public ISession getSession(boolean bl, int n) {
        return this.visited.getSimpleSession(bl, n);
    }

    public void setContext(IContext iContext) {
        this.context = iContext;
    }

    public void release() {
        this.visited.release();
    }

    public void recycle() {
        this.visited.recycle();
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public SimpleJavaBridgeClassLoader getJavaBridgeClassLoader() {
        return this.visited.getJavaBridgeClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("loader");
        }
        this.loader = classLoader;
    }

    public String getSocketName() {
        throw new NotImplementedException("Use the JSR 223 API or a servlet environment instead");
    }

    public String getRedirectString() {
        return this.getRedirectString("/JavaBridge");
    }

    public String getRedirectString(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getSocketName());
            stringBuffer.append("/");
            stringBuffer.append(string);
            URI uRI = new URI("h:127.0.0.1", stringBuffer.toString(), null);
            return uRI.toASCIIString() + ".phpjavabridge";
        }
        catch (URISyntaxException uRISyntaxException) {
            Util.printStackTrace(uRISyntaxException);
            StringBuffer stringBuffer = new StringBuffer("h:127.0.0.1:");
            stringBuffer.append(this.getSocketName());
            stringBuffer.append('/');
            stringBuffer.append(string);
            stringBuffer.append(".phpjavabridge");
            return stringBuffer.toString();
        }
    }

    public int parseHeader(Request request, byte[] byArray, int n) throws IOException {
        JavaBridge javaBridge = this.getBridge();
        byte by = (byte)(0xFF & byArray[n + 1]);
        javaBridge.out.write(0);
        javaBridge.out.flush();
        int n2 = 0xFF & byArray[n + 2] | 0xFF00 & byArray[n + 3] << 8;
        String string = new String(byArray, n + 4, n + n2, "ASCII");
        IContextFactory iContextFactory = (IContextFactory)javaBridge.getFactory();
        iContextFactory.recycle(string);
        if (by != -1) {
            request.init(by);
        }
        return n + n2 + 3;
    }
}

