/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import php.java.bridge.PhpProcedure;
import php.java.bridge.Request;
import php.java.bridge.Util;
import php.java.script.PhpScriptEngine;
import php.java.script.PhpScriptEngineFactory;
import php.java.script.PhpScriptException;
import php.java.script.SimplePhpScriptEngine;
import php.java.script.URLReader;

public class InvocablePhpScriptEngine
extends SimplePhpScriptEngine
implements Invocable {
    protected static final Object EMPTY_INCLUDE = "@";
    private static boolean registeredHook = false;
    private static final List engines = new LinkedList();
    private static final String PHP_EMPTY_SCRIPT = "<?php ?>";

    public InvocablePhpScriptEngine() {
    }

    public InvocablePhpScriptEngine(PhpScriptEngineFactory phpScriptEngineFactory) {
        super(phpScriptEngineFactory);
    }

    protected Object invoke(String string, Object[] objectArray) throws ScriptException, NoSuchMethodException {
        if (this.scriptClosure == null) {
            if (Util.logLevel > 4) {
                Util.warn((String)"Evaluating an empty script either because eval() has not been called or release() has been called.");
            }
            this.eval(PHP_EMPTY_SCRIPT);
        }
        try {
            return this.invoke(this.scriptClosure, string, objectArray);
        }
        catch (Request.AbortException abortException) {
            this.release();
            throw new ScriptException((Exception)((Object)abortException));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new NoSuchMethodException(String.valueOf(noSuchMethodError.getMessage()));
        }
    }

    public Object invokeFunction(String string, Object[] objectArray) throws ScriptException, NoSuchMethodException {
        return this.invoke(string, objectArray);
    }

    private void checkPhpClosure(Object object) {
        if (object == null) {
            throw new IllegalStateException("PHP script did not pass its continuation to us!. Please check if the previous call to eval() reported any errors. Or else check if it called OUR continuation.");
        }
    }

    protected Object invoke(Object object, String string, Object[] objectArray) throws ScriptException, NoSuchMethodException {
        this.checkPhpClosure(object);
        PhpProcedure phpProcedure = (PhpProcedure)Proxy.getInvocationHandler(object);
        try {
            return phpProcedure.invoke(this.script, string, objectArray);
        }
        catch (ScriptException scriptException) {
            throw scriptException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw noSuchMethodException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new NoSuchMethodException(String.valueOf(noSuchMethodError.getMessage()));
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new PhpScriptException("Invocation threw exception ", throwable);
        }
    }

    public Object invokeMethod(Object object, String string, Object[] objectArray) throws ScriptException, NoSuchMethodException {
        return this.invoke(object, string, objectArray);
    }

    public Object getInterface(Class clazz) {
        this.checkPhpClosure(this.script);
        return this.getInterface(this.script, clazz);
    }

    public Object getInterface(Object object, Class clazz) {
        Class[] classArray;
        this.checkPhpClosure(object);
        if (clazz == null) {
            classArray = Util.ZERO_PARAM;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz;
        }
        Class[] classArray3 = classArray;
        return PhpProcedure.createProxy((Class[])classArray3, (PhpProcedure)((PhpProcedure)Proxy.getInvocationHandler(object)));
    }

    protected Object eval(Reader reader, ScriptContext scriptContext, String string) throws ScriptException {
        if (reader instanceof URLReader) {
            return this.eval((URLReader)reader, scriptContext, string);
        }
        if (this.continuation != null || reader == null) {
            this.release();
        }
        if (reader == null) {
            return null;
        }
        this.setNewContextFactory();
        this.setName(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        Reader reader2 = null;
        char[] cArray = new char[8192];
        try {
            int n;
            reader2 = new StringReader(PhpScriptEngine.getStandardHeader("http://127.0.0.1:" + this.ctx.getSocketName() + "/JavaBridge"));
            while ((n = reader2.read(cArray)) > 0) {
                ((Writer)outputStreamWriter).write(cArray, 0, n);
            }
            reader2.close();
            reader2 = null;
            while ((n = reader.read(cArray)) > 0) {
                ((Writer)outputStreamWriter).write(cArray, 0, n);
            }
            reader2 = new StringReader("<?php java_context()->call(java_closure()); ?>");
            while ((n = reader2.read(cArray)) > 0) {
                ((Writer)outputStreamWriter).write(cArray, 0, n);
            }
            reader2.close();
            reader2 = null;
            ((Writer)outputStreamWriter).close();
            outputStreamWriter = null;
            reader2 = new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            this.script = this.doEval(reader2, scriptContext);
            if (this.script != null) {
                this.scriptClosure = this.script;
            }
        }
        catch (Exception exception) {
            Util.printStackTrace((Throwable)exception);
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof ScriptException) {
                throw (ScriptException)exception;
            }
            throw new ScriptException(exception);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    ((Writer)outputStreamWriter).close();
                }
                catch (IOException iOException) {}
            }
            if (reader2 != null) {
                try {
                    reader2.close();
                }
                catch (IOException iOException) {}
            }
            this.handleRelease();
        }
        return this.resultProxy;
    }

    protected Object eval(URLReader uRLReader, ScriptContext scriptContext, String string) throws ScriptException {
        if (this.continuation != null || uRLReader == null) {
            this.release();
        }
        if (uRLReader == null) {
            return null;
        }
        this.setNewContextFactory();
        this.setName(string);
        this.env.put("X_JAVABRIDGE_INCLUDE", EMPTY_INCLUDE);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        try {
            this.script = this.doEval(uRLReader, scriptContext);
            if (this.script != null) {
                this.scriptClosure = this.script;
            }
        }
        catch (Exception exception) {
            Util.printStackTrace((Throwable)exception);
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof ScriptException) {
                throw (ScriptException)exception;
            }
            throw new ScriptException(exception);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    ((Writer)outputStreamWriter).close();
                }
                catch (IOException iOException) {}
            }
            this.handleRelease();
        }
        return this.resultProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRelease() {
        List list = engines;
        synchronized (list) {
            if (!registeredHook) {
                registeredHook = true;
                try {
                    Runtime.getRuntime().addShutdownHook((Thread)new Util.Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (engines == null) {
                                return;
                            }
                            List list = engines;
                            synchronized (list) {
                                Iterator iterator = engines.iterator();
                                while (iterator.hasNext()) {
                                    InvocablePhpScriptEngine invocablePhpScriptEngine = (InvocablePhpScriptEngine)iterator.next();
                                    invocablePhpScriptEngine.releaseInternal();
                                    iterator.remove();
                                }
                            }
                        }
                    });
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            engines.add(this);
        }
    }

    private void releaseInternal() {
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        List list = engines;
        synchronized (list) {
            this.releaseInternal();
            engines.remove(this);
        }
    }
}

