/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import php.java.bridge.JavaBridgeRunner;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextServer;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.WriterOutputStream;
import php.java.script.HttpProxy;
import php.java.script.IPhpScriptContext;
import php.java.script.PhpScriptContext;
import php.java.script.PhpScriptContextFactory;
import php.java.script.PhpScriptEngineFactory;
import php.java.script.PhpScriptException;
import php.java.script.PhpScriptWriter;
import php.java.script.ResultProxy;

abstract class SimplePhpScriptEngine
extends AbstractScriptEngine {
    protected Object script = null;
    protected Object scriptClosure = null;
    protected String name = null;
    protected HttpProxy continuation = null;
    protected Map env = null;
    protected IContextFactory ctx = null;
    private ScriptEngineFactory factory = null;
    protected ResultProxy resultProxy;
    private static final Class[] EMPTY_PARAM = new Class[0];
    private static final Object[] EMPTY_ARG = new Object[0];
    private static final File winnt = new File("c:/winnt");
    private static final File windows = new File("c:/windows");
    protected static final HashMap processEnvironment = SimplePhpScriptEngine.getProcessEnvironment();
    private static HashMap defaultEnv;

    protected void initialize() {
        this.setContext(this.getPhpScriptContext());
    }

    static HashMap getProcessEnvironment() {
        Object object;
        if (defaultEnv != null) {
            return defaultEnv;
        }
        defaultEnv = new HashMap();
        String string = null;
        if (winnt.isDirectory()) {
            string = "c:\\winnt";
        } else if (windows.isDirectory()) {
            string = "c:\\windows";
        }
        try {
            object = System.getenv("SystemRoot");
            if (object != null) {
                string = object;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            object = System.getProperty("Windows.SystemRoot");
            if (object != null) {
                string = object;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string != null) {
            defaultEnv.put("SystemRoot", string);
        }
        try {
            object = System.class.getMethod("getenv", EMPTY_PARAM);
            Map map = (Map)((Method)object).invoke((Object)System.class, EMPTY_ARG);
            defaultEnv.putAll(map);
        }
        catch (Exception exception) {
            defaultEnv.putAll(Util.COMMON_ENVIRONMENT);
        }
        return defaultEnv;
    }

    public SimplePhpScriptEngine() {
        this.initialize();
    }

    public SimplePhpScriptEngine(PhpScriptEngineFactory phpScriptEngineFactory) {
        this();
        this.factory = phpScriptEngineFactory;
    }

    protected void setName(String string) {
        int n = string.length();
        if (n > 160) {
            n = 160;
        }
        this.name = string = string.substring(0, n);
    }

    protected void setStandardEnvironmentValues(Map map) {
        map.put("X_JAVABRIDGE_CONTEXT", this.ctx.getId());
        map.put("X_JAVABRIDGE_OVERRIDE_HOSTS", this.ctx.getRedirectString());
    }

    protected void addNewContextFactory() {
        this.ctx = PhpScriptContextFactory.addNew((IContext)this.getContext());
    }

    protected ContextServer getContextServer() {
        return JavaBridgeRunner.contextServer;
    }

    protected void setNewContextFactory() {
        ContextServer contextServer;
        AbstractChannelName abstractChannelName;
        this.env = (Map)processEnvironment.clone();
        this.addNewContextFactory();
        if (Util.USE_SHORT_PATH_S1 && (abstractChannelName = (contextServer = this.getContextServer()).getFallbackChannelName(null, this.ctx)) != null) {
            this.env.put("X_JAVABRIDGE_REDIRECT", abstractChannelName.getName());
            this.ctx.getBridge();
            contextServer.start(abstractChannelName);
        }
        this.setStandardEnvironmentValues(this.env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object eval(Reader reader, ScriptContext scriptContext, String string) throws ScriptException {
        if (reader == null) {
            this.release();
            return null;
        }
        if (this.continuation != null) {
            throw new IllegalStateException("continuation is not null.");
        }
        try {
            this.setNewContextFactory();
            this.setName(string);
            try {
                this.doEval(reader, scriptContext);
            }
            catch (Exception exception) {
                Util.printStackTrace((Throwable)exception);
                throw new PhpScriptException("Could not evaluate script", exception);
            }
        }
        finally {
            this.release();
        }
        return null;
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.eval(reader, scriptContext, String.valueOf(reader));
    }

    private void updateGlobalEnvironment(ScriptContext scriptContext) {
        Bindings bindings = scriptContext.getBindings(200);
        if (bindings == null) {
            return;
        }
        Iterator iterator = bindings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.env.put(k, v);
        }
    }

    protected HttpProxy getContinuation(Reader reader, ScriptContext scriptContext) {
        Util.HeaderParser headerParser = Util.DEFAULT_HEADER_PARSER;
        IPhpScriptContext iPhpScriptContext = (IPhpScriptContext)((Object)scriptContext);
        this.updateGlobalEnvironment(scriptContext);
        OutputStream outputStream = ((PhpScriptWriter)scriptContext.getWriter()).getOutputStream();
        OutputStream outputStream2 = ((PhpScriptWriter)scriptContext.getErrorWriter()).getOutputStream();
        if (outputStream instanceof WriterOutputStream) {
            headerParser = new HeaderParser((WriterOutputStream)outputStream);
        }
        this.resultProxy = new ResultProxy(this);
        HttpProxy httpProxy = new HttpProxy(reader, this.env, outputStream, outputStream2, headerParser, this.resultProxy);
        iPhpScriptContext.setContinuation(httpProxy);
        return httpProxy;
    }

    protected Object doEval(Reader reader, ScriptContext scriptContext) throws Exception {
        this.continuation = this.getContinuation(reader, scriptContext);
        this.continuation.start();
        return this.continuation.getPhpScript();
    }

    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        if (string == null) {
            return this.eval(null, scriptContext, null);
        }
        string = string.trim();
        StringReader stringReader = new StringReader(string);
        Object object = this.eval(stringReader, scriptContext, String.valueOf(string));
        try {
            ((Reader)stringReader).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return object;
    }

    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    protected ScriptContext getPhpScriptContext() {
        PhpScriptContext phpScriptContext = new PhpScriptContext();
        Bindings bindings = this.createBindings();
        phpScriptContext.setBindings(bindings, 100);
        phpScriptContext.setBindings(this.getBindings(200), 200);
        return phpScriptContext;
    }

    public void release() {
        if (this.continuation != null) {
            try {
                this.continuation.release();
                this.ctx.releaseManaged();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.ctx = null;
            this.continuation = null;
            this.script = null;
            this.scriptClosure = null;
            try {
                this.getContext().getWriter().flush();
            }
            catch (Exception exception) {
                Util.printStackTrace((Throwable)exception);
            }
            try {
                this.getContext().getErrorWriter().flush();
            }
            catch (Exception exception) {
                Util.printStackTrace((Throwable)exception);
            }
        }
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    public void close() throws IOException {
        this.release();
    }

    private final class HeaderParser
    extends Util.HeaderParser {
        private WriterOutputStream writer;

        public HeaderParser(WriterOutputStream writerOutputStream) {
            this.writer = writerOutputStream;
        }

        public void parseHeader(String string) {
            if (string == null) {
                return;
            }
            int n = string.indexOf(58);
            if (n == -1) {
                return;
            }
            String string2 = string.substring(0, n).trim().toLowerCase();
            String string3 = string.substring(n + 1).trim();
            this.addHeader(string2, string3);
        }

        public void addHeader(String string, String string2) {
            if (string2 != null && string.equals("content-type")) {
                int n = string2.indexOf(59);
                if (n == -1) {
                    return;
                }
                String string3 = string2.substring(n + 1).trim();
                if ((n = string3.indexOf(61)) == -1) {
                    return;
                }
                string3 = string3.substring(n + 1);
                this.writer.setEncoding(string3);
            }
        }
    }
}

