/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import php.java.bridge.JavaBridge;
import php.java.bridge.Response;
import php.java.bridge.Util;

class HexOutputBuffer
extends ByteArrayOutputStream {
    private final JavaBridge bridge;
    private byte[] buf = new byte[16];

    HexOutputBuffer(JavaBridge javaBridge) {
        this.bridge = javaBridge;
    }

    protected byte[] getFirstBytes() {
        byte[] byArray;
        int n = this.count;
        byte[] byArray2 = byArray = n > 256 ? Response.append_for_OutBuf_getFirstBytes : Response.append_none_for_OutBuf_getFirstBytes;
        if (n > 256) {
            n = 256;
        }
        byte[] byArray3 = new byte[n + byArray.length];
        System.arraycopy(((ByteArrayOutputStream)this).buf, 0, byArray3, 0, n);
        System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
        return byArray3;
    }

    protected void append(byte[] byArray) {
        try {
            this.write(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void appendQuoted(byte[] byArray) {
        block4: for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            switch (by) {
                case 38: {
                    this.append(Response.amp);
                    continue block4;
                }
                case 34: {
                    this.append(Response.quote);
                    continue block4;
                }
                default: {
                    this.write(by);
                }
            }
        }
    }

    protected void appendQuoted(String string) {
        this.appendQuoted(this.bridge.options.getBytes(string));
    }

    protected void append(long l) {
        int n = 16;
        do {
            this.buf[--n] = Util.HEX_DIGITS[(int)(l & 0xFL)];
        } while ((l >>>= 4) != 0L);
        this.write(this.buf, n, 16 - n);
    }

    protected void append(double d) {
        this.append(Double.toString(d).getBytes());
    }

    protected void appendLong(long l) {
        this.append(Response.L);
        if (l < 0L) {
            this.append(-l);
            this.append(Response.pa);
        } else {
            this.append(l);
            this.append(Response.po);
        }
    }

    protected void appendString(byte[] byArray) {
        this.append(Response.S);
        this.appendQuoted(byArray);
    }
}

