/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import php.java.bridge.AppThreadPool;
import php.java.bridge.ConstructorCache;
import php.java.bridge.FileLogger;
import php.java.bridge.GlobalRef;
import php.java.bridge.IJavaBridgeFactory;
import php.java.bridge.ISession;
import php.java.bridge.ISocketFactory;
import php.java.bridge.JarLibraryPath;
import php.java.bridge.JavaBridgeIllegalArgumentException;
import php.java.bridge.JavaBridgeSecurityManager;
import php.java.bridge.MethodCache;
import php.java.bridge.NoSuchConstantException;
import php.java.bridge.NoSuchProcedureException;
import php.java.bridge.Options;
import php.java.bridge.PhpArray;
import php.java.bridge.PhpExactNumber;
import php.java.bridge.PhpMap;
import php.java.bridge.PhpProcedure;
import php.java.bridge.PhpString;
import php.java.bridge.Request;
import php.java.bridge.Response;
import php.java.bridge.SessionFactory;
import php.java.bridge.SimpleJavaBridgeClassLoader;
import php.java.bridge.Standalone;
import php.java.bridge.StringCache;
import php.java.bridge.Util;

public class JavaBridge
implements Runnable {
    public Throwable lastException = null;
    protected Throwable lastAsyncException;
    GlobalRef globalRef = new GlobalRef();
    static HashMap sessionHash = new HashMap();
    public InputStream in;
    public OutputStream out;
    public int logLevel = Util.logLevel;
    public Request request;
    boolean canModifySecurityPermission = true;
    int uid = -1;
    int gid = -1;
    private MethodCache methodCache = new MethodCache();
    private ConstructorCache constructorCache = new ConstructorCache();
    StringCache stringCache = new StringCache(this);
    private IJavaBridgeFactory sessionFactory;
    Options options;
    private static final Iterator EMPTY_ITERATOR = new LinkedList().iterator();
    private Object[] o = new Object[1];
    private Class[] c = new Class[1];
    static final FindMatchingInterfaceVoid MATCH_VOID_ICASE = new FindMatchingInterfaceVoid(true);
    static final FindMatchingInterfaceVoid MATCH_VOID_CASE = new FindMatchingInterfaceVoid(false);
    private static final int DISPLAY_MAX_ELEMENTS = 10;
    private static final int DISPLAY_MAX_CHARS = 80;
    private Object contextCache = null;
    private ISession sessionCache = null;
    private static final HashMap emptyMap = new HashMap();
    protected static final String PHPSESSION = "PHPSESSION";
    protected static final String INTERNAL_PHPSESSION = "INTERNAL_PHPSESSION";
    private static int counter = 0;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Hashtable;

    public int getLogLevel() {
        return this.logLevel;
    }

    static native boolean openLog(String var0);

    static native int startNative(int var0, int var1, String var2);

    static native int accept(int var0);

    static native int swrite(int var0, byte[] var1, int var2);

    static native int sread(int var0, byte[] var1, int var2);

    public static native void sclose(int var0);

    public IJavaBridgeFactory getFactory() {
        if (this.sessionFactory == null) {
            throw new NullPointerException("session factory");
        }
        return this.sessionFactory;
    }

    public Options getOptions() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.logDebug("START: JavaBridge.run()");
            this.request = new Request(this);
            try {
                if (!this.request.init(this.in, this.out)) {
                    return;
                }
            }
            catch (Throwable throwable) {
                this.printStackTrace(throwable);
                return;
            }
            if (this.logLevel > 3) {
                this.logDebug("Request from client with uid/gid " + this.uid + "/" + this.gid);
            }
            try {
                this.request.handleRequests();
            }
            catch (Exception exception) {
                this.printStackTrace(exception);
            }
            this.globalRef = null;
            this.logDebug("END: JavaBridge.run()");
        }
        catch (Exception exception) {
            this.printStackTrace(exception);
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    this.printStackTrace(iOException);
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.printStackTrace(iOException);
                }
            }
            this.sessionFactory.destroy();
        }
    }

    public static ISocketFactory bind(String string) throws IOException {
        return Standalone.bind(Util.logLevel, string);
    }

    public static void init(String[] stringArray) {
        new Standalone().init(stringArray);
    }

    static void initLog(String string, int n, String[] stringArray) {
        String string2 = null;
        String string3 = null;
        if (n == -1) {
            n = Util.DEFAULT_LOG_LEVEL;
        }
        Util.logLevel = n;
        try {
            try {
                string2 = stringArray.length > 0 ? "" : Util.DEFAULT_LOG_FILE;
                string3 = string2;
                if (stringArray.length > 2) {
                    string3 = string2 = stringArray[2];
                    if (Util.setConfiguredLogger(string2)) {
                        string2 = null;
                    } else {
                        Util.setLogger(new FileLogger());
                    }
                    if (Util.logLevel > 3) {
                        System.err.println(Util.EXTENSION_NAME + " log: " + string3);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            boolean bl = false;
            try {
                bl = string2 == null || JavaBridge.openLog(string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Util.redirectOutput(bl, string2);
            Util.logMessage("VM                  : " + Util.VM_NAME);
            if (Util.VERSION != null) {
                Util.logMessage(Util.EXTENSION_NAME + " version             : " + Util.VERSION);
            }
            Util.logMessage("logFile             : " + string3);
            Util.logMessage("default logLevel    : " + Util.logLevel);
            Util.logMessage("socket              : " + string);
            Util.logMessage("java.ext.dirs       : " + System.getProperty("java.ext.dirs"));
            Util.logMessage("php.java.bridge.base: " + Util.JAVABRIDGE_BASE);
            Util.logMessage("thread pool size    : " + Util.THREAD_POOL_MAX_SIZE);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static void init(ISocketFactory iSocketFactory, int n, String[] stringArray) {
        try {
            Object object;
            Object object2;
            Object object3;
            AppThreadPool appThreadPool = Util.createThreadPool(Util.EXTENSION_NAME + "ThreadPool");
            try {
                object3 = System.getProperty("java.security.policy");
                object2 = Util.JAVABRIDGE_BASE;
                if (object3 != null && object2 != null) {
                    object = new JavaBridgeSecurityManager();
                    System.setSecurityManager((SecurityManager)object);
                    Util.logMessage(Util.EXTENSION_NAME + " policy base     : " + (String)object2);
                    Util.logMessage(Util.EXTENSION_NAME + " security policy : " + (String)object3);
                }
            }
            catch (Exception exception) {
                Util.logMessage("Cannot install security manager: " + exception);
            }
            Util.logDebug("Starting to accept Socket connections");
            while (true) {
                object3 = iSocketFactory.accept();
                Util.logDebug("Socket connection accepted");
                object2 = new SessionFactory().getBridge();
                ((JavaBridge)object2).in = ((Socket)object3).getInputStream();
                ((JavaBridge)object2).out = ((Socket)object3).getOutputStream();
                if (appThreadPool != null) {
                    Util.logDebug("Starting bridge thread from thread pool");
                    appThreadPool.start((Runnable)object2);
                    continue;
                }
                Util.logDebug("Starting new bridge thread");
                object = new Util.Thread((Runnable)object2);
                ((Thread)object).start();
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void main(String[] stringArray) {
        Standalone.main(stringArray);
    }

    public void printStackTrace(Throwable throwable) {
        if (this.logLevel > 0 && (throwable instanceof Error || this.logLevel > 1)) {
            Util.getLogger().printStackTrace(throwable);
        }
    }

    private String getId() {
        return Integer.toHexString(System.identityHashCode(this)) + "@" + Integer.toHexString(System.identityHashCode(Thread.currentThread()));
    }

    public void logDebug(String string) {
        if (this.logLevel > 3) {
            Util.println(4, this.getId() + " " + string);
        }
    }

    public void logFatal(String string) {
        if (this.logLevel > 0) {
            Util.println(1, this.getId() + " " + string);
        }
    }

    public void logError(String string) {
        if (this.logLevel > 1) {
            Util.println(2, this.getId() + " " + string);
        }
    }

    public void logMessage(String string) {
        if (this.logLevel > 2) {
            Util.println(3, this.getId() + " " + string);
        }
    }

    public void warn(String string) {
        if (this.logLevel > 0) {
            Util.warn(this.getId() + " " + string);
        }
    }

    void setException(Response response, Throwable throwable, String string, Object object, String string2, Object[] objectArray, Class[] classArray, boolean bl) {
        Serializable serializable;
        if (throwable instanceof InvocationTargetException) {
            serializable = ((InvocationTargetException)throwable).getTargetException();
            if (serializable != null) {
                throwable = serializable;
            }
            if (this.logLevel > 3 || !this.options.preferValues() && !bl) {
                this.printStackTrace(throwable);
            }
        } else {
            this.printStackTrace(throwable);
        }
        serializable = new StringBuffer(string);
        ((StringBuffer)serializable).append(" failed: ");
        if (object != null) {
            ((StringBuffer)serializable).append("[");
            Util.appendShortObject(object, (StringBuffer)serializable);
            ((StringBuffer)serializable).append("]->");
        } else {
            ((StringBuffer)serializable).append("new ");
        }
        ((StringBuffer)serializable).append(string2);
        String string3 = Util.argsToString(objectArray, classArray);
        if (string3.length() > 0) {
            ((StringBuffer)serializable).append("(");
            Util.appendArgs(objectArray, classArray, (StringBuffer)serializable);
            ((StringBuffer)serializable).append(")");
        }
        ((StringBuffer)serializable).append(".");
        ((StringBuffer)serializable).append(" Cause: ");
        ((StringBuffer)serializable).append(String.valueOf(throwable));
        ((StringBuffer)serializable).append(" VM: ");
        ((StringBuffer)serializable).append(Util.VM_NAME);
        this.lastException = new Exception(((StringBuffer)serializable).toString(), throwable);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray != null) {
            this.lastException.setStackTrace(stackTraceElementArray);
        }
        response.setResultException(this.lastException, bl);
    }

    private Exception getUnresolvedExternalReferenceException(Throwable throwable, String string) {
        return new ClassNotFoundException("Unresolved external reference: " + throwable + ". -- " + "Unable to " + string + ", see the README section \"Java platform issues\" " + "for details and DO NOT REPORT THIS PROBLEM TO THE PHP/Java Bridge MAILING LIST!", throwable);
    }

    public void CreateObject(String string, boolean bl, Object[] objectArray, Response response) {
        Class[] classArray = null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        boolean bl2 = true;
        try {
            Object[] objectArray2;
            Constructor constructor = null;
            ConstructorCache.Entry entry = null;
            Class clazz = this.getClassLoader().forName(string);
            if (bl && (constructor = this.constructorCache.get(entry = this.constructorCache.getEntry(string, objectArray))) == null) {
                objectArray2 = clazz.getConstructors();
                for (int i = 0; i < objectArray2.length; ++i) {
                    linkedList.add(objectArray2[i]);
                    if (((Constructor)objectArray2[i]).getParameterTypes().length != objectArray.length) continue;
                    linkedList2.add(objectArray2[i]);
                }
                constructor = (Constructor)this.select(linkedList2, objectArray);
                if (constructor != null) {
                    this.constructorCache.put(entry, constructor);
                }
            }
            if (constructor == null) {
                if (objectArray.length > 0) {
                    throw bl ? new InstantiationException("No matching constructor found. Candidates: " + String.valueOf(linkedList)) : new JavaBridgeIllegalArgumentException("ReferenceClass must be called w/o arguments; either write new JavaClass(\"" + string + "\") or new Java(\"" + string + "\", args...).");
                }
                if (bl && this.logLevel > 2) {
                    this.logMessage("No visible constructor found in: " + string + ", returning the class instead of an instance; this may not be what you want. Please correct this error or please use the function java(\"" + string + "\") instead.");
                }
                response.setResultClass(clazz);
                return;
            }
            classArray = entry.getParameterTypes(constructor);
            objectArray2 = this.coerce(classArray, objectArray, response);
            boolean bl3 = bl2 = constructor.getExceptionTypes().length != 0;
            if (this.logLevel > 4) {
                Object t = constructor.newInstance(objectArray2);
                JavaBridge.logInvoke(t, string, objectArray2);
                response.setResult(t, clazz, bl2);
            } else {
                response.setResult(constructor.newInstance(objectArray2), clazz, bl2);
            }
        }
        catch (Throwable throwable) {
            Exception exception;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable2).getTargetException();
            }
            if (throwable2 instanceof Request.AbortException) {
                throw (Request.AbortException)throwable2;
            }
            if (throwable2 instanceof OutOfMemoryError) {
                Util.logFatal("OutOfMemoryError");
                throw (OutOfMemoryError)throwable2;
            }
            if (throwable2 instanceof NoClassDefFoundError) {
                this.getClassLoader().reset();
                exception = this.getUnresolvedExternalReferenceException(throwable2, "call constructor");
            }
            this.setException(response, exception, bl ? "CreateInstance" : "ReferenceClass", null, string, objectArray, classArray, bl2);
        }
    }

    private int weight(Class clazz, Class clazz2, Object object) {
        int n = 0;
        if (clazz.isAssignableFrom(clazz2)) {
            Class clazz3 = clazz2;
            while ((clazz3 = clazz3.getSuperclass()) != null && clazz.isAssignableFrom(clazz3)) {
                n += 16;
            }
        } else if (clazz == String.class) {
            if (!String.class.isAssignableFrom(clazz2) && !PhpString.class.isAssignableFrom(clazz2)) {
                n = [B.class.isAssignableFrom(clazz2) ? (n += 32) : (n += 8000);
            }
        } else if (clazz.isArray()) {
            if (PhpString.class.isAssignableFrom(clazz2)) {
                Class<?> clazz4 = clazz.getComponentType();
                n = clazz4 == Byte.TYPE ? (n += 32) : (n += 9999);
            } else if (clazz2 == PhpArray.class) {
                Iterator iterator;
                Iterator iterator2 = iterator = object == null ? EMPTY_ITERATOR : ((Map)object).values().iterator();
                if (iterator.hasNext()) {
                    Class<?> clazz5;
                    Object v = iterator.next();
                    Class<?> clazz6 = clazz.getComponentType();
                    if (clazz6 != (clazz5 = v.getClass())) {
                        n += (clazz6 == Object.class ? 10 : 8200) + this.weight(clazz6, clazz5, null);
                    }
                }
            } else if (clazz2.isArray()) {
                Class<?> clazz7;
                Class<?> clazz8 = clazz.getComponentType();
                if (clazz8 != (clazz7 = clazz2.getComponentType())) {
                    n += (clazz8 == Object.class ? 10 : 8200) + this.weight(clazz8, clazz7, null);
                }
            } else {
                n += 9999;
            }
        } else if (Collection.class.isAssignableFrom(clazz)) {
            if (Map.class.isAssignableFrom(clazz2)) {
                n += 8100;
            } else if (!PhpArray.class.isAssignableFrom(clazz2)) {
                n += 9999;
            }
        } else if (clazz.isPrimitive()) {
            Class clazz9 = clazz;
            if (Number.class.isAssignableFrom(clazz2)) {
                n = Double.class.isAssignableFrom(clazz2) ? (clazz9 == Float.TYPE ? ++n : (clazz9 == Double.TYPE ? (n += 0) : (n += 256))) : (clazz9 == Boolean.TYPE ? (n += 5) : (clazz9 == Character.TYPE ? (n += 4) : (clazz9 == Byte.TYPE ? (n += 3) : (clazz9 == Short.TYPE ? (n += 2) : (clazz9 == Integer.TYPE ? ++n : (clazz9 == Long.TYPE ? (n += 0) : (n += 256)))))));
            } else if (Boolean.class.isAssignableFrom(clazz2)) {
                if (clazz9 != Boolean.TYPE) {
                    n += 9999;
                }
            } else if (Character.class.isAssignableFrom(clazz2)) {
                if (clazz9 != Character.TYPE) {
                    n += 9999;
                }
            } else {
                n = String.class.isAssignableFrom(clazz2) || PhpString.class.isAssignableFrom(clazz2) ? (n += 64) : (n += 9999);
            }
        } else if (Number.class.isAssignableFrom(clazz)) {
            if (clazz == Float.class || clazz == Double.class) {
                if (!Double.class.isAssignableFrom(clazz2)) {
                    n += 9999;
                }
            } else if (!PhpExactNumber.class.isAssignableFrom(clazz2)) {
                n += 9999;
            }
        } else {
            n += 9999;
        }
        if (this.logLevel > 4) {
            this.logDebug("weight " + clazz + " " + clazz2 + ": " + n);
        }
        return n;
    }

    private Object select(LinkedList linkedList, Object[] objectArray) {
        if (linkedList.size() == 1) {
            return linkedList.getFirst();
        }
        Object var3_3 = null;
        Object var4_4 = null;
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        Object object = linkedList.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            int n3 = 0;
            Class<?>[] classArray = e instanceof Method ? ((Method)e).getParameterTypes() : ((Constructor)e).getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                Object object2 = objectArray[i];
                if (object2 == null) continue;
                n3 += this.weight(classArray[i], object2.getClass(), object2);
            }
            if (n3 < n) {
                if (n3 == 0) {
                    if (this.logLevel > 4) {
                        this.logDebug("Selected: " + e + " " + n3);
                    }
                    return e;
                }
                n = n3;
                var4_4 = e;
                if (this.logLevel > 2) {
                    var3_3 = null;
                    if (this.logLevel > 4) {
                        this.logDebug("best: " + var4_4 + " " + n3);
                    }
                }
            } else if (this.logLevel > 2) {
                if (n3 == n) {
                    var3_3 = e;
                }
                if (this.logLevel > 4) {
                    this.logDebug("skip: " + e + " " + n3);
                }
            }
            ++n2;
        }
        if (this.logLevel > 2 && var3_3 != null) {
            object = new StringBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                Util.appendParam(objectArray[i], (StringBuffer)object);
            }
            this.logMessage("Portability warning: " + var4_4 + " and " + var3_3 + " both match " + ((StringBuffer)object).toString());
        }
        if (this.logLevel > 4) {
            this.logDebug("Selected: " + var4_4 + " " + n);
        }
        return var4_4;
    }

    Object coerce(Class clazz, Object object, Response response) {
        this.o[0] = object;
        this.c[0] = clazz;
        return this.coerce(this.c, this.o, response)[0];
    }

    Object[] coerce(Class[] classArray, Object[] objectArray, Response response) {
        Object[] objectArray2 = objectArray;
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4 = objectArray[i];
            if (object4 == null) continue;
            if (classArray[i] == (class$java$lang$String == null ? JavaBridge.class$("java.lang.String") : class$java$lang$String)) {
                if (object4 instanceof PhpString) {
                    objectArray2[i] = ((PhpString)object4).getString();
                    continue;
                }
                objectArray2[i] = object4.toString();
                continue;
            }
            if (object4 instanceof PhpString || object4 instanceof String) {
                if (!classArray[i].isArray()) {
                    object3 = classArray[i];
                    objectArray2[i] = object2 = object4 instanceof String ? (String)object4 : ((PhpString)object4).getString();
                    try {
                        if (object3 == Boolean.TYPE) {
                            objectArray2[i] = new Boolean((String)object2);
                            continue;
                        }
                        if (object3 == Byte.TYPE) {
                            objectArray2[i] = new Byte((String)object2);
                            continue;
                        }
                        if (object3 == Short.TYPE) {
                            objectArray2[i] = new Short((String)object2);
                            continue;
                        }
                        if (object3 == Integer.TYPE) {
                            objectArray2[i] = new Integer((String)object2);
                            continue;
                        }
                        if (object3 == Float.TYPE) {
                            objectArray2[i] = new Float((String)object2);
                            continue;
                        }
                        if (object3 == Double.TYPE) {
                            objectArray2[i] = new Double((String)object2);
                            continue;
                        }
                        if (object3 == Long.TYPE) {
                            objectArray2[i] = new Long((String)object2);
                            continue;
                        }
                        if (object3 != Character.TYPE || ((String)object2).length() <= 0) continue;
                        objectArray2[i] = new Character(((String)object2).charAt(0));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.printStackTrace(numberFormatException);
                    }
                    continue;
                }
                objectArray2[i] = ((PhpString)object4).getBytes();
                continue;
            }
            if (object4 instanceof Number) {
                if (classArray[i].isPrimitive()) {
                    object3 = classArray[i];
                    object2 = (Number)object4;
                    if (object3 == Boolean.TYPE) {
                        objectArray2[i] = new Boolean(0.0 != (double)((Number)object2).floatValue());
                        continue;
                    }
                    if (object3 == Byte.TYPE) {
                        objectArray2[i] = new Byte(((Number)object2).byteValue());
                        continue;
                    }
                    if (object3 == Short.TYPE) {
                        objectArray2[i] = new Short(((Number)object2).shortValue());
                        continue;
                    }
                    if (object3 == Integer.TYPE) {
                        objectArray2[i] = new Integer(((Number)object2).intValue());
                        continue;
                    }
                    if (object3 == Float.TYPE) {
                        objectArray2[i] = new Float(((Number)object2).floatValue());
                        continue;
                    }
                    if (object3 == Double.TYPE) {
                        objectArray2[i] = new Double(((Number)object2).doubleValue());
                        continue;
                    }
                    if (object3 != Long.TYPE || object2 instanceof Long) continue;
                    objectArray2[i] = new Long(((Number)object2).longValue());
                    continue;
                }
                if (object4.getClass() != (class$php$java$bridge$PhpExactNumber == null ? JavaBridge.class$("php.java.bridge.PhpExactNumber") : class$php$java$bridge$PhpExactNumber)) continue;
                object3 = classArray[i];
                if (((Class)object3).isAssignableFrom(class$java$lang$Integer == null ? JavaBridge.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    objectArray2[i] = new Integer(((Number)object4).intValue());
                    continue;
                }
                objectArray2[i] = new Long(((Number)object4).longValue());
                continue;
            }
            if (!(object4 instanceof PhpArray)) continue;
            if (classArray[i].isArray()) {
                object3 = null;
                object2 = null;
                object = null;
                Class<?> clazz = classArray[i].getComponentType();
                try {
                    object = (PhpArray)object4;
                    n = ((PhpArray)object).arraySize();
                    clazz = classArray[i].getComponentType();
                    object2 = Array.newInstance(clazz, n);
                }
                catch (Exception exception) {
                    throw new JavaBridgeIllegalArgumentException("Could not create array from Map: " + JavaBridge.firstChars(object4), exception);
                }
                try {
                    Iterator iterator = ((PhpArray)object).entrySet().iterator();
                    while (iterator.hasNext()) {
                        object3 = (Map.Entry)iterator.next();
                        Array.set(object2, ((Number)object3.getKey()).intValue(), this.coerce(clazz, object3.getValue(), response));
                    }
                    objectArray2[i] = object2;
                    continue;
                }
                catch (Exception exception) {
                    throw new JavaBridgeIllegalArgumentException("Could not create array of type: " + clazz + ", size: " + n + ", " + " failed entry at: " + object3, exception);
                }
            }
            if ((class$java$util$Collection == null ? JavaBridge.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(classArray[i])) {
                try {
                    object3 = (Map)object4;
                    object2 = object3.values();
                    if (!classArray[i].isInstance(object2)) {
                        try {
                            object = (Collection)classArray[i].newInstance();
                            object.addAll(object2);
                            object2 = object;
                        }
                        catch (Exception exception) {
                            try {
                                object2 = new ArrayList(object2);
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                    }
                    objectArray2[i] = object2;
                    continue;
                }
                catch (Exception exception) {
                    throw new JavaBridgeIllegalArgumentException("Could not create Collection from Map: " + JavaBridge.firstChars(object4), exception);
                }
            }
            if ((class$java$util$Hashtable == null ? JavaBridge.class$("java.util.Hashtable") : class$java$util$Hashtable).isAssignableFrom(classArray[i])) {
                try {
                    object3 = (Map)object4;
                    object2 = (Hashtable)classArray[i].newInstance();
                    ((Hashtable)object2).putAll(object3);
                    objectArray2[i] = object2;
                    continue;
                }
                catch (Exception exception) {
                    this.logError("Could not create Hashtable from Map: " + JavaBridge.objectDebugDescription(object4) + ". Cause: " + exception);
                    throw new JavaBridgeIllegalArgumentException("Could not create Hashtable from Map: " + JavaBridge.firstChars(object4), exception);
                }
            }
            if ((class$java$util$Map == null ? JavaBridge.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(classArray[i])) {
                objectArray2[i] = object4;
                continue;
            }
            if (!(object4 instanceof PhpString)) continue;
            objectArray2[i] = ((PhpString)object4).getString();
        }
        return objectArray2;
    }

    private static ClassIterator getClassClassIterator(Class clazz) {
        if (clazz == Class.class) {
            return new MetaClassIterator();
        }
        return new ClassClassIterator();
    }

    private static void logInvoke(Object object, String string, Object[] objectArray) {
        String string2 = "\nInvoking " + JavaBridge.objectDebugDescription(object) + "." + string + "(";
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                string2 = string2 + ",";
            }
            string2 = string2 + JavaBridge.objectDebugDescription(objectArray[i]);
        }
        string2 = string2 + ");\n";
        Util.logDebug(string2);
    }

    private static void logResult(Object object) {
        String string = "\nResult " + JavaBridge.objectDebugDescription(object) + "\n";
        Util.logDebug(string);
    }

    public void Invoke(Object object, String string, Object[] objectArray, Response response) throws NullPointerException {
        Object[] objectArray2 = null;
        Class[] classArray = null;
        LinkedList<Method> linkedList = new LinkedList<Method>();
        LinkedList<Method> linkedList2 = new LinkedList<Method>();
        Method method = null;
        boolean bl = true;
        try {
            Object object2;
            boolean bl2;
            if (object == null) {
                object = Request.PHPNULL;
                throw new NullPointerException("cannot call \"" + string + "()\" on a Java null object. A previous Java call has returned a null value, use java_is_null($jvalue) to check.");
            }
            MethodCache.Entry entry = this.methodCache.getEntry(string, object, objectArray);
            method = this.methodCache.get(entry);
            do {
                bl2 = false;
                if (method == null) {
                    Class clazz;
                    object2 = ClassIterator.getInstance(object, FindMatchingInterfaceForInvoke.getInstance(this, string, objectArray, true, this.canModifySecurityPermission));
                    while ((clazz = ((ClassIterator)object2).getNext()) != null) {
                        Method[] methodArray = clazz.getMethods();
                        for (int i = 0; i < methodArray.length; ++i) {
                            Method method2 = methodArray[i];
                            if (!method2.getName().equalsIgnoreCase(string) || !((ClassIterator)object2).isVisible(method2.getModifiers())) continue;
                            linkedList.add(method2);
                            if (method2.getParameterTypes().length != objectArray.length) continue;
                            linkedList2.add(method2);
                        }
                    }
                    method = (Method)this.select(linkedList2, objectArray);
                    if (method == null) {
                        this.checkM(object, String.valueOf(string) + "(" + Util.argsToString(objectArray, classArray) + "). " + "Candidates: " + String.valueOf(linkedList));
                    }
                    this.methodCache.put(entry, method);
                    if (!((ClassIterator)object2).checkAccessible(method)) {
                        this.logDebug("Security restriction: Cannot use setAccessible(), reverting to interface searching.");
                        this.canModifySecurityPermission = false;
                        linkedList.clear();
                        linkedList2.clear();
                        bl2 = true;
                    }
                }
                classArray = entry.getParameterTypes(method);
                objectArray2 = this.coerce(classArray, objectArray, response);
            } while (bl2);
            boolean bl3 = bl = method.getExceptionTypes().length != 0;
            if (this.logLevel > 4) {
                JavaBridge.logInvoke(object, string, objectArray2);
                object2 = method.invoke(object, objectArray2);
                JavaBridge.logResult(object2);
                response.setResult(object2, method.getReturnType(), bl);
            } else {
                response.setResult(method.invoke(object, objectArray2), method.getReturnType(), bl);
            }
        }
        catch (Throwable throwable) {
            Exception exception;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable2).getTargetException();
            }
            if (throwable2 instanceof Request.AbortException) {
                throw (Request.AbortException)throwable2;
            }
            if (throwable2 instanceof OutOfMemoryError) {
                Util.logFatal("OutOfMemoryError");
                throw (OutOfMemoryError)throwable2;
            }
            if (throwable2 instanceof NoClassDefFoundError) {
                this.getClassLoader().reset();
                exception = this.getUnresolvedExternalReferenceException(throwable2, "call the method");
            }
            if (method != null && throwable2 instanceof IllegalArgumentException && this.logLevel > 3) {
                int n;
                String string2 = "\nInvoked " + string + " on " + JavaBridge.objectDebugDescription(object) + "\n";
                string2 = string2 + " Expected Arguments for this Method:\n";
                Class<?>[] classArray2 = method.getParameterTypes();
                for (n = 0; n < classArray2.length; ++n) {
                    string2 = string2 + "   (" + n + ") " + JavaBridge.classDebugDescription(classArray2[n]) + "\n";
                }
                string2 = string2 + " Plain Arguments for this Method:\n";
                for (n = 0; n < objectArray.length; ++n) {
                    string2 = string2 + "   (" + n + ") " + JavaBridge.objectDebugDescription(objectArray[n]) + "\n";
                }
                if (objectArray2 != null) {
                    string2 = string2 + " Coerced Arguments for this Method:\n";
                    for (n = 0; n < objectArray2.length; ++n) {
                        string2 = string2 + "   (" + n + ") " + JavaBridge.objectDebugDescription(objectArray2[n]) + "\n";
                    }
                }
                this.logDebug(string2);
            }
            this.setException(response, exception, "Invoke", object, string, objectArray, classArray, bl);
        }
    }

    private void checkM(Object object, String string) throws NoSuchMethodException {
        if (object instanceof Class) {
            throw new NoSuchProcedureException(string);
        }
        throw new NoSuchMethodException(string);
    }

    private static String firstChars(Object object) {
        String string = "";
        String string2 = object instanceof Proxy ? object.getClass().getName() : String.valueOf(object);
        int n = string2.length();
        if (n > 80) {
            string = "...";
            n = 80;
        }
        string2 = string2.substring(0, n) + string;
        return string2;
    }

    public static String objectDebugDescription(Object object) {
        return JavaBridge.objectDebugDescription(object, 0);
    }

    private static String objectDebugDescription(Object objectArray, int n) {
        if (objectArray == null) {
            return "[Object null]";
        }
        Object[] objectArray2 = objectArray;
        if (objectArray2 instanceof Collection) {
            objectArray2 = ((Collection)objectArray2).toArray();
        } else if (objectArray2 instanceof List) {
            objectArray2 = ((List)objectArray2).toArray();
        } else if (objectArray2 instanceof Map) {
            objectArray2 = ((Map)objectArray2).values().toArray();
        }
        if (n < 10 && objectArray2.getClass().isArray()) {
            StringBuffer stringBuffer = new StringBuffer("[Object " + System.identityHashCode(objectArray) + " - Class: " + JavaBridge.classDebugDescription(objectArray.getClass()) + "]: ");
            stringBuffer.append("{\n");
            int n2 = Array.getLength(objectArray2);
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(JavaBridge.objectDebugDescription(Array.get(objectArray2, i), n + 1));
                if (i >= 10) {
                    stringBuffer.append("...\n");
                    break;
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        return "[Object " + System.identityHashCode(objectArray2) + " - Class: " + JavaBridge.classDebugDescription(objectArray2.getClass()) + "]";
    }

    public static String classDebugDescription(Class clazz) {
        return clazz.getName() + ":ID" + System.identityHashCode(clazz) + ":LOADER-ID" + System.identityHashCode(clazz.getClassLoader());
    }

    public void GetSetProp(Object object, String string, Object[] objectArray, Response response) throws NullPointerException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        boolean bl = objectArray != null && objectArray.length > 0;
        Class[] classArray = null;
        boolean bl2 = true;
        try {
            Object object2;
            Object object3;
            Object object4;
            Class clazz;
            if (object == null) {
                object = Request.PHPNULL;
                throw new NullPointerException("cannot get property \"" + string + "\" from a Java null object. A previous Java call has returned a null value, use java_is_null($jvalue) to check");
            }
            ClassIterator classIterator = ClassIterator.getInstance(object, FindMatchingInterfaceForGetSetProp.getInstance(this, string, objectArray, false, this.canModifySecurityPermission));
            block8: while ((clazz = classIterator.getNext()) != null) {
                try {
                    object4 = clazz.getFields();
                    for (int i = 0; i < ((Field[])object4).length; ++i) {
                        object3 = object4[i];
                        if (!((Field)object3).getName().equals(string) || !classIterator.isVisible(((Field)object3).getModifiers())) continue;
                        linkedList.add(((Field)object3).getName());
                        object2 = null;
                        if (!classIterator.checkAccessible((AccessibleObject)object3)) {
                            this.logDebug("Security restriction: Cannot use setAccessible(), reverting to interface searching.");
                            this.canModifySecurityPermission = false;
                            linkedList.clear();
                            break block8;
                        }
                        Class<?> clazz2 = ((Field)object3).getType();
                        if (bl) {
                            classArray = new Class[]{clazz2};
                            objectArray = this.coerce(classArray, objectArray, response);
                            ((Field)object3).set(object, objectArray[0]);
                        } else {
                            object2 = ((Field)object3).get(object);
                        }
                        response.setResult(object2, clazz2, false);
                        return;
                    }
                }
                catch (Exception exception) {
                }
            }
            linkedList.clear();
            classIterator = ClassIterator.getInstance(object, FindMatchingInterfaceForInvoke.getInstance(this, string, objectArray, true, this.canModifySecurityPermission));
            block10: while ((clazz = classIterator.getNext()) != null) {
                try {
                    object4 = Introspector.getBeanInfo(clazz);
                    PropertyDescriptor[] propertyDescriptorArray = object4.getPropertyDescriptors();
                    for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                        if (!propertyDescriptorArray[i].getName().equalsIgnoreCase(string)) continue;
                        if (bl) {
                            object2 = propertyDescriptorArray[i].getWriteMethod();
                            classArray = ((Method)object2).getParameterTypes();
                            objectArray = this.coerce(classArray, objectArray, response);
                        } else {
                            object2 = propertyDescriptorArray[i].getReadMethod();
                        }
                        linkedList.add(object2);
                        if (!classIterator.checkAccessible((AccessibleObject)object2)) {
                            this.logDebug("Security restriction: Cannot use setAccessible(), reverting to interface searching.");
                            this.canModifySecurityPermission = false;
                            linkedList.clear();
                            break block10;
                        }
                        bl2 = ((Method)object2).getExceptionTypes().length != 0;
                        response.setResult(((Method)object2).invoke(object, objectArray), ((Method)object2).getReturnType(), bl2);
                        return;
                    }
                }
                catch (Exception exception) {
                }
            }
            linkedList.clear();
            classIterator = ClassIterator.getInstance(object, FindMatchingInterfaceForGetSetProp.getInstance(this, string, objectArray, true, this.canModifySecurityPermission));
            block12: while ((clazz = classIterator.getNext()) != null) {
                try {
                    object4 = clazz.getFields();
                    for (int i = 0; i < ((Object)object4).length; ++i) {
                        object3 = object4[i];
                        if (!((Field)object3).getName().equalsIgnoreCase(string) || !classIterator.isVisible(((Field)object3).getModifiers())) continue;
                        linkedList.add(string);
                        object2 = null;
                        if (!classIterator.checkAccessible((AccessibleObject)object3)) {
                            this.logDebug("Security restriction: Cannot use setAccessible(), reverting to interface searching.");
                            this.canModifySecurityPermission = false;
                            linkedList.clear();
                            break block12;
                        }
                        Class<?> clazz3 = ((Field)object3).getType();
                        if (bl) {
                            classArray = new Class[]{clazz3};
                            objectArray = this.coerce(classArray, objectArray, response);
                            ((Field)object3).set(object, objectArray[0]);
                        } else {
                            object2 = ((Field)object3).get(object);
                        }
                        response.setResult(object2, clazz3, false);
                        return;
                    }
                }
                catch (Exception exception) {
                }
            }
            this.checkF(object, String.valueOf(string) + " (with args:" + Util.argsToString(objectArray, classArray) + "). " + "Candidates: " + String.valueOf(linkedList));
        }
        catch (Throwable throwable) {
            Exception exception;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable2).getTargetException();
            }
            if (throwable2 instanceof Request.AbortException) {
                throw (Request.AbortException)throwable2;
            }
            if (throwable2 instanceof OutOfMemoryError) {
                Util.logFatal("OutOfMemoryError");
                throw (OutOfMemoryError)throwable2;
            }
            if (throwable2 instanceof NoClassDefFoundError) {
                this.getClassLoader().reset();
                exception = this.getUnresolvedExternalReferenceException(throwable2, "invoke a property");
            }
            this.setException(response, exception, bl ? "SetProperty" : "GetProperty", object, string, objectArray, classArray, bl2);
        }
    }

    private void checkF(Object object, String string) throws NoSuchFieldException {
        if (object instanceof Class) {
            throw new NoSuchConstantException(string);
        }
        throw new NoSuchFieldException(string);
    }

    public Object getValues(Object object) {
        Response response = this.request.response;
        response.setArrayValuesWriter();
        return object;
    }

    public long unwrapClosure(Object object) throws IllegalArgumentException {
        return PhpProcedure.unwrap(this.castToExact(object));
    }

    public Object cast(Object object, Class clazz) {
        Response response = this.request.response;
        response.setCoerceWriter().setType(clazz);
        return object;
    }

    public Object castToString(Object object) {
        return this.cast(object, String.class);
    }

    public Object castToString(Exception exception, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Util.appendObject(exception, stringBuffer);
        Util.appendTrace(exception, string, stringBuffer);
        return this.castToString(stringBuffer);
    }

    public Object castToExact(Object object) {
        return this.cast(object, Long.TYPE);
    }

    public Object castToBoolean(Object object) {
        return this.cast(object, Boolean.TYPE);
    }

    public Object castToInexact(Object object) {
        return this.cast(object, Double.TYPE);
    }

    public Object castToArray(Object object) {
        Response response = this.request.response;
        response.setArrayValueWriter();
        return object;
    }

    public JavaBridge(IJavaBridgeFactory iJavaBridgeFactory) {
        this.setFactory(iJavaBridgeFactory);
    }

    public PhpMap getPhpMap(Object object) {
        return PhpMap.getPhpMap(object, this);
    }

    public void updateJarLibraryPath(String string, String string2) throws IOException {
        this.updateJarLibraryPath(string, string2, null, null);
    }

    public void updateJarLibraryPath(String string, String string2, String string3, String string4) throws IOException {
        this.getClassLoader().updateJarLibraryPath(string, string2.intern(), string3, string4);
    }

    public void updateLibraryPath(String string, String string2) throws Exception {
        this.updateLibraryPath(string, string2, null, null);
    }

    public void updateLibraryPath(String string, String string2, String string3, String string4) throws IOException {
        if (string == null || string.length() < 2) {
            return;
        }
        String string5 = new File(string2, "lib").getAbsolutePath();
        char c = string.charAt(0);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c != '.' || c != '/') {
            string = ";" + string;
        }
        String string6 = string.substring(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string6, string.substring(0, 1));
        while (stringTokenizer.hasMoreTokens()) {
            String string7 = stringTokenizer.nextToken();
            try {
                File file = null;
                StringBuffer stringBuffer = new StringBuffer();
                file = new File(string7);
                if (file.isFile() || file.isAbsolute()) {
                    stringBuffer.append(string7);
                    Util.loadFileMethod.invoke((Object)Util.CLRAssembly, stringBuffer.toString());
                    continue;
                }
                file = new File(string5, string7);
                if (file.isFile()) {
                    stringBuffer.append(file.getAbsolutePath());
                    Util.loadFileMethod.invoke((Object)Util.CLRAssembly, stringBuffer.toString());
                    continue;
                }
                file = new File(Util.JAVABRIDGE_LIB, string7);
                if (file.isFile()) {
                    stringBuffer.append(file.getAbsolutePath());
                    Util.loadFileMethod.invoke((Object)Util.CLRAssembly, stringBuffer.toString());
                    continue;
                }
                file = JarLibraryPath.checkSearchPath(string7, string4);
                if (file != null) {
                    stringBuffer.append(file.getAbsolutePath());
                    Util.loadFileMethod.invoke((Object)Util.CLRAssembly, stringBuffer.toString());
                    continue;
                }
                if (string3 != null && (file = new File(string3, string7)).isFile()) {
                    stringBuffer.append(file.getAbsolutePath());
                    Util.loadFileMethod.invoke((Object)Util.CLRAssembly, stringBuffer.toString());
                    continue;
                }
                stringBuffer.append(string7);
                Util.loadMethod.invoke((Object)Util.CLRAssembly, stringBuffer.toString());
            }
            catch (Exception exception) {
                this.logError("Could not load cli." + string7 + ".");
            }
        }
    }

    public String inspect(Object object) {
        int n;
        AnnotatedElement[] annotatedElementArray;
        Class clazz;
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(String.valueOf(Util.getClass(object)));
        stringBuffer.append(":\nConstructors:\n");
        ClassIterator classIterator = ClassIterator.getInstance(object, MATCH_VOID_CASE);
        while ((clazz = classIterator.getNext()) != null) {
            annotatedElementArray = clazz.getConstructors();
            for (n = 0; n < annotatedElementArray.length; ++n) {
                stringBuffer.append(String.valueOf(annotatedElementArray[n]));
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("\nFields:\n");
        classIterator = ClassIterator.getInstance(object, MATCH_VOID_CASE);
        while ((clazz = classIterator.getNext()) != null) {
            annotatedElementArray = clazz.getFields();
            for (n = 0; n < annotatedElementArray.length; ++n) {
                stringBuffer.append(String.valueOf(annotatedElementArray[n]));
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("\nMethods:\n");
        classIterator = ClassIterator.getInstance(object, MATCH_VOID_CASE);
        while ((clazz = classIterator.getNext()) != null) {
            annotatedElementArray = clazz.getMethods();
            for (n = 0; n < annotatedElementArray.length; ++n) {
                stringBuffer.append(String.valueOf(annotatedElementArray[n]));
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("\nClasses:\n");
        classIterator = ClassIterator.getInstance(object, MATCH_VOID_CASE);
        while ((clazz = classIterator.getNext()) != null) {
            annotatedElementArray = clazz.getClasses();
            for (n = 0; n < annotatedElementArray.length; ++n) {
                stringBuffer.append(String.valueOf(((Class)annotatedElementArray[n]).getName()));
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("]");
        return (String)this.castToString(stringBuffer.toString());
    }

    public void setFileEncoding(String string) {
        this.options.setEncoding(string.intern());
    }

    public boolean InstanceOf(Object object, Object object2) {
        Class clazz = Util.getClass(object2);
        return clazz.isInstance(this.castToBoolean(object));
    }

    public String ObjectToString(Object object) {
        if (object == null && !this.options.preferValues()) {
            object = Request.PHPNULL;
        }
        return (String)this.castToString(Util.stringValueOf(object));
    }

    public String ObjectToString(Boolean bl) {
        if (bl == null) {
            return this.ObjectToString((Object)null);
        }
        return (String)this.castToString(bl != false ? "1" : "");
    }

    public String ObjectToString(String string) {
        if (string == null) {
            return this.ObjectToString((Object)null);
        }
        return (String)this.castToString(string);
    }

    public String ObjectToString(byte[] byArray) {
        if (byArray == null) {
            return this.ObjectToString((Object)null);
        }
        try {
            return new String((byte[])this.castToString(byArray), this.options.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String((byte[])this.castToString(byArray));
        }
    }

    public String ObjectToString(Throwable throwable, String string) {
        StringBuffer stringBuffer = new StringBuffer("[");
        try {
            Util.appendObject(throwable, stringBuffer);
            Util.appendTrace(throwable, string, stringBuffer);
        }
        catch (Request.AbortException abortException) {
            throw abortException;
        }
        catch (Exception exception) {
            Util.printStackTrace(exception);
            stringBuffer.append("[Exception in toString(): ");
            stringBuffer.append(exception);
            if (exception.getCause() != null) {
                stringBuffer.append(", Cause: ");
                stringBuffer.append(exception.getCause());
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        return (String)this.castToString(stringBuffer.toString());
    }

    public Object getContext() {
        if (this.contextCache != null) {
            return this.contextCache;
        }
        this.contextCache = this.sessionFactory.getContext();
        return this.contextCache;
    }

    public ISession getSession(String string, boolean bl, int n) throws Exception {
        if (n == 0) {
            n = -1;
        }
        if (this.sessionCache != null) {
            return this.sessionCache;
        }
        try {
            ISession iSession = this.sessionFactory.getSession(string, bl, n);
            if (iSession == null) {
                throw new NullPointerException("session is null");
            }
            this.sessionCache = iSession;
            return this.sessionCache;
        }
        catch (Exception exception) {
            this.printStackTrace(exception);
            throw exception;
        }
    }

    public Object makeClosure(long l, Map map) {
        if (map == null) {
            return this.makeClosure(l);
        }
        return PhpProcedure.createProxy(this.getFactory(), null, map, Util.ZERO_PARAM, l);
    }

    public Object makeClosure(long l, Map map, Class[] classArray) {
        if (map == null) {
            map = emptyMap;
        }
        return PhpProcedure.createProxy(this.getFactory(), null, map, classArray, l);
    }

    public Object makeClosure(long l, String string, Class clazz) {
        Class[] classArray;
        if (clazz == null) {
            classArray = null;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz;
        }
        Class[] classArray3 = classArray;
        return this.makeClosure(l, string, classArray3);
    }

    public Object makeClosure(long l, Map map, Class clazz) {
        Class[] classArray;
        if (clazz == null) {
            classArray = null;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz;
        }
        Class[] classArray3 = classArray;
        return this.makeClosure(l, map, classArray3);
    }

    public Object makeClosure(long l, String string) {
        if (string == null) {
            return this.makeClosure(l);
        }
        return PhpProcedure.createProxy(this.getFactory(), string, null, Util.ZERO_PARAM, l);
    }

    public Object makeClosure(long l, String string, Class[] classArray) {
        if (string == null) {
            return this.makeClosure(l, (Map)emptyMap, classArray);
        }
        return PhpProcedure.createProxy(this.getFactory(), string, null, classArray, l);
    }

    public Object makeClosure(long l) {
        return PhpProcedure.createProxy(this.getFactory(), null, emptyMap, Util.ZERO_PARAM, l);
    }

    public void reset() {
        if (this.logLevel > 3) {
            this.warn("Your PHP script has called the privileged procedure \"reset()\", which resets the backend to its initial state. Therefore all session variables and all caches are now gone.");
        }
        this.getClassLoader().reset();
    }

    void setFactory(IJavaBridgeFactory iJavaBridgeFactory) {
        this.sessionFactory = iJavaBridgeFactory;
    }

    public int deserialize(String string, int n) throws IllegalArgumentException {
        ISession iSession = this.sessionFactory.getSession(INTERNAL_PHPSESSION, false, n);
        Object object = iSession.get(string);
        if (object == null) {
            throw new IllegalArgumentException("Session serialID " + string + " expired.");
        }
        return this.globalRef.append(this.castToExact(object));
    }

    private static synchronized int getSerialID() {
        return counter++;
    }

    public String serialize(Object object, int n) throws IllegalArgumentException {
        if (object == null) {
            object = Request.PHPNULL;
        }
        ISession iSession = this.sessionFactory.getSession(INTERNAL_PHPSESSION, false, n);
        String string = Integer.toHexString(JavaBridge.getSerialID());
        iSession.put(string, object);
        return (String)this.castToString(string);
    }

    public SimpleJavaBridgeClassLoader getClassLoader() {
        return this.getFactory().getJavaBridgeClassLoader();
    }

    private boolean offsetExists(Map map, Object object) {
        this.castToBoolean(null);
        return map.containsKey(object);
    }

    private Object offsetGet(Map map, Object object) {
        return map.get(object);
    }

    private void offsetSet(Map map, Object object, Object object2) {
        Class<?> clazz = map.getClass().getComponentType();
        if (clazz != null) {
            object2 = this.coerce(clazz, object2, this.request.response);
        }
        if (object == null) {
            object = new Integer(map.size());
        }
        map.put(object, object2);
    }

    private void offsetUnset(Map map, Object object) {
        map.remove(object);
    }

    private boolean offsetExists(List list, int n) {
        this.castToBoolean(null);
        try {
            this.offsetGet(list, n);
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    private Object offsetGet(List list, int n) {
        return list.get(n);
    }

    private void offsetSet(List list, Number number, Object object) {
        if (number == null) {
            list.add(object);
        } else {
            int n = number.intValue();
            list.set(n, object);
        }
    }

    private void offsetUnset(List list, int n) {
        list.remove(n);
    }

    boolean offsetExists(int n, int n2) {
        this.castToBoolean(null);
        int n3 = n2;
        return n3 > 0 && n3 < n;
    }

    private boolean offsetExists(Object object, int n) {
        return this.offsetExists(Array.getLength(object), n);
    }

    public boolean offsetExists(Object object, Object object2) {
        if (object.getClass().isArray()) {
            return this.offsetExists(object, ((Number)object2).intValue());
        }
        if (object instanceof List) {
            return this.offsetExists((List)object, ((Number)object2).intValue());
        }
        return this.offsetExists((Map)object, object2);
    }

    private Object offsetGet(Object object, int n) {
        int n2 = n;
        Object object2 = Array.get(object, n2);
        return object2 == this ? null : object2;
    }

    public Object offsetGet(Object object, Object object2) {
        if (object.getClass().isArray()) {
            return this.offsetGet(object, ((Number)object2).intValue());
        }
        if (object instanceof List) {
            return this.offsetGet((List)object, ((Number)object2).intValue());
        }
        return this.offsetGet((Map)object, object2);
    }

    public void beginDocument() {
        Response response = this.request.response;
        response.setObjectWriter();
        this.lastAsyncException = null;
    }

    public void endDocument() throws Throwable {
        Response response = this.request.response;
        response.setDefaultWriter();
        if (this.lastAsyncException != null) {
            throw this.lastAsyncException;
        }
    }

    private void offsetSet(Object object, int n, Object object2) {
        Array.set(object, n, this.coerce(object.getClass().getComponentType(), object2, this.request.response));
    }

    public void offsetSet(Object object, Object object2, Object object3) {
        if (object.getClass().isArray()) {
            this.offsetSet(object, ((Number)object2).intValue(), object3);
        } else if (object instanceof List) {
            this.offsetSet((List)object, (Number)object2, object3);
        } else {
            this.offsetSet((Map)object, object2, object3);
        }
    }

    private void offsetUnset(Object object, int n) {
        int n2 = n;
        Array.set(object, n2, null);
    }

    public void offsetUnset(Object object, Object object2) {
        if (object.getClass().isArray()) {
            this.offsetUnset(object, ((Number)object2).intValue());
        } else if (object instanceof List) {
            this.offsetUnset((List)object, ((Number)object2).intValue());
        } else {
            this.offsetUnset((Map)object, object2);
        }
    }

    public void recycle() {
        this.contextCache = null;
        this.sessionCache = null;
        this.globalRef = new GlobalRef();
        this.options.recycle();
        this.request.recycle();
        this.sessionFactory.recycle();
        this.methodCache.clear();
        this.constructorCache.clear();
        this.stringCache.clear();
        this.lastAsyncException = null;
        this.lastException = null;
    }

    public String getString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, this.options.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.printStackTrace(unsupportedEncodingException);
            return new String(byArray, n, n2);
        }
    }

    public String getCachedString(byte[] byArray, int n, int n2) {
        return this.stringCache.getString(byArray, n, n2, this.options.getEncoding());
    }

    Response createResponse() {
        return new Response(this);
    }

    public boolean typeExists(String string) {
        try {
            this.getClassLoader().forName(string);
            this.castToBoolean(null);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.castToBoolean(null);
            return false;
        }
    }

    public Throwable getLastException() {
        this.request.response.setCoerceWriter().setType(Object.class);
        if (this.lastAsyncException != null) {
            return this.lastAsyncException;
        }
        return this.lastException;
    }

    protected Throwable setLastAsyncException(Throwable throwable) {
        if (this.lastAsyncException == null) {
            this.lastException = this.lastAsyncException = throwable;
        }
        return throwable;
    }

    public void clearLastException() {
        this.lastAsyncException = null;
        this.lastException = null;
    }

    static class MetaClassIterator
    extends ClassIterator {
        MetaClassIterator() {
        }

        private Class next() {
            if (this.current == null) {
                this.current = (Class)this.object;
                return this.current;
            }
            return null;
        }

        public Class getNext() {
            return this.next();
        }

        public boolean checkAccessible(AccessibleObject accessibleObject) {
            return true;
        }

        public boolean isVisible(int n) {
            return true;
        }
    }

    static class ClassClassIterator
    extends ClassIterator {
        boolean hasNext = false;

        ClassClassIterator() {
        }

        private Class next() {
            if (this.current == null) {
                this.hasNext = true;
                this.current = (Class)this.object;
                return this.current;
            }
            if (this.hasNext) {
                this.hasNext = false;
                return this.object.getClass();
            }
            return null;
        }

        public Class getNext() {
            return this.next();
        }

        public boolean checkAccessible(AccessibleObject accessibleObject) {
            return true;
        }

        public boolean isVisible(int n) {
            return !this.hasNext || (n & 8) != 0;
        }
    }

    static class ObjectClassIterator
    extends ClassIterator {
        ObjectClassIterator() {
        }

        private Class next() {
            if (this.current == null) {
                this.current = this.object.getClass();
                return this.current;
            }
            return null;
        }

        public Class getNext() {
            return this.match.findMatchingInterface(this.next());
        }

        public boolean checkAccessible(AccessibleObject accessibleObject) {
            return this.match.checkAccessible(accessibleObject);
        }

        public boolean isVisible(int n) {
            return true;
        }
    }

    private static abstract class ClassIterator {
        Object object;
        Class current;
        FindMatchingInterface match;

        private ClassIterator() {
        }

        public static ClassIterator getInstance(Object object, FindMatchingInterface findMatchingInterface) {
            ClassIterator classIterator = object instanceof Class ? JavaBridge.getClassClassIterator((Class)object) : new ObjectClassIterator();
            classIterator.match = findMatchingInterface;
            classIterator.object = object;
            classIterator.current = null;
            return classIterator;
        }

        public abstract Class getNext();

        public abstract boolean checkAccessible(AccessibleObject var1);

        public abstract boolean isVisible(int var1);
    }

    static class FindMatchingInterfaceForGetSetProp
    extends FindMatchingInterface {
        protected FindMatchingInterfaceForGetSetProp(JavaBridge javaBridge, String string, Object[] objectArray, boolean bl) {
            super(javaBridge, string, objectArray, bl);
        }

        public static FindMatchingInterface getInstance(JavaBridge javaBridge, String string, Object[] objectArray, boolean bl, boolean bl2) {
            if (bl2) {
                return bl ? MATCH_VOID_ICASE : MATCH_VOID_CASE;
            }
            return new FindMatchingInterfaceForGetSetProp(javaBridge, string, objectArray, bl);
        }

        Class findMatchingInterface(Class clazz) {
            if (clazz == null) {
                return clazz;
            }
            if (this.bridge.logLevel > 3 && this.bridge.logLevel > 3) {
                this.bridge.logDebug("searching for matching interface for GetSetProp for class " + clazz);
            }
            while (!Modifier.isPublic(clazz.getModifiers())) {
                Class<?>[] classArray = clazz.getInterfaces();
                Class clazz2 = clazz.getSuperclass();
                int n = classArray.length;
                while (n-- > 0) {
                    if (!Modifier.isPublic(classArray[n].getModifiers())) continue;
                    clazz = classArray[n];
                    Field[] fieldArray = clazz.getFields();
                    for (int i = 0; i < fieldArray.length; ++i) {
                        boolean bl;
                        String string = fieldArray[i].getName();
                        boolean bl2 = bl = this.ignoreCase ? string.equalsIgnoreCase(this.name) : string.equals(this.name);
                        if (!bl) continue;
                        if (this.bridge.logLevel > 3) {
                            this.bridge.logDebug("matching interface for GetSetProp: " + clazz);
                        }
                        return clazz;
                    }
                }
                clazz = clazz2;
            }
            if (this.bridge.logLevel > 3) {
                this.bridge.logDebug("interface for GetSetProp: " + clazz);
            }
            return clazz;
        }
    }

    static class FindMatchingInterfaceForInvoke
    extends FindMatchingInterface {
        protected FindMatchingInterfaceForInvoke(JavaBridge javaBridge, String string, Object[] objectArray, boolean bl) {
            super(javaBridge, string, objectArray, bl);
        }

        public static FindMatchingInterface getInstance(JavaBridge javaBridge, String string, Object[] objectArray, boolean bl, boolean bl2) {
            if (bl2) {
                return bl ? MATCH_VOID_ICASE : MATCH_VOID_CASE;
            }
            return new FindMatchingInterfaceForInvoke(javaBridge, string, objectArray, bl);
        }

        Class findMatchingInterface(Class clazz) {
            if (clazz == null) {
                return clazz;
            }
            if (this.bridge.logLevel > 3 && this.bridge.logLevel > 3) {
                this.bridge.logDebug("searching for matching interface for Invoke for class " + clazz);
            }
            while (!Modifier.isPublic(clazz.getModifiers())) {
                Class<?>[] classArray = clazz.getInterfaces();
                Class clazz2 = clazz.getSuperclass();
                int n = classArray.length;
                while (n-- > 0) {
                    if (!Modifier.isPublic(classArray[n].getModifiers())) continue;
                    clazz = classArray[n];
                    Method[] methodArray = clazz.getMethods();
                    for (int i = 0; i < methodArray.length; ++i) {
                        boolean bl;
                        String string = methodArray[i].getName();
                        boolean bl2 = bl = this.ignoreCase ? string.equalsIgnoreCase(this.name) : string.equals(this.name);
                        if (!bl || methodArray[i].getParameterTypes().length != this.args.length) continue;
                        if (this.bridge.logLevel > 3) {
                            this.bridge.logDebug("matching interface for Invoke: " + clazz);
                        }
                        return clazz;
                    }
                }
                clazz = clazz2;
            }
            if (this.bridge.logLevel > 3) {
                this.bridge.logDebug("interface for Invoke: " + clazz);
            }
            return clazz;
        }
    }

    static class FindMatchingInterfaceVoid
    extends FindMatchingInterface {
        public FindMatchingInterfaceVoid(boolean bl) {
            super(null, null, null, bl);
        }

        Class findMatchingInterface(Class clazz) {
            return clazz;
        }

        public boolean checkAccessible(AccessibleObject accessibleObject) {
            if (!accessibleObject.isAccessible()) {
                try {
                    accessibleObject.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    return false;
                }
            }
            return true;
        }
    }

    static abstract class FindMatchingInterface {
        JavaBridge bridge;
        String name;
        Object[] args;
        boolean ignoreCase;

        public FindMatchingInterface(JavaBridge javaBridge, String string, Object[] objectArray, boolean bl) {
            this.bridge = javaBridge;
            this.name = string;
            this.args = objectArray;
            this.ignoreCase = bl;
        }

        abstract Class findMatchingInterface(Class var1);

        public boolean checkAccessible(AccessibleObject accessibleObject) {
            return true;
        }
    }
}

