/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import php.java.bridge.AppThreadPool;
import php.java.bridge.ChainsawLogger;
import php.java.bridge.FileLogger;
import php.java.bridge.ILogger;
import php.java.bridge.JavaBridgeClassLoader;
import php.java.bridge.NotImplementedException;
import php.java.bridge.Standalone;

public final class Util {
    static Method loadMethod;
    static Method loadFileMethod;
    static Class CLRAssembly;
    public static int MAX_WAIT;
    public static Class JAVA_INC;
    public static Class JAVA_PROXY;
    public static Class LAUNCHER_UNIX;
    public static Class LAUNCHER_WINDOWS;
    public static Class LAUNCHER_WINDOWS2;
    public static Class LAUNCHER_WINDOWS3;
    public static final byte[] HEX_DIGITS;
    public static String[] PHP_ARGS;
    private static final String DEFAULT_PHP_ARGS = "-d allow_url_include=On -d display_errors=Off -d log_errors=On -d java.persistent_servlet_connections=On";
    public static String[] DEFAULT_CGI_LOCATIONS;
    public static final HeaderParser DEFAULT_HEADER_PARSER;
    public static final String ASCII = "ASCII";
    public static final String UTF8 = "UTF-8";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int BUF_SIZE = 8192;
    public static Map COMMON_ENVIRONMENT;
    public static final String[] DEFAULT_EXT_DIRS;
    public static final boolean IS_GNU_JAVA;
    public static String EXTENSION_NAME;
    public static String THREAD_POOL_MAX_SIZE;
    public static int DEFAULT_LOG_LEVEL;
    public static final int BACKLOG = 20;
    public static final Object[] ZERO_ARG;
    public static final Class[] ZERO_PARAM;
    public static final byte[] RN;
    public static boolean USE_SHORT_PATH_S1;
    public static String VM_NAME;
    public static boolean JAVABRIDGE_PROMISCUOUS;
    public static String DEFAULT_LOG_FILE;
    private static boolean DEFAULT_LOG_FILE_SET;
    public static String JAVABRIDGE_BASE;
    public static String JAVABRIDGE_LIB;
    public static String VERSION;
    public static String osArch;
    public static String osName;
    public static boolean IS_MONO;
    public static String PHP_EXEC;
    public static File HOME_DIR;
    static PrintStream logStream;
    private static ThreadLocal logger;
    public static int logLevel;
    private static ILogger sharedLogger;

    private Util() {
    }

    private static String getProperty(Properties properties, String string, String string2) {
        String string3 = null;
        if (properties != null) {
            string3 = properties.getProperty(string);
        }
        if (string3 == null) {
            string3 = System.getProperty("php.java.bridge." + String.valueOf(string).toLowerCase());
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    private static void initGlobals() {
        Object object;
        Object object2;
        Serializable serializable;
        block51: {
            try {
                USE_SHORT_PATH_S1 = System.getProperty("php.java.bridge.no_short_path", "false").equals("false");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                JAVA_INC = Class.forName("php.java.bridge.JavaInc");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                JAVA_PROXY = Class.forName("php.java.bridge.JavaProxy");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LAUNCHER_UNIX = Class.forName("php.java.bridge.LauncherUnix");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LAUNCHER_WINDOWS = Class.forName("php.java.bridge.LauncherWindows");
                LAUNCHER_WINDOWS2 = Class.forName("php.java.bridge.LauncherWindows2");
                LAUNCHER_WINDOWS3 = Class.forName("php.java.bridge.LauncherWindows3");
            }
            catch (Exception exception) {
                // empty catch block
            }
            COMMON_ENVIRONMENT = Util.getCommonEnvironment();
            DEFAULT_CGI_LOCATIONS = new String[]{"/usr/bin/php-cgi", "c:/Program Files/PHP/php-cgi.exe"};
            try {
                if (new File(DEFAULT_CGI_LOCATIONS[0]).exists() || new File(DEFAULT_CGI_LOCATIONS[0]).exists()) break block51;
                try {
                    serializable = null;
                    boolean bl = false;
                    object2 = (String[])COMMON_ENVIRONMENT.get("PATH");
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object2, File.pathSeparator);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string = stringTokenizer.nextToken();
                        serializable = new File(string, "php-cgi.exe");
                        if (((File)serializable).exists()) {
                            bl = true;
                            break;
                        }
                        serializable = new File(string, "php-cgi");
                        if (!((File)serializable).exists()) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        serializable = new File("/usr/php/bin/php-cgi");
                        bl = ((File)serializable).exists();
                    }
                    if (bl) {
                        DEFAULT_CGI_LOCATIONS = new String[]{((File)serializable).getCanonicalPath(), DEFAULT_CGI_LOCATIONS[0], DEFAULT_CGI_LOCATIONS[1]};
                    }
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            MAX_WAIT = Integer.parseInt(System.getProperty("php.java.bridge.max_wait", "15000"));
        }
        catch (Exception exception) {
            MAX_WAIT = 15000;
        }
        try {
            HOME_DIR = new File(System.getProperty("user.home"));
        }
        catch (Exception exception) {
            HOME_DIR = null;
        }
        try {
            JAVABRIDGE_BASE = System.getProperty("php.java.bridge.base", System.getProperty("user.home"));
            JAVABRIDGE_LIB = JAVABRIDGE_BASE + File.separator + "lib";
        }
        catch (Exception exception) {
            JAVABRIDGE_BASE = ".";
            JAVABRIDGE_LIB = ".";
        }
        try {
            VM_NAME = "unknown";
            VM_NAME = System.getProperty("java.version") + "@" + System.getProperty("java.vendor.url");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JAVABRIDGE_PROMISCUOUS = false;
            JAVABRIDGE_PROMISCUOUS = System.getProperty("php.java.bridge.promiscuous", "false").toLowerCase().equals("true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_MONO = Standalone.checkMono();
        serializable = new Properties();
        try {
            object = Util.class.getResourceAsStream("global.properties");
            serializable.load((InputStream)object);
            VERSION = serializable.getProperty("BACKEND_VERSION");
        }
        catch (Throwable throwable) {
            VERSION = "unknown";
        }
        try {
            THREAD_POOL_MAX_SIZE = "20";
            THREAD_POOL_MAX_SIZE = Util.getProperty(serializable, "THREADS", "20");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            object = Util.getProperty(serializable, "PHP_EXEC_ARGS", DEFAULT_PHP_ARGS);
            object2 = ((String)object).split(" ");
            for (int i = 0; i < ((String[])object2).length; ++i) {
                try {
                    object2[i] = URLDecoder.decode(object2[i], "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            PHP_ARGS = object2;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            EXTENSION_NAME = "JavaBridge";
            EXTENSION_NAME = Util.getProperty(serializable, "EXTENSION_DISPLAY_NAME", "JavaBridge");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PHP_EXEC = Util.getProperty(serializable, "PHP_EXEC", null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            object = Util.getProperty(serializable, "DEFAULT_LOG_LEVEL", "3");
            logLevel = DEFAULT_LOG_LEVEL = Integer.parseInt((String)object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DEFAULT_LOG_FILE_SET = false;
            DEFAULT_LOG_FILE = Util.getProperty(serializable, "DEFAULT_LOG_FILE", EXTENSION_NAME + ".log");
            DEFAULT_LOG_FILE_SET = System.getProperty("php.java.bridge.default_log_file") != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = "/-+.,;: ";
        try {
            object2 = System.getProperty("os.arch").toLowerCase();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2, (String)object);
            osArch = stringTokenizer.nextToken();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (osArch == null) {
            osArch = "unknown";
        }
        try {
            object2 = System.getProperty("os.name").toLowerCase();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2, (String)object);
            osName = stringTokenizer.nextToken();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (osName == null) {
            osName = "unknown";
        }
    }

    public static void println(int n, String string) {
        Util.getLogger().log(n, string);
    }

    public static void warn(String string) {
        if (logLevel <= 0) {
            return;
        }
        Util.getLogger().warn(string);
    }

    public static void printStackTrace(Throwable throwable) {
        Util.getLogger().printStackTrace(throwable);
    }

    public static void logDebug(String string) {
        if (logLevel > 3) {
            Util.println(4, string);
        }
    }

    public static void logFatal(String string) {
        if (logLevel > 0) {
            Util.println(1, string);
        }
    }

    public static void logError(String string) {
        if (logLevel > 1) {
            Util.println(2, string);
        }
    }

    public static void logMessage(String string) {
        if (logLevel > 2) {
            Util.println(3, string);
        }
    }

    public static String getClassName(Object object) {
        if (object == null) {
            return "null";
        }
        Class clazz = Util.getClass(object);
        String string = clazz.getName();
        if (string.startsWith("[")) {
            string = "array_of_" + string.substring(1);
        }
        return string;
    }

    public static String getShortClassName(Object object) {
        String string = Util.getClassName(object);
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getShortName(Class clazz) {
        int n;
        String string = clazz.getName();
        if (string.startsWith("[")) {
            string = "array_of_" + string.substring(1);
        }
        if ((n = string.lastIndexOf(46)) != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static Class getClass(Object object) {
        if (object == null) {
            return null;
        }
        return object instanceof Class ? (Class<?>)object : object.getClass();
    }

    public static void appendObject(Object object, StringBuffer stringBuffer) {
        if (object == null) {
            stringBuffer.append("null");
            return;
        }
        if (object instanceof Class) {
            if (((Class)object).isInterface()) {
                stringBuffer.append("[i:");
            } else {
                stringBuffer.append("[c:");
            }
        } else {
            stringBuffer.append("[o:");
        }
        stringBuffer.append(Util.getShortClassName(object));
        stringBuffer.append("]:");
        stringBuffer.append("\"");
        stringBuffer.append(Util.stringValueOf(object));
        stringBuffer.append("\"");
    }

    public static void appendTrace(Throwable throwable, String string, StringBuffer stringBuffer) {
        stringBuffer.append(" at:\n");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("#-");
            stringBuffer.append(n - i);
            stringBuffer.append(" ");
            stringBuffer.append(stackTraceElementArray[i].toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append(string);
    }

    public static void appendShortObject(Object object, StringBuffer stringBuffer) {
        if (object == null) {
            stringBuffer.append("null");
            return;
        }
        if (object instanceof Class) {
            if (((Class)object).isInterface()) {
                stringBuffer.append("[i:");
            } else {
                stringBuffer.append("[c:");
            }
        } else {
            stringBuffer.append("[o:");
        }
        stringBuffer.append(Util.getShortClassName(object));
        stringBuffer.append("]");
    }

    public static void appendParam(Class clazz, StringBuffer stringBuffer) {
        if (clazz.isInterface()) {
            stringBuffer.append("(i:");
        } else if (clazz == Class.class) {
            stringBuffer.append("(c:");
        } else {
            stringBuffer.append("(o:");
        }
        stringBuffer.append(Util.getShortClassName(clazz));
        stringBuffer.append(")");
    }

    public static void appendParam(Object object, StringBuffer stringBuffer) {
        if (object instanceof Class) {
            Class clazz = (Class)object;
            if (clazz.isInterface()) {
                stringBuffer.append("(i:");
            } else {
                stringBuffer.append("(c:");
            }
        } else {
            stringBuffer.append("(o:");
        }
        stringBuffer.append(Util.getShortClassName(object));
        stringBuffer.append(")");
    }

    public static String argsToString(Object[] objectArray, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        Util.appendArgs(objectArray, classArray, stringBuffer);
        return stringBuffer.toString();
    }

    public static void appendArgs(Object[] objectArray, Class[] classArray, StringBuffer stringBuffer) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (classArray != null) {
                    Util.appendParam(classArray[i], stringBuffer);
                }
                Util.appendShortObject(objectArray[i], stringBuffer);
                if (i + 1 >= objectArray.length) continue;
                stringBuffer.append(", ");
            }
        }
    }

    public static byte[] toBytes(String string) {
        try {
            return string.getBytes(ASCII);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string.getBytes();
        }
    }

    public static String[] hashToStringArray(Map map) throws NullPointerException {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            objectArray = iterator.next().toString();
            vector.add((String)objectArray + "=" + map.get(objectArray));
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void parseBody(byte[] byArray, InputStream inputStream, OutputStreamFactory outputStreamFactory, HeaderParser headerParser) throws UnsupportedEncodingException, IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while ((n = inputStream.read(byArray, n2, byArray.length - n2)) != -1) {
            int n4 = n2 + n;
            while (!bl && n2 < n4) {
                switch (byArray[n2++]) {
                    case 10: {
                        if (n3 + 2 == n2 && byArray[n3] == 13) {
                            bl = true;
                            break;
                        }
                        headerParser.parseHeader(new String(byArray, n3, n2 - n3 - 2, ASCII));
                        n3 = n2;
                    }
                }
            }
            if (!bl) continue;
            if (n2 < n4) {
                outputStreamFactory.getOutputStream().write(byArray, n2, n4 - n2);
            }
            n2 = 0;
        }
    }

    public static synchronized void setDefaultFileLogger() {
        Util.setLogger(new Logger(new FileLogger()));
    }

    public static synchronized void setLogger(ILogger iLogger) {
        logger.set(iLogger);
    }

    public static synchronized ILogger getLogger() {
        if (!DEFAULT_LOG_FILE_SET) {
            Object t = logger.get();
            if (t != null) {
                return (ILogger)t;
            }
            Util.setDefaultFileLogger();
            return (ILogger)logger.get();
        }
        if (sharedLogger == null) {
            sharedLogger = new Logger(new FileLogger());
        }
        return sharedLogger;
    }

    public static String getHostAddress(boolean bl) {
        String string = "127.0.0.1";
        try {
            if (JAVABRIDGE_PROMISCUOUS || bl) {
                string = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string;
    }

    public static String[] checkCgiBinary(StringBuffer stringBuffer) {
        stringBuffer.append("-");
        stringBuffer.append(osArch);
        stringBuffer.append("-");
        stringBuffer.append(osName);
        File file = new File(stringBuffer.toString() + ".sh");
        if (logLevel > 3) {
            Util.logDebug("trying: " + file);
        }
        if (file.exists()) {
            return new String[]{"/bin/sh", file.getAbsolutePath()};
        }
        file = new File(stringBuffer.toString() + ".exe");
        if (logLevel > 3) {
            Util.logDebug("trying: " + file);
        }
        if (file.exists()) {
            return new String[]{file.getAbsolutePath()};
        }
        file = new File(stringBuffer.toString());
        if (logLevel > 3) {
            Util.logDebug("trying: " + file);
        }
        if (file.exists()) {
            return new String[]{file.getAbsolutePath()};
        }
        return null;
    }

    public static String checkError(String string) {
        return string.indexOf("PHP Fatal error:") > -1 || string.indexOf("PHP Parse error:") > -1 ? string : null;
    }

    public static ClassLoader getContextClassLoader() {
        return JavaBridgeClassLoader.getContextClassLoader();
    }

    static void redirectOutput(boolean bl, String string) {
        if (IS_MONO) {
            Util.redirectMonoOutput(bl, string);
        } else {
            Util.redirectJavaOutput(bl, string);
        }
    }

    static void redirectJavaOutput(boolean bl, String string) {
        logStream = System.err;
        if (!bl) {
            if (string != null && string.length() > 0) {
                try {
                    logStream = new PrintStream(new FileOutputStream(string));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            try {
                System.setErr(logStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            System.setOut(logStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(9);
        }
    }

    static void redirectMonoOutput(boolean bl, String string) {
        try {
            Object object;
            boolean bl2 = false;
            Class<?> clazz = Class.forName("cli.System.Console");
            Class<?> clazz2 = Class.forName("cli.System.IO.TextWriter");
            Class<?> clazz3 = Class.forName("cli.System.IO.StreamWriter");
            Method method = clazz.getMethod("get_Error", new Class[0]);
            Object object2 = method.invoke(clazz, new Object[0]);
            Method method2 = clazz.getMethod("SetOut", clazz2);
            if (!bl && string != null && string.length() > 0) {
                try {
                    object = clazz3.getConstructor(String.class);
                    Object obj = ((Constructor)object).newInstance(string);
                    Method method3 = clazz3.getMethod("set_AutoFlush", Boolean.TYPE);
                    method3.invoke(obj, Boolean.TRUE);
                    Method method4 = clazz.getMethod("SetError", clazz2);
                    Object[] objectArray = new Object[]{obj};
                    method2.invoke(clazz, objectArray);
                    method4.invoke(clazz, objectArray);
                    MonoOutputStream monoOutputStream = new MonoOutputStream(clazz3, obj);
                    logStream = new PrintStream(monoOutputStream, true);
                    System.setErr(logStream);
                    System.setOut(logStream);
                    bl2 = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!bl2) {
                try {
                    method2.invoke(clazz, object2);
                    object = new MonoOutputStream(clazz2, object2);
                    logStream = new PrintStream((OutputStream)object, true);
                    System.setErr(logStream);
                    System.setOut(logStream);
                    bl2 = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!bl2) {
                try {
                    System.setOut(System.err);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(9);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static HashMap getCommonEnvironment() {
        String[] stringArray = new String[]{"PATH", "LD_LIBRARY_PATH", "LD_ASSUME_KERNEL", "USER", "TMP", "TEMP", "HOME", "HOMEPATH", "LANG", "TZ", "OS"};
        HashMap<String, String> hashMap = new HashMap<String, String>(stringArray.length + 10);
        Method method = null;
        try {
            method = System.class.getMethod("getenv", String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = null;
            if (method != null) {
                try {
                    string = (String)method.invoke((Object)(class$java$lang$System == null ? Util.class$("java.lang.System") : class$java$lang$System), (Object[])new String[]{stringArray[i]});
                }
                catch (Exception exception) {
                    method = null;
                }
            }
            if (string == null) {
                try {
                    string = System.getProperty(stringArray[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string == null) continue;
            hashMap.put(stringArray[i], string);
        }
        return hashMap;
    }

    public static String stringValueOf(Object object) {
        String string = String.valueOf(object);
        if (string == null) {
            string = String.valueOf(string);
        }
        return string;
    }

    public static AppThreadPool createThreadPool(String string) {
        AppThreadPool appThreadPool = null;
        int n = 20;
        try {
            n = Integer.parseInt(THREAD_POOL_MAX_SIZE);
        }
        catch (Throwable throwable) {
            Util.printStackTrace(throwable);
        }
        if (n > 0) {
            appThreadPool = new AppThreadPool(string, n);
        }
        return appThreadPool;
    }

    public static boolean setConfiguredLogger(String string) {
        try {
            return Util.tryConfiguredChainsawLogger(string);
        }
        catch (Exception exception) {
            Util.printStackTrace(exception);
            Util.setLogger(new FileLogger());
            return true;
        }
    }

    private static boolean tryConfiguredChainsawLogger(String string) throws Exception {
        if (string != null && string.length() > 0 && string.charAt(0) == '@') {
            string = string.substring(1, string.length());
            int n = string.indexOf(58);
            int n2 = -1;
            String string2 = null;
            if (n != -1) {
                String string3 = string.substring(n + 1, string.length());
                if (string3.length() > 0) {
                    n2 = Integer.parseInt(string3);
                }
                string2 = string.substring(0, n);
            } else if (string.length() > 0) {
                string2 = string;
            }
            Util.setLogger(ConfiguredChainsawLogger.createLogger(string2, n2));
            return true;
        }
        return false;
    }

    public static String formatDateTime(long l) {
        Timestamp timestamp = new Timestamp(l);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 1, Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string = dateFormat.format(timestamp);
        return string;
    }

    public static void destroy() {
        logLevel = 0;
    }

    public static int getMBeanProperty(String string, String string2) {
        block3: {
            try {
                Class<?> clazz = Class.forName("javax.management.ObjectName");
                Constructor<?> constructor = clazz.getConstructor(String.class);
                Object object = constructor.newInstance(string);
                Class<?> clazz2 = Class.forName("javax.management.MBeanServerFactory");
                Method method = clazz2.getMethod("findMBeanServer", String.class);
                ArrayList arrayList = (ArrayList)method.invoke(clazz2, new Object[]{null});
                Object e = arrayList.get(0);
                Class<?> clazz3 = Class.forName("javax.management.MBeanServer");
                clazz2 = Class.forName("javax.management.QueryExp");
                method = clazz3.getMethod("queryMBeans", clazz, clazz2);
                Set set = (Set)method.invoke(e, object, null);
                Iterator iterator = set.iterator();
                if (iterator.hasNext()) {
                    clazz2 = Class.forName("javax.management.ObjectInstance");
                    method = clazz2.getMethod("getObjectName", ZERO_PARAM);
                    object = method.invoke(iterator.next(), ZERO_ARG);
                    method = clazz3.getMethod("getAttribute", clazz, String.class);
                    Object object2 = method.invoke(e, object, string2);
                    return Integer.parseInt(String.valueOf(object2));
                }
            }
            catch (Exception exception) {
                if (logLevel <= 5) break block3;
                Util.printStackTrace(exception);
            }
        }
        return 0;
    }

    static final boolean checkVM() {
        try {
            return "libgcj".equals(System.getProperty("gnu.classpath.vm.shortname"));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final String[] getPhpArgs(String[] stringArray) {
        return Util.getPhpArgs(stringArray, false);
    }

    public static final String[] getPhpArgs(String[] stringArray, boolean bl) {
        String[] stringArray2 = new String[stringArray.length + PHP_ARGS.length + (bl ? 1 : 0)];
        int n = 0;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n];
        }
        if (bl) {
            stringArray2[n++] = "-C";
        }
        for (int i = 0; i < PHP_ARGS.length; ++i) {
            stringArray2[n++] = PHP_ARGS[i];
        }
        return stringArray2;
    }

    static {
        Util.initGlobals();
        HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        DEFAULT_HEADER_PARSER = new SimpleHeaderParser();
        DEFAULT_EXT_DIRS = new String[]{"/usr/share/java/ext", "/usr/java/packages/lib/ext"};
        IS_GNU_JAVA = Util.checkVM();
        ZERO_ARG = new Object[0];
        ZERO_PARAM = new Class[0];
        RN = Util.toBytes("\r\n");
        logger = new ThreadLocal();
    }

    private static final class ConfiguredChainsawLogger
    extends ChainsawLogger {
        private String host;
        private int port;

        private ConfiguredChainsawLogger(String string, int n) {
            this.host = string;
            this.port = n;
        }

        public static ConfiguredChainsawLogger createLogger(String string, int n) throws Exception {
            ConfiguredChainsawLogger configuredChainsawLogger = new ConfiguredChainsawLogger(string, n);
            configuredChainsawLogger.init();
            return configuredChainsawLogger;
        }

        public void configure(String string, int n) throws Exception {
            string = this.host != null ? this.host : string;
            n = this.port > 0 ? this.port : n;
            super.configure(string, n);
        }
    }

    private static class MonoOutputStream
    extends OutputStream {
        Object streamWriter;
        private Method Write;
        private Method Close;
        private Method Flush;

        public MonoOutputStream(Class clazz, Object object) throws SecurityException, NoSuchMethodException {
            this.streamWriter = clazz;
            this.streamWriter = object;
            this.Write = clazz.getMethod("Write", class$java$lang$String == null ? (class$java$lang$String = Util.class$("java.lang.String")) : class$java$lang$String);
            this.Close = clazz.getMethod("Close", ZERO_PARAM);
            this.Flush = clazz.getMethod("Flush", ZERO_PARAM);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                String string = new String(byArray, n, n2);
                this.Write.invoke(this.streamWriter, string);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                throw iOException;
            }
        }

        public void write(int n) throws IOException {
            throw new NotImplementedException();
        }

        public void flush() throws IOException {
            try {
                this.Flush.invoke(this.streamWriter, ZERO_ARG);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                throw iOException;
            }
        }

        public void close() throws IOException {
            try {
                this.Close.invoke(this.streamWriter, ZERO_ARG);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                throw iOException;
            }
        }
    }

    public static class ProcessWithErrorHandler
    extends Process {
        StringBuffer error = null;
        InputStream in = null;
        OutputStream err = null;

        protected ProcessWithErrorHandler(String[] stringArray, File file, Map map, boolean bl, boolean bl2, OutputStream outputStream) throws IOException {
            super(stringArray, file, map, bl, bl2);
            this.err = outputStream;
        }

        protected void start() throws IOException {
            super.start();
            new Thread("CGIErrorReader"){

                public void run() {
                    ProcessWithErrorHandler.this.readErrorStream();
                }
            }.start();
        }

        public void checkError() throws Process.PhpException {
            String string;
            String string2 = string = this.error == null ? null : Util.checkError(this.error.toString());
            if (string != null) {
                throw new Process.PhpException(string);
            }
        }

        public void destroy() {
            this.proc.destroy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void readErrorStream() {
            byte[] byArray = new byte[8192];
            try {
                int n;
                this.in = this.proc.getErrorStream();
                while ((n = this.in.read(byArray)) != -1) {
                    this.err.write(byArray, 0, n);
                    String string = new String(byArray, 0, n, Util.ASCII);
                    if (logLevel > 4) {
                        Util.logError(string);
                    }
                    if (this.error == null) {
                        this.error = new StringBuffer(string);
                        continue;
                    }
                    this.error.append(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.notify();
            }
        }

        public synchronized int waitFor() throws InterruptedException {
            if (this.in == null) {
                this.wait();
            }
            return super.waitFor();
        }

        public static Process start(String[] stringArray, File file, Map map, boolean bl, boolean bl2, OutputStream outputStream) throws IOException {
            ProcessWithErrorHandler processWithErrorHandler = new ProcessWithErrorHandler(stringArray, file, map, bl, bl2, outputStream);
            ((Process)processWithErrorHandler).start();
            return processWithErrorHandler;
        }
    }

    public static class Process
    extends java.lang.Process {
        java.lang.Process proc;
        private String[] args;
        private File homeDir;
        private Map env;
        private boolean tryOtherLocations;
        private boolean preferSystemPhp;

        protected String[] getArgumentArray(String[] stringArray, String[] stringArray2) {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.addAll(Arrays.asList(stringArray));
            for (int i = 1; i < stringArray2.length; ++i) {
                linkedList.add(stringArray2[i]);
            }
            return linkedList.toArray(new String[linkedList.size()]);
        }

        protected void start() throws NullPointerException, IOException {
            Runtime runtime = Runtime.getRuntime();
            String[] stringArray = new String[]{null};
            if (this.args == null) {
                this.args = new String[]{null};
            }
            String string = this.args[0];
            String[] stringArray2 = null;
            if (PHP_EXEC == null) {
                int n;
                if (!this.preferSystemPhp) {
                    if (string != null && (stringArray2 = Util.checkCgiBinary(new StringBuffer(string))) != null) {
                        stringArray = stringArray2;
                    }
                    if (this.tryOtherLocations && stringArray[0] == null) {
                        for (n = 0; n < DEFAULT_CGI_LOCATIONS.length; ++n) {
                            File file = new File(DEFAULT_CGI_LOCATIONS[n]);
                            if (!file.exists()) continue;
                            stringArray[0] = file.getAbsolutePath();
                            break;
                        }
                    }
                } else {
                    if (this.tryOtherLocations && stringArray[0] == null) {
                        for (n = 0; n < DEFAULT_CGI_LOCATIONS.length; ++n) {
                            File file = new File(DEFAULT_CGI_LOCATIONS[n]);
                            if (!file.exists()) continue;
                            stringArray[0] = file.getAbsolutePath();
                            break;
                        }
                    }
                    if (string != null && stringArray[0] == null && (stringArray2 = Util.checkCgiBinary(new StringBuffer(string))) != null) {
                        stringArray = stringArray2;
                    }
                }
            }
            if (stringArray[0] == null && this.tryOtherLocations) {
                stringArray[0] = PHP_EXEC;
            }
            if (stringArray[0] == null && string != null && new File(string).exists()) {
                stringArray[0] = string;
            }
            if (stringArray[0] == null) {
                stringArray[0] = "php-cgi";
            }
            if (logLevel > 3) {
                Util.logDebug("Using php binary: " + Arrays.asList(stringArray));
            }
            if (this.homeDir != null && stringArray2 == null) {
                this.homeDir = HOME_DIR;
            }
            if (this.homeDir != null && !this.homeDir.exists()) {
                this.homeDir = null;
            }
            String[] stringArray3 = this.getArgumentArray(stringArray, this.args);
            this.proc = runtime.exec(stringArray3, Util.hashToStringArray(this.env), this.homeDir);
            if (logLevel > 3) {
                Util.logDebug("Started " + Arrays.asList(stringArray3));
            }
        }

        protected Process(String[] stringArray, File file, Map map, boolean bl, boolean bl2) {
            this.args = stringArray;
            this.homeDir = file;
            this.env = map;
            this.tryOtherLocations = bl;
            this.preferSystemPhp = bl2;
        }

        public static Process start(String[] stringArray, File file, Map map, boolean bl, boolean bl2, OutputStream outputStream) throws IOException {
            Process process = new Process(stringArray, file, map, bl, bl2);
            process.start();
            return process;
        }

        public void checkError() throws PhpException {
        }

        public OutputStream getOutputStream() {
            return this.proc.getOutputStream();
        }

        public InputStream getInputStream() {
            return this.proc.getInputStream();
        }

        public InputStream getErrorStream() {
            return this.proc.getErrorStream();
        }

        public int waitFor() throws InterruptedException {
            return this.proc.waitFor();
        }

        public int exitValue() {
            return this.proc.exitValue();
        }

        public void destroy() {
            this.proc.destroy();
        }

        public static class PhpException
        extends Exception {
            private static final long serialVersionUID = 767047598257671018L;
            private String errorString;

            public PhpException(String string) {
                super(string);
                this.errorString = string;
            }

            public String getError() {
                return this.errorString;
            }
        }
    }

    public static class Thread
    extends java.lang.Thread {
        public Thread() {
            this.initThread();
        }

        public Thread(String string) {
            super(string);
            this.initThread();
        }

        public Thread(Runnable runnable) {
            super(runnable);
            this.initThread();
        }

        public Thread(ThreadGroup threadGroup, Runnable runnable) {
            super(threadGroup, runnable);
            this.initThread();
        }

        public Thread(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
            this.initThread();
        }

        public Thread(Runnable runnable, String string) {
            super(runnable, string);
            this.initThread();
        }

        public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
            super(threadGroup, runnable, string);
            this.initThread();
        }

        public Thread(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
            super(threadGroup, runnable, string, l);
            this.initThread();
        }

        private void initThread() {
            this.setDaemon(true);
        }
    }

    public static abstract class OutputStreamFactory {
        public abstract OutputStream getOutputStream() throws IOException;
    }

    public static class SimpleHeaderParser
    extends HeaderParser {
        public void parseHeader(String string) {
        }

        public void addHeader(String string, String string2) {
        }
    }

    public static abstract class HeaderParser {
        public abstract void parseHeader(String var1);

        public abstract void addHeader(String var1, String var2);
    }

    public static class Logger
    implements ILogger {
        protected ChainsawLogger clogger = null;
        protected ILogger logger;

        public Logger() {
            this.logger = new FileLogger();
        }

        public Logger(ILogger iLogger) {
            this(!DEFAULT_LOG_FILE_SET, iLogger);
        }

        public Logger(boolean bl, ILogger iLogger) {
            if (bl) {
                try {
                    this.clogger = ChainsawLogger.createChainsawLogger();
                }
                catch (Throwable throwable) {
                    if (logLevel > 5) {
                        throwable.printStackTrace();
                    }
                    this.logger = iLogger;
                }
            } else {
                this.logger = iLogger;
            }
        }

        private ILogger getLogger() {
            if (this.logger == null) {
                this.logger = new FileLogger();
                return this.logger;
            }
            return this.logger;
        }

        public void printStackTrace(Throwable throwable) {
            if (this.clogger == null) {
                this.logger.printStackTrace(throwable);
            } else {
                try {
                    this.clogger.printStackTrace(throwable);
                }
                catch (Exception exception) {
                    this.clogger = null;
                    this.getLogger().printStackTrace(throwable);
                }
            }
        }

        public void log(int n, String string) {
            if (this.clogger == null) {
                this.logger.log(n, string);
            } else {
                try {
                    this.clogger.log(n, string);
                }
                catch (Exception exception) {
                    this.clogger = null;
                    this.getLogger().log(n, string);
                }
            }
        }

        public void warn(String string) {
            if (this.clogger == null) {
                this.logger.warn(string);
            } else {
                try {
                    this.clogger.warn(string);
                }
                catch (Exception exception) {
                    this.clogger = null;
                    this.getLogger().warn(string);
                }
            }
        }
    }
}

