/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends FilterInputStream {
    public static final int[] ASCII_HEX = ChunkedInputStream.getAscii();
    private boolean eof = false;
    private byte[] rn = new byte[2];
    private byte[] remaining;
    private int remainPos;
    private int remainLen;

    private static int[] getAscii() {
        int n;
        int[] nArray = new int[103];
        for (n = 48; n < 58; ++n) {
            nArray[n] = n - 48;
        }
        for (n = 65; n < 71; ++n) {
            nArray[n] = n - 55;
        }
        for (n = 97; n < 103; ++n) {
            nArray[n] = n - 87;
        }
        return nArray;
    }

    public ChunkedInputStream(InputStream inputStream) {
        super(new BufferedInputStream(inputStream));
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        if (this.eof) {
            return -1;
        }
        int n6 = 0;
        if (this.remaining != null) {
            if (n2 <= this.remainLen) {
                System.arraycopy(this.remaining, this.remainPos, byArray, n, n2);
                this.remainPos += n2;
                this.remainLen -= n2;
                return n2;
            }
            System.arraycopy(this.remaining, this.remainPos, byArray, n, this.remainLen);
            n += this.remainLen;
            n2 -= this.remainLen;
            n6 = this.remainLen;
        }
        if ((n5 = this.readPacketLength()) == 0) {
            this.eof = true;
        }
        this.remaining = new byte[n5];
        this.remainLen = 0;
        int n7 = 0;
        while ((n4 = this.in.read(this.remaining, n7, n5 - n7)) > 0) {
            n7 += n4;
        }
        if (n7 != n5) {
            throw new IOException("read chunked");
        }
        n7 = 0;
        while ((n4 = this.in.read(this.rn, n7, 2 - n7)) > 0) {
            n7 += n4;
        }
        if (n7 != 2) {
            throw new IOException("read \r\n");
        }
        if (n2 >= n5) {
            n3 = n5 + n6;
            System.arraycopy(this.remaining, 0, byArray, n, n5);
            this.remaining = null;
        } else {
            n3 = n6 + n2;
            System.arraycopy(this.remaining, 0, byArray, n, n2);
            this.remainPos = n2;
            this.remainLen = n5 - n2;
        }
        return n3;
    }

    private int readPacketLength() throws IOException {
        int n;
        int n2 = 0;
        while ((n = this.in.read()) != 13) {
            if (n == -1) {
                throw new IllegalStateException("read chunked packet length");
            }
            if (n == 32) continue;
            n2 <<= 4;
            n2 += ASCII_HEX[n];
        }
        if (this.in.read() == -1) {
            throw new IOException("read chunked packet length");
        }
        return n2;
    }
}

