/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import php.java.bridge.Util;

public class ChunkedOutputStream
extends FilterOutputStream {
    private static final byte[] RN0 = "0\r\n\r\n".getBytes();
    private byte[] buf = new byte[8];

    public ChunkedOutputStream(OutputStream outputStream) {
        super(new BufferedOutputStream(outputStream));
    }

    private void writeEOF() throws IOException {
        this.out.write(RN0);
    }

    private void writeHex(int n) throws IOException {
        int n2 = this.buf.length - 1;
        while (n > 0) {
            this.buf[n2] = Util.HEX_DIGITS[0xF & n];
            n >>>= 4;
            --n2;
        }
        this.out.write(this.buf, ++n2, this.buf.length - n2);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            this.writeEOF();
        } else {
            this.writeHex(n2);
            this.out.write(Util.RN);
            this.out.write(byArray, n, n2);
            this.out.write(Util.RN);
        }
        this.out.flush();
    }
}

