/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import php.java.bridge.IManaged;
import php.java.bridge.Invocable;
import php.java.bridge.Util;
import php.java.bridge.http.IContext;

public class Context
implements IManaged,
Invocable,
IContext {
    private Map globalScope;
    private Map engineScope;
    private static boolean registeredHook = false;
    private static LinkedList closeables = new LinkedList();
    private static Object lockObject = new Object();

    protected Context() {
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.getEngineScope().get(string) != null) {
            return this.getEngineScope().get(string);
        }
        if (this.getGlobalScope().get(string) != null) {
            return this.getGlobalScope().get(string);
        }
        return null;
    }

    public Object getAttribute(String string, int n) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        switch (n) {
            case 100: {
                return this.getEngineScope().get(string);
            }
            case 200: {
                return this.getGlobalScope().get(string);
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    public int getAttributesScope(String string) {
        if (this.getEngineScope().containsKey(string)) {
            return 100;
        }
        if (this.getGlobalScope().containsKey(string)) {
            return 200;
        }
        return -1;
    }

    public Writer getWriter() throws IOException {
        return new PrintWriter(System.out, true);
    }

    public Object removeAttribute(String string, int n) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        switch (n) {
            case 100: {
                return this.getEngineScope().remove(string);
            }
            case 200: {
                return this.getGlobalScope().remove(string);
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    public void setAttribute(String string, Object object, int n) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        switch (n) {
            case 100: {
                this.getEngineScope().put(string, object);
                break;
            }
            case 200: {
                this.getGlobalScope().put(string, object);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid scope");
            }
        }
    }

    public Object getHttpServletRequest() {
        throw new IllegalStateException("PHP not running in a servlet environment");
    }

    public Object getServletContext() {
        throw new IllegalStateException("PHP not running in a servlet environment");
    }

    public Object getHttpServletResponse() {
        throw new IllegalStateException("PHP not running in a servlet environment");
    }

    public Object getServlet() {
        throw new IllegalStateException("PHP not running in a servlet environment");
    }

    public Object getServletConfig() {
        throw new IllegalStateException("PHP not running in a servlet environment");
    }

    public boolean call(Object object) {
        return false;
    }

    protected void setGlobalScope(Map map) {
        this.globalScope = map;
    }

    protected Map getGlobalScope() {
        if (this.globalScope == null) {
            this.globalScope = new HashMap();
        }
        return this.globalScope;
    }

    protected void setEngineScope(Map map) {
        this.engineScope = map;
    }

    protected Map getEngineScope() {
        if (this.engineScope == null) {
            this.engineScope = new HashMap();
        }
        return this.engineScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleManaged(Object object) {
        LinkedList linkedList = closeables;
        synchronized (linkedList) {
            if (!registeredHook) {
                registeredHook = true;
                try {
                    Runtime.getRuntime().addShutdownHook(new Util.Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (closeables == null) {
                                return;
                            }
                            LinkedList linkedList = closeables;
                            synchronized (linkedList) {
                                Iterator iterator = closeables.iterator();
                                while (iterator.hasNext()) {
                                    Object e = iterator.next();
                                    try {
                                        Method method = e.getClass().getMethod("close", Util.ZERO_PARAM);
                                        method.invoke(e, Util.ZERO_ARG);
                                    }
                                    catch (Exception exception) {
                                        Util.printStackTrace(exception);
                                    }
                                    iterator.remove();
                                }
                            }
                        }
                    });
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            closeables.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getManageable(Object object) throws Exception {
        Object object2 = lockObject;
        synchronized (object2) {
            Method method = object.getClass().getMethod("call", Util.ZERO_PARAM);
            return method.invoke(object, Util.ZERO_ARG);
        }
    }

    public Object init(Object object) throws Exception {
        return Context.getManageable(object);
    }

    public void onShutdown(Object object) {
        Context.handleManaged(object);
    }

    public static String getRealPathInternal(String string) {
        try {
            return new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return new File(string).getAbsolutePath();
        }
    }

    public String getRealPath(String string) {
        return Context.getRealPathInternal(string);
    }
}

