/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import php.java.bridge.ISession;
import php.java.bridge.JavaBridge;
import php.java.bridge.JavaBridgeClassLoader;
import php.java.bridge.Request;
import php.java.bridge.SessionFactory;
import php.java.bridge.SimpleJavaBridgeClassLoader;
import php.java.bridge.Util;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.IContextFactoryVisitor;
import php.java.bridge.http.SimpleContextFactory;

public final class ContextFactory
extends SessionFactory
implements IContextFactory {
    public static final String EMPTY_CONTEXT_NAME = "";
    public static final ICredentials NO_CREDENTIALS = new ICredentials(){

        public String toString() {
            return "[no credentials]";
        }
    };
    private static final HashMap contexts;
    private static final HashMap liveContexts;
    private String id;
    private long timestamp = System.currentTimeMillis();
    private ICredentials credentials = null;
    private IContextFactoryVisitor visitor;
    private static long counter;

    private static synchronized String addNext(String string, ContextFactory contextFactory, boolean bl) {
        ++counter;
        try {
            string = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Util.printStackTrace(unsupportedEncodingException);
        }
        String string2 = Long.toHexString(counter) + "@" + string;
        if (bl) {
            liveContexts.put(string2, contextFactory);
        } else {
            contexts.put(string2, contextFactory);
        }
        return string2;
    }

    private static synchronized void remove(String string) {
        ContextFactory contextFactory = (ContextFactory)liveContexts.remove(string);
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: removed context: " + (contextFactory == null ? "already handled" : String.valueOf(contextFactory.visitor)) + ", # of contexts: " + contexts.size());
        }
    }

    private static synchronized ContextFactory moveContext(String string) {
        Object v = liveContexts.get(string);
        if (v != null) {
            return (ContextFactory)v;
        }
        v = contexts.remove(string);
        if (v != null) {
            liveContexts.put(string, v);
            return (ContextFactory)v;
        }
        return null;
    }

    public ContextFactory(String string, boolean bl) {
        this.id = ContextFactory.addNext(string, this, bl);
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: new context: " + this.id + " for web context" + string + ", # of contexts: " + contexts.size());
        }
    }

    public static IContextFactory addNew() {
        return new SimpleContextFactory(EMPTY_CONTEXT_NAME, false);
    }

    private void init(ICredentials iCredentials) {
        this.credentials = iCredentials;
    }

    public static IContextFactory get(String string, ICredentials iCredentials) {
        if (iCredentials == null) {
            return ContextFactory.peek(string);
        }
        ContextFactory contextFactory = ContextFactory.moveContext(string);
        if (contextFactory == null) {
            return null;
        }
        if (contextFactory.credentials == null) {
            contextFactory.init(iCredentials);
        }
        if (contextFactory.credentials != iCredentials) {
            throw new SecurityException("Illegal access");
        }
        return contextFactory.visitor;
    }

    public static synchronized IContextFactory peek(String string) {
        ContextFactory contextFactory = (ContextFactory)liveContexts.get(string);
        if (contextFactory == null) {
            contextFactory = (ContextFactory)contexts.get(string);
        }
        if (contextFactory == null) {
            return null;
        }
        if (!contextFactory.isNew()) {
            throw new SecurityException("illegal access");
        }
        return contextFactory.visitor;
    }

    private static synchronized void switchContext(String string, ContextFactory contextFactory) {
        boolean bl = true;
        ContextFactory contextFactory2 = (ContextFactory)liveContexts.get(string);
        if (contextFactory2 == null) {
            contextFactory2 = (ContextFactory)contexts.get(string);
            bl = false;
        }
        if (contextFactory2 == null || contextFactory2 == contextFactory) {
            return;
        }
        if (contextFactory2.credentials != null) {
            throw new IllegalStateException("context already initialized");
        }
        JavaBridge javaBridge = contextFactory.getBridge();
        JavaBridge javaBridge2 = contextFactory2.checkBridge();
        if (javaBridge2 == null) {
            throw new IllegalStateException("recycle empty context");
        }
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: setting new bridge. visited: " + javaBridge.getFactory() + " <= visitor: " + javaBridge2.getFactory());
        }
        javaBridge.request.setBridge(javaBridge2);
        javaBridge = javaBridge2;
        if (bl) {
            liveContexts.remove(string);
            contexts.put(string, contextFactory2);
        }
        contextFactory2.visitor.release();
        contextFactory.accept(contextFactory2.visitor);
        contextFactory.visitor.initialize();
        if (contextFactory2.getClassLoader() != javaBridge.getClassLoader().getDefaultClassLoader()) {
            throw new IllegalStateException("class loader");
        }
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: " + contextFactory + " is swiching thread context, using classloader: " + System.identityHashCode(contextFactory2.getClassLoader().getParent()));
        }
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: accepted visitor: " + contextFactory2.visitor);
        }
    }

    public void recycle(String string) {
        ContextFactory.switchContext(string, this);
    }

    public void recycle() {
        if (Util.logLevel >= 4) {
            Util.logDebug("contextfactory: finish context called (recycle context factory) " + this.visitor);
        }
        super.recycle();
        this.visitor.invalidate();
        if (this.bridge != null) {
            this.bridge.getClassLoader().switcheThreadContextClassLoader();
        }
    }

    public void destroy() {
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: context destroyed (remove context factory): " + this.visitor);
        }
        ContextFactory.remove(this.getId());
        super.destroy();
        this.visitor.invalidate();
    }

    private static synchronized void destroyOrphaned() {
        long l = System.currentTimeMillis();
        Iterator iterator = contexts.values().iterator();
        while (iterator.hasNext()) {
            ContextFactory contextFactory = (ContextFactory)iterator.next();
            if (contextFactory.timestamp + (long)Util.MAX_WAIT >= l) continue;
            contextFactory.visitor.invalidate();
            Util.warn("contextfactory: Orphaned context: " + contextFactory.visitor + " removed.");
            iterator.remove();
        }
    }

    public static synchronized void destroyAll() {
        ContextFactory contextFactory;
        Iterator iterator = contexts.values().iterator();
        while (iterator.hasNext()) {
            contextFactory = (ContextFactory)iterator.next();
            contextFactory.visitor.invalidate();
            if (Util.logLevel > 4) {
                Util.logDebug("contextfactory: Orphaned context: " + contextFactory.visitor + " removed.");
            }
            iterator.remove();
        }
        iterator = contexts.values().iterator();
        while (iterator.hasNext()) {
            contextFactory = (ContextFactory)iterator.next();
            contextFactory.visitor.invalidate();
            iterator.remove();
        }
    }

    public void releaseManaged() throws InterruptedException {
        this.visitor.releaseManaged();
    }

    public void waitFor(long l) throws InterruptedException {
        this.visitor.waitFor(l);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "Context# " + this.id + ", credentials: " + this.credentials;
    }

    public IContext getContext() {
        return this.visitor.getContext();
    }

    public void setContext(IContext iContext) {
        this.visitor.setContext(iContext);
    }

    private void setVisitor(IContextFactoryVisitor iContextFactoryVisitor) {
        this.visitor = iContextFactoryVisitor;
    }

    public void accept(IContextFactoryVisitor iContextFactoryVisitor) {
        iContextFactoryVisitor.visit(this);
        this.setVisitor(iContextFactoryVisitor);
    }

    public ISession getSimpleSession(String string, boolean bl, int n) {
        return super.getSession(string, bl, n);
    }

    public ISession getSession(String string, boolean bl, int n) {
        return this.visitor.getSession(string, bl, n);
    }

    public synchronized void release() {
        ContextFactory contextFactory = (ContextFactory)contexts.remove(this.id);
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: released empty context: " + (contextFactory != null ? String.valueOf(contextFactory.visitor) : "<already handled>") + ", # of contexts: " + contexts.size() + ", # of live contexts: " + liveContexts.size());
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.visitor.setClassLoader(classLoader);
    }

    public SimpleJavaBridgeClassLoader getJavaBridgeClassLoader() {
        if (this.javaBridgeClassLoader != null) {
            return this.javaBridgeClassLoader;
        }
        this.javaBridgeClassLoader = new JavaBridgeClassLoader(this.getClassLoader());
        return this.javaBridgeClassLoader;
    }

    public ClassLoader getClassLoader() {
        return this.visitor.getClassLoader();
    }

    public void initialize() {
        this.visitor.initialize();
    }

    public void invalidate() {
        this.visitor.invalidate();
    }

    public String getRedirectString() {
        return this.visitor.getRedirectString();
    }

    public String getRedirectString(String string) {
        return this.visitor.getRedirectString(string);
    }

    public String getSocketName() {
        return this.visitor.getSocketName();
    }

    public void parseHeader(Request request, InputStream inputStream) throws IOException {
        JavaBridge javaBridge = this.getBridge();
        inputStream.read();
        byte by = (byte)(0xFF & inputStream.read());
        javaBridge.out.write(0);
        javaBridge.out.flush();
        int n = 0xFF & inputStream.read() | 0xFF & inputStream.read() << 8;
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        String string = new String(byArray, 0, n, "ASCII");
        IContextFactory iContextFactory = (IContextFactory)javaBridge.getFactory();
        iContextFactory.recycle(string);
        if (by != -1) {
            request.init(by);
        }
    }

    static {
        try {
            ContextFactory.getTimer().addJob(new Runnable(){

                public void run() {
                    ContextFactory.destroyOrphaned();
                }
            });
        }
        catch (Throwable throwable) {
            Util.printStackTrace(throwable);
        }
        contexts = new HashMap();
        liveContexts = new HashMap();
        counter = 0L;
    }

    public static interface ICredentials {
    }
}

