/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import php.java.bridge.ILogger;
import php.java.bridge.JavaBridge;
import php.java.bridge.Request;
import php.java.bridge.SimpleJavaBridgeClassLoader;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannel;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.IContextFactory;

public class ContextRunner
implements Runnable {
    protected IContextFactory ctx;
    protected Request request;
    protected InputStream in;
    protected OutputStream out;
    protected AbstractChannel channel;
    protected ContextFactory.ICredentials contextServer;
    protected ILogger logger;
    protected byte shortPathHeader;

    protected ContextRunner(ContextFactory.ICredentials iCredentials, AbstractChannel abstractChannel, ILogger iLogger) {
        this.contextServer = iCredentials;
        this.channel = abstractChannel;
        this.logger = iLogger;
    }

    protected int readLength() throws IOException {
        byte[] byArray = new byte[1];
        this.in.read(byArray);
        this.shortPathHeader = (byte)(0xFF & byArray[0]);
        byArray = new byte[2];
        this.in.read(byArray);
        return 0xFF & byArray[0] | 0xFF00 & byArray[1] << 8;
    }

    protected String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.in.read(byArray);
        return new String(byArray, "ASCII");
    }

    protected String readName() throws IOException {
        return this.readString(this.readLength());
    }

    protected void setIO(JavaBridge javaBridge, InputStream inputStream, OutputStream outputStream) {
        javaBridge.request.reset();
        javaBridge.in = inputStream;
        javaBridge.out = outputStream;
    }

    protected boolean init() throws IOException {
        if (Util.logLevel > 4) {
            Util.logDebug("starting a new ContextRunner " + this);
        }
        this.out = this.channel.getOuptutStream();
        this.in = this.channel.getInputStream();
        int n = this.in.read();
        if (n != 127) {
            if (n == -1) {
                return false;
            }
            try {
                this.out.write(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException("Protocol violation");
        }
        this.out.write(0);
        this.out.flush();
        String string = this.readName();
        this.ctx = ContextFactory.get(string, this.contextServer);
        if (this.ctx == null) {
            throw new IOException("No context available for: " + string + ". Please make sure that your script does not exceed php.java.bridge.max_wait, currently set to: " + Util.MAX_WAIT);
        }
        JavaBridge javaBridge = this.ctx.getBridge();
        if (Util.logLevel > 4) {
            Util.logDebug(this.ctx + " created new thread, using class loader: " + System.identityHashCode(this.ctx.getClassLoader().getParent()));
        }
        SimpleJavaBridgeClassLoader simpleJavaBridgeClassLoader = javaBridge.getClassLoader();
        simpleJavaBridgeClassLoader.switcheThreadContextClassLoader();
        if (this.shortPathHeader != -1) {
            javaBridge.request = new Request(javaBridge);
            javaBridge.request.init(this.shortPathHeader);
        }
        this.setIO(javaBridge, this.in, this.out);
        this.request = javaBridge.request;
        this.ctx.initialize();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Util.setLogger(this.logger);
            if (this.init()) {
                this.request.handleRequests();
            } else {
                Util.warn("context runner init failed");
            }
        }
        catch (IOException iOException) {
            if (Util.logLevel > 4) {
                Util.printStackTrace(iOException);
            }
        }
        catch (Exception exception) {
            Util.printStackTrace(exception);
        }
        finally {
            if (this.ctx != null) {
                this.ctx.destroy();
            }
            this.channel.shutdown();
        }
    }
}

