/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import php.java.bridge.NotImplementedException;
import php.java.bridge.Util;

public class HttpResponse {
    private HashMap headers;
    private OutputStream outputStream;
    private boolean headersWritten;
    private final byte[] h1 = Util.toBytes("HTTP/1.0 200 OK\r\n");
    private final byte[] h2 = Util.toBytes("Host: localhost\r\nConnection: close\r\n");
    private final byte[] h4 = Util.toBytes(": ");

    public HttpResponse(OutputStream outputStream) {
        this.headers = new HashMap();
        this.outputStream = new BufferedOutputStream(outputStream){

            public void write(byte[] byArray, int n, int n2) throws IOException {
                if (!HttpResponse.this.headersWritten) {
                    HttpResponse.this.headersWritten = true;
                    HttpResponse.this.writeHeaders();
                }
                super.write(byArray, n, n2);
            }
        };
    }

    public void setHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setStatus(int n) {
        throw new NotImplementedException();
    }

    public void addHeader(String string, String string2) {
        this.setHeader(string, string2);
    }

    private void writeHeaders() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.h1);
        byteArrayOutputStream.write(this.h2);
        Iterator iterator = this.headers.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = this.headers.get(k);
            byteArrayOutputStream.write(Util.toBytes((String)k));
            byteArrayOutputStream.write(this.h4);
            byteArrayOutputStream.write(Util.toBytes((String)v));
            byteArrayOutputStream.write(Util.RN);
        }
        byteArrayOutputStream.write(Util.RN);
        byteArrayOutputStream.writeTo(this.outputStream);
    }

    public void setContentLength(int n) throws IOException {
        this.setHeader("Content-Length", String.valueOf(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        finally {
            this.outputStream = null;
        }
    }
}

