/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import php.java.bridge.AppThreadPool;
import php.java.bridge.ILogger;
import php.java.bridge.ISocketFactory;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.ContextRunner;
import php.java.bridge.http.PipeContextServer;

public final class SocketContextServer
extends PipeContextServer
implements Runnable {
    private ISocketFactory serverSocket = null;
    protected List sockets = Collections.synchronizedList(new ArrayList());
    private ILogger logger;
    private String origContextName;
    public static final boolean SOCKET_SERVER_AVAIL = SocketContextServer.checkTestTunnel("php.java.bridge.no_socket_server");

    public SocketContextServer(AppThreadPool appThreadPool, boolean bl, String string) {
        super(ContextFactory.NO_CREDENTIALS, appThreadPool, "", bl);
        this.origContextName = string;
        try {
            this.serverSocket = JavaBridge.bind(bl || Util.JAVABRIDGE_PROMISCUOUS ? "INET:0" : "INET_LOCAL:0");
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkAccept("127.0.0.1", Integer.parseInt(this.serverSocket.getSocketName()));
            }
            Util.Thread thread = new Util.Thread(this, "JavaBridgeSocketContextServer(" + this.serverSocket.getSocketName() + ")");
            thread.start();
        }
        catch (Throwable throwable) {
            Util.warn("Local communication channel not available.");
            Util.printStackTrace(throwable);
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.serverSocket = null;
        }
    }

    private boolean accept() {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        Socket socket = null;
        Channel channel = null;
        try {
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException iOException) {
                return false;
            }
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
            channel = new Channel(this.getChannelName(), inputStream, outputStream, socket);
            ContextRunner contextRunner = new ContextRunner(this.contextServer, channel, this.logger);
            if (this.threadPool != null) {
                this.threadPool.start(contextRunner);
            } else {
                Util.Thread thread = new Util.Thread(contextRunner, "JavaBridgeContextRunner(" + this.contextName + ")");
                thread.start();
            }
        }
        catch (SecurityException securityException) {
            if (channel != null) {
                channel.shutdown(socket);
            }
            ContextFactory.destroyAll();
            Util.printStackTrace(securityException);
            return false;
        }
        catch (Throwable throwable) {
            if (channel != null) {
                channel.shutdown(socket);
            }
            Util.printStackTrace(throwable);
        }
        return true;
    }

    public void run() {
        while (this.serverSocket != null) {
            if (this.accept()) continue;
            this.destroy();
        }
        Util.logDebug("SocketContextServer stopped, the local channel is not available anymore.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllSockets() {
        List list = this.sockets;
        synchronized (list) {
            Iterator iterator = this.sockets.iterator();
            while (iterator.hasNext()) {
                Socket socket = (Socket)iterator.next();
                iterator.remove();
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void destroy() {
        super.destroy();
        this.closeAllSockets();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                Util.printStackTrace(iOException);
            }
            this.serverSocket = null;
        }
    }

    public boolean isAvailable() {
        return this.origContextName == "" && SOCKET_SERVER_AVAIL && this.serverSocket != null || !this.promiscuous && !Util.JAVABRIDGE_PROMISCUOUS && SOCKET_SERVER_AVAIL && this.serverSocket != null;
    }

    public String getChannelName() {
        return this.serverSocket.getSocketName();
    }

    public boolean start(AbstractChannelName abstractChannelName, ILogger iLogger) {
        this.logger = iLogger;
        return this.isAvailable();
    }

    protected class Channel
    extends PipeContextServer.Channel {
        protected Socket sock;

        public Channel(String string, InputStream inputStream, OutputStream outputStream, Socket socket) {
            super(string, inputStream, outputStream);
            this.sock = socket;
            SocketContextServer.this.sockets.add(this.sock);
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public OutputStream getOuptutStream() {
            return this.out;
        }

        public Socket getSocket() {
            return this.sock;
        }

        protected void shutdown(Socket socket) {
            if (SocketContextServer.this.sockets.remove(socket)) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void shutdown() {
            super.shutdown();
            this.shutdown(this.sock);
        }
    }
}

