/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.util.Arrays;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import php.java.bridge.Util;
import php.java.script.CloseablePhpScriptEngine;
import php.java.script.PhpScriptEngine;

public class PhpScriptEngineFactory
implements ScriptEngineFactory {
    protected Factory factory;
    private static final String ENGINE_NAME = Util.EXTENSION_NAME + " php script engine for Java";
    List names;

    public PhpScriptEngineFactory() {
        try {
            Class.forName("java.io.Closeable");
            this.factory = new Factory(true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.factory = new Factory(false);
        }
    }

    public String getEngineName() {
        return ENGINE_NAME;
    }

    public String getEngineVersion() {
        return Util.VERSION;
    }

    public String getLanguageName() {
        return "php";
    }

    public String getLanguageVersion() {
        return "6";
    }

    public List getExtensions() {
        return this.getNames();
    }

    public List getMimeTypes() {
        return Arrays.asList(new String[0]);
    }

    public List getNames() {
        if (this.names == null) {
            this.names = Arrays.asList(this.getLanguageName(), "phtml", "php4", "php5", "php6");
        }
        return this.names;
    }

    public ScriptEngine getScriptEngine() {
        return this.factory.create();
    }

    public Object getParameter(String string) {
        if (string.equals("javax.script.name")) {
            return this.getLanguageName();
        }
        if (string.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (string.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (string.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (string.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (string.equals("THREADING")) {
            return "STATELESS";
        }
        throw new IllegalArgumentException("key");
    }

    public String getMethodCallSyntax(String string, String string2, String[] stringArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("$");
        stringBuffer.append(string);
        stringBuffer.append("->");
        stringBuffer.append(string2);
        stringBuffer.append("(");
        for (n = 0; n < stringArray.length - 1; ++n) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(",");
        }
        stringBuffer.append(stringArray[n]);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getOutputStatement(String string) {
        return "echo(" + string + ")";
    }

    public String getProgram(String[] stringArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("<?php ");
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(";");
        }
        stringBuffer.append("?>");
        return stringBuffer.toString();
    }

    protected class Factory {
        protected boolean hasCloseable;

        public Factory(boolean bl) {
            this.hasCloseable = bl;
        }

        public ScriptEngine create() {
            if (this.hasCloseable) {
                return new CloseablePhpScriptEngine(PhpScriptEngineFactory.this);
            }
            return new PhpScriptEngine(PhpScriptEngineFactory.this);
        }
    }
}

