/*
 * Decompiled with CFR 0.152.
 */
package php.java.script.servlet;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.Util;
import php.java.script.servlet.EngineFactoryHelper;
import php.java.script.servlet.IScriptReader;
import php.java.script.servlet.InvocablePhpServletLocalHttpServerScriptEngine;
import php.java.script.servlet.InvocablePhpServletRemoteHttpServerScriptEngine;
import php.java.script.servlet.PhpServletScriptEngine;
import php.java.script.servlet.ScriptFileReader;
import php.java.script.servlet.ScriptReader;

public final class EngineFactory {
    public static final String ROOT_ENGINE_FACTORY_ATTRIBUTE = EngineFactory.class.getName() + ".ROOT";
    private boolean hasCloseable;

    public EngineFactory() {
        try {
            Class.forName("java.io.Closeable");
            this.hasCloseable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.hasCloseable = false;
        }
    }

    private Object getScriptEngine(Servlet servlet, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws MalformedURLException {
        return this.hasCloseable ? EngineFactoryHelper.newCloseablePhpServletScriptEngine(servlet, servletContext, httpServletRequest, httpServletResponse, httpServletRequest.getScheme(), httpServletRequest.getServerPort()) : new PhpServletScriptEngine(servlet, servletContext, httpServletRequest, httpServletResponse, httpServletRequest.getScheme(), httpServletRequest.getServerPort());
    }

    private Object getInvocableScriptEngine(Servlet servlet, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, URI uRI, String string) throws MalformedURLException, URISyntaxException {
        return this.hasCloseable ? EngineFactoryHelper.newCloseableInvocablePhpServletRemoteHttpServerScriptEngine(servlet, servletContext, httpServletRequest, httpServletResponse, uRI, string) : new InvocablePhpServletRemoteHttpServerScriptEngine(servlet, servletContext, httpServletRequest, httpServletResponse, uRI, string);
    }

    static EngineFactory getEngineFactory(ServletContext servletContext) {
        EngineFactory engineFactory = (EngineFactory)servletContext.getAttribute(ROOT_ENGINE_FACTORY_ATTRIBUTE);
        return engineFactory;
    }

    static EngineFactory getRequiredEngineFactory(ServletContext servletContext) throws IllegalStateException {
        EngineFactory engineFactory = EngineFactory.getEngineFactory(servletContext);
        if (engineFactory == null) {
            throw new IllegalStateException("No EngineFactory found. Have you registered a listener?");
        }
        return engineFactory;
    }

    public static ScriptEngine getPhpScriptEngine(final Servlet servlet, final ServletContext servletContext, final HttpServletRequest httpServletRequest, final HttpServletResponse httpServletResponse) throws Exception {
        return (ScriptEngine)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return (ScriptEngine)EngineFactory.getRequiredEngineFactory(servletContext).getScriptEngine(servlet, servletContext, httpServletRequest, httpServletResponse);
            }
        });
    }

    public static ScriptEngine getInvocablePhpScriptEngine(final Servlet servlet, final ServletContext servletContext, final HttpServletRequest httpServletRequest, final HttpServletResponse httpServletResponse, final URI uRI, final String string) throws Exception {
        return (ScriptEngine)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return (ScriptEngine)EngineFactory.getRequiredEngineFactory(servletContext).getInvocableScriptEngine(servlet, servletContext, httpServletRequest, httpServletResponse, uRI, string);
            }
        });
    }

    public static ScriptEngine getInvocablePhpScriptEngine(Servlet servlet, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, URI uRI) throws Exception {
        return EngineFactory.getInvocablePhpScriptEngine(servlet, servletContext, httpServletRequest, httpServletResponse, uRI, httpServletRequest.getLocalName());
    }

    public static Reader createPhpScriptReader(String string) {
        return new ScriptReader(string);
    }

    public static Reader createPhpScriptReader(Reader reader) {
        return new ScriptReader(reader);
    }

    public static Reader createPhpScriptFileReader(final String string, final Reader reader) {
        return (Reader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (reader instanceof ScriptReader) {
                        return new ScriptFileReader(string, (ScriptReader)reader);
                    }
                    return new ScriptFileReader(string, new OneShotReader(reader));
                }
                catch (IOException iOException) {
                    Util.printStackTrace((Throwable)iOException);
                    return null;
                }
            }
        });
    }

    public static Reader createPhpScriptFileReader(final String string, final ScriptReader scriptReader) {
        return (Reader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return new ScriptFileReader(string, scriptReader);
                }
                catch (IOException iOException) {
                    Util.printStackTrace((Throwable)iOException);
                    return null;
                }
            }
        });
    }

    public static Reader createPhpScriptFileReader(final String string) {
        return (Reader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return new ScriptFileReader(string);
                }
                catch (IOException iOException) {
                    Util.printStackTrace((Throwable)iOException);
                    return null;
                }
            }
        });
    }

    public void releaseScriptEngines(final List list) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    InvocablePhpServletLocalHttpServerScriptEngine invocablePhpServletLocalHttpServerScriptEngine = (InvocablePhpServletLocalHttpServerScriptEngine)((Object)iterator.next());
                    invocablePhpServletLocalHttpServerScriptEngine.release();
                }
                list.clear();
                return null;
            }
        });
    }

    static void addManaged(ServletContext servletContext, InvocablePhpServletLocalHttpServerScriptEngine invocablePhpServletLocalHttpServerScriptEngine) throws ScriptException {
        try {
            EngineFactory.addManagedInternal(servletContext, invocablePhpServletLocalHttpServerScriptEngine);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (ScriptException)privilegedActionException.getCause();
        }
    }

    private static void addManagedInternal(final ServletContext servletContext, final InvocablePhpServletLocalHttpServerScriptEngine invocablePhpServletLocalHttpServerScriptEngine) throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                List list = null;
                try {
                    list = EngineFactoryHelper.getManagedEngineList(servletContext);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                if (list != null) {
                    list.add(invocablePhpServletLocalHttpServerScriptEngine);
                    invocablePhpServletLocalHttpServerScriptEngine.reserveContinuation();
                }
                return null;
            }
        });
    }

    private static final class OneShotReader
    extends FilterReader
    implements IScriptReader {
        protected OneShotReader(Reader reader) {
            super(reader);
        }

        public boolean isClosed() {
            try {
                this.in.ready();
            }
            catch (IOException iOException) {
                return true;
            }
            return false;
        }
    }
}

