/*
 * Decompiled with CFR 0.152.
 */
package php.java.script.servlet;

import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.Util;
import php.java.bridge.http.ContextServer;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.script.PhpScriptEngine;
import php.java.script.servlet.PhpServletContextFactory;
import php.java.script.servlet.PhpSimpleHttpScriptContext;
import php.java.script.servlet.ScriptFileReader;
import php.java.script.servlet.ServletReader;
import php.java.servlet.PhpJavaServlet;

abstract class PhpServletLocalHttpServerScriptEngine
extends PhpScriptEngine {
    protected Servlet servlet;
    protected ServletContext servletCtx;
    protected HttpServletRequest req;
    protected HttpServletResponse res;
    protected PhpSimpleHttpScriptContext scriptContext;
    protected String webPath;
    protected boolean overrideHosts = true;
    protected ContextServer contextServer;
    protected boolean promiscuous;
    private URL url;
    private int port;
    private String protocol;

    protected URL getURL(String string) throws MalformedURLException, URISyntaxException {
        if (this.url != null) {
            return this.url;
        }
        this.url = new URI(this.protocol, null, Util.getHostAddress((boolean)this.promiscuous), this.port, string, null, null).toURL();
        return this.url;
    }

    public PhpServletLocalHttpServerScriptEngine(Servlet servlet, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, int n) throws MalformedURLException {
        String string2;
        this.servlet = servlet;
        this.servletCtx = servletContext;
        this.req = httpServletRequest;
        this.res = httpServletResponse;
        try {
            string2 = servletContext.getInitParameter("override_hosts");
            if (string2 == null) {
                string2 = "";
            }
            string2 = string2.trim();
            if ((string2 = string2.toLowerCase()).equals("off") || string2.equals("false")) {
                this.overrideHosts = false;
            }
        }
        catch (Exception exception) {
            Util.printStackTrace((Throwable)exception);
        }
        try {
            string2 = servletContext.getInitParameter("promiscuous");
            if (string2 == null) {
                string2 = "";
            }
            string2 = string2.trim();
            if ((string2 = string2.toLowerCase()).equals("on") || string2.equals("true")) {
                this.promiscuous = true;
            }
        }
        catch (Exception exception) {
            Util.printStackTrace((Throwable)exception);
        }
        this.scriptContext.initialize(servlet, this.servletCtx, httpServletRequest, httpServletResponse);
        this.port = n;
        this.protocol = string;
        this.contextServer = PhpJavaServlet.getContextServer(servletContext, this.promiscuous);
    }

    protected ScriptContext getPhpScriptContext() {
        this.scriptContext = new PhpSimpleHttpScriptContext();
        Bindings bindings = this.createBindings();
        this.scriptContext.setBindings(bindings, 100);
        this.scriptContext.setBindings(this.getBindings(200), 200);
        return this.scriptContext;
    }

    protected ContextServer getContextServer() {
        return this.contextServer;
    }

    protected void addNewContextFactory() {
        this.ctx = PhpServletContextFactory.addNew(this.getContextServer(), (IContext)this.getContext(), this.servlet, this.servletCtx, this.req, this.res);
    }

    protected Object eval(final Reader reader, final ScriptContext scriptContext, final String string) throws ScriptException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return PhpServletLocalHttpServerScriptEngine.this.evalInternal(reader, scriptContext, string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (ScriptException)privilegedActionException.getCause();
        }
    }

    private Object evalInternal(Reader reader, ScriptContext scriptContext, String string) throws ScriptException {
        if (reader == null) {
            return null;
        }
        if (!(reader instanceof ScriptFileReader)) {
            throw new IllegalArgumentException("reader must be a ScriptFileReader");
        }
        ScriptFileReader scriptFileReader = (ScriptFileReader)reader;
        ServletReader servletReader = null;
        try {
            String string2 = scriptFileReader.getResourcePath(this.servletCtx);
            this.webPath = this.req.getContextPath() + string2;
            this.setNewContextFactory();
            this.setName(string);
            servletReader = new ServletReader(this.servletCtx, string2, this.getURL(this.webPath), this.req);
            this.script = this.doEval(servletReader, scriptContext);
        }
        catch (Exception exception) {
            Util.printStackTrace((Throwable)exception);
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof ScriptException) {
                throw (ScriptException)exception;
            }
            throw new ScriptException(exception);
        }
        finally {
            if (servletReader != null) {
                try {
                    servletReader.close();
                }
                catch (IOException iOException) {}
            }
            this.release();
        }
        return this.resultProxy;
    }

    protected void setStandardEnvironmentValues(Map map) {
        PhpServletLocalHttpServerScriptEngine.setStandardEnvironmentValues(this.ctx, map, this.req, this.webPath, this.overrideHosts);
    }

    static void setStandardEnvironmentValues(IContextFactory iContextFactory, Map map, HttpServletRequest httpServletRequest, String string, boolean bl) {
        map.put("X_JAVABRIDGE_CONTEXT", iContextFactory.getId());
        map.put("X_JAVABRIDGE_OVERRIDE_HOSTS", iContextFactory.getRedirectString(string));
    }
}

