/*
 * Decompiled with CFR 0.152.
 */
package php.java.script.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.ILogger;
import php.java.bridge.http.Context;
import php.java.script.AbstractPhpScriptContext;
import php.java.script.IPhpScriptContext;
import php.java.script.PhpScriptLogWriter;
import php.java.script.PhpScriptWriter;
import php.java.servlet.Logger;

public class PhpSimpleHttpScriptContext
extends AbstractPhpScriptContext
implements IPhpScriptContext {
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected ServletContext context;
    protected Servlet servlet;

    public void initialize(Servlet servlet, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.context = servletContext;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.servlet = servlet;
        this.setAttribute("php.java.servlet.ServletContext", servletContext, 100);
        this.setAttribute("php.java.servlet.ServletConfig", servlet.getServletConfig(), 100);
        this.setAttribute("php.java.servlet.Servlet", servlet, 100);
        this.setAttribute("php.java.servlet.HttpServletRequest", httpServletRequest, 100);
        this.setAttribute("php.java.servlet.HttpServletResponse", httpServletResponse, 100);
    }

    public Object getAttribute(String string, int n) {
        if (n == 0) {
            return this.request.getAttribute(string);
        }
        if (n == 150) {
            return this.request.getSession().getAttribute(string);
        }
        if (n == 175) {
            return this.context.getAttribute(string);
        }
        return super.getAttribute(string, n);
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        Object object;
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.engineScope != null && (object = this.engineScope.get(string)) != null) {
            return object;
        }
        if (this.globalScope != null && (object = this.globalScope.get(string)) != null) {
            return object;
        }
        object = this.request.getAttribute(string);
        if (object != null) {
            return object;
        }
        object = this.request.getSession().getAttribute(string);
        if (object != null) {
            return object;
        }
        object = this.context.getAttribute(string);
        if (object != null) {
            return object;
        }
        return null;
    }

    public void setAttribute(String string, Object object, int n) throws IllegalArgumentException {
        if (n == 0) {
            this.request.setAttribute(string, object);
        } else if (n == 150) {
            this.request.getSession().setAttribute(string, object);
        } else if (n == 175) {
            this.context.setAttribute(string, object);
        } else {
            super.setAttribute(string, object, n);
        }
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public Writer getWriter() {
        if (this.writer == null) {
            try {
                this.writer = this.response.getWriter();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.writer == null) {
            try {
                this.writer = new PhpScriptWriter((OutputStream)this.response.getOutputStream());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (!(this.writer instanceof PhpScriptWriter)) {
            this.setWriter(this.writer);
        }
        return this.writer;
    }

    public Writer getErrorWriter() {
        if (this.errorWriter == null) {
            this.errorWriter = PhpScriptLogWriter.getWriter((ILogger)new Logger(this.context));
        }
        if (!(this.errorWriter instanceof PhpScriptWriter)) {
            this.setErrorWriter(this.errorWriter);
        }
        return this.errorWriter;
    }

    public Reader getReader() {
        if (this.reader == null) {
            try {
                this.reader = this.request.getReader();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return this.reader;
    }

    public Object init(Object object) throws Exception {
        return Context.getManageable((Object)object);
    }

    public void onShutdown(Object object) {
        php.java.servlet.Context.handleManaged(object, this.context);
    }

    public Object getHttpServletResponse() {
        return this.getAttribute("php.java.servlet.HttpServletResponse");
    }

    public Object getHttpServletRequest() {
        return this.getAttribute("php.java.servlet.HttpServletRequest");
    }

    public Object getServlet() {
        return this.getAttribute("php.java.servlet.Servlet");
    }

    public Object getServletConfig() {
        return this.getAttribute("php.java.servlet.ServletConfig");
    }

    public Object getServletContext() {
        return this.getAttribute("php.java.servlet.ServletContext");
    }

    public String getRealPath(String string) {
        return php.java.servlet.Context.getRealPathInternal(string, this.context);
    }
}

