/*
 * Decompiled with CFR 0.152.
 */
package php.java.script.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import javax.servlet.ServletContext;
import php.java.script.servlet.IScriptReader;
import php.java.servlet.CGIServlet;

final class ScriptFileReader
extends Reader {
    private String path;
    private IScriptReader reader;
    private Reader realReader;

    ScriptFileReader(String string, IScriptReader iScriptReader) throws IOException {
        this.path = string;
        this.reader = iScriptReader;
    }

    ScriptFileReader(String string) throws IOException {
        this.path = string;
        this.reader = null;
    }

    public String getResourcePath(ServletContext servletContext) throws IOException {
        this.init(CGIServlet.getRealPath(servletContext, this.path));
        return this.path;
    }

    private static void createFile(File file, IScriptReader iScriptReader) throws IOException {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        char[] cArray = new char[8192];
        while ((n = iScriptReader.read(cArray, 0, cArray.length)) > 0) {
            outputStreamWriter.write(cArray, 0, n);
        }
        outputStreamWriter.close();
    }

    private boolean readerIsClosed() {
        return this.reader.isClosed();
    }

    public void init(String string) throws IOException {
        File file = new File(string);
        if (this.reader != null && !this.readerIsClosed()) {
            ScriptFileReader.createFile(file, this.reader);
            this.reader.close();
            this.reader = null;
        }
        this.realReader = new FileReader(file);
    }

    public void close() throws IOException {
        if (this.realReader != null) {
            this.realReader.close();
            this.realReader = null;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        return this.realReader.read(cArray, n, n2);
    }
}

