/*
 * Decompiled with CFR 0.152.
 */
package php.java.script.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.NotImplementedException;
import php.java.bridge.Util;
import php.java.script.IScriptReader;

public class ServletReader
extends Reader
implements IScriptReader {
    final RequestDispatcher dispatcher;
    final URL url;
    final HttpServletRequest req;
    final String servletPath;

    public ServletReader(ServletContext servletContext, String string, URL uRL, HttpServletRequest httpServletRequest) throws IOException {
        this.url = uRL;
        this.req = httpServletRequest;
        this.dispatcher = httpServletRequest.getRequestDispatcher(string);
        if (Util.logLevel > 5) {
            Util.logDebug((String)("creating request dispatcher for: " + string));
        }
        this.servletPath = string;
    }

    public void read(final Map map, final OutputStream outputStream, final Util.HeaderParser headerParser) throws IOException {
        HttpServletRequestWrapper httpServletRequestWrapper = new HttpServletRequestWrapper(this.req){

            public String getHeader(String string) {
                return String.valueOf(map.get(string));
            }

            public String getServletPath() {
                return ServletReader.this.servletPath;
            }

            public Enumeration getHeaderNames() {
                return Collections.enumeration(Arrays.asList(IScriptReader.HEADER));
            }

            public Enumeration getHeaders(String string) {
                return Collections.enumeration(Arrays.asList(this.getHeader(string)));
            }

            public int getIntHeader(String string) {
                return Integer.parseInt(this.getHeader(string));
            }

            public String getMethod() {
                return "GET";
            }

            public String getPathInfo() {
                return ServletReader.this.url.getPath();
            }

            public String getPathTranslated() {
                return null;
            }

            public String getQueryString() {
                return null;
            }

            public String getRequestURI() {
                try {
                    return ServletReader.this.url.toURI().toASCIIString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                    return null;
                }
            }

            public StringBuffer getRequestURL() {
                return new StringBuffer(ServletReader.this.url.toExternalForm());
            }

            public String getProtocol() {
                return ServletReader.this.url.getProtocol();
            }

            public String getRemoteAddr() {
                return ServletReader.this.req.getLocalAddr();
            }

            public String getRemoteHost() {
                return ServletReader.this.req.getLocalName();
            }

            public int getRemotePort() {
                return ServletReader.this.req.getLocalPort();
            }

            public String getScheme() {
                return ServletReader.this.url.getProtocol();
            }
        };
        HttpServletResponse httpServletResponse = new HttpServletResponse(){

            public void addCookie(Cookie cookie) {
                headerParser.addHeader("Set-Cookie", cookie.toString());
            }

            public void addDateHeader(String string, long l) {
                throw new NotImplementedException();
            }

            public void addHeader(String string, String string2) {
                headerParser.addHeader(string, string2);
            }

            public void addIntHeader(String string, int n) {
                throw new NotImplementedException();
            }

            public boolean containsHeader(String string) {
                throw new NotImplementedException();
            }

            public String encodeRedirectURL(String string) {
                throw new NotImplementedException();
            }

            public String encodeRedirectUrl(String string) {
                throw new NotImplementedException();
            }

            public String encodeURL(String string) {
                throw new NotImplementedException();
            }

            public String encodeUrl(String string) {
                throw new NotImplementedException();
            }

            public void sendError(int n) throws IOException {
                headerParser.addHeader("Status", String.valueOf(n));
            }

            public void sendError(int n, String string) throws IOException {
                headerParser.addHeader("Status", String.valueOf(n));
            }

            public void sendRedirect(String string) throws IOException {
                throw new NotImplementedException();
            }

            public void setDateHeader(String string, long l) {
                throw new NotImplementedException();
            }

            public void setHeader(String string, String string2) {
                throw new NotImplementedException();
            }

            public void setIntHeader(String string, int n) {
                throw new NotImplementedException();
            }

            public void setStatus(int n) {
                headerParser.addHeader("Status", String.valueOf(n));
            }

            public void setStatus(int n, String string) {
                headerParser.addHeader("Status", String.valueOf(n));
            }

            public void flushBuffer() throws IOException {
                throw new NotImplementedException();
            }

            public int getBufferSize() {
                throw new NotImplementedException();
            }

            public String getCharacterEncoding() {
                throw new NotImplementedException();
            }

            public String getContentType() {
                throw new NotImplementedException();
            }

            public Locale getLocale() {
                throw new NotImplementedException();
            }

            public ServletOutputStream getOutputStream() throws IOException {
                return new ServletOutputStream(){

                    public void write(byte[] byArray, int n, int n2) throws IOException {
                        outputStream.write(byArray, n, n2);
                    }

                    public void write(int n) throws IOException {
                        throw new NotImplementedException();
                    }
                };
            }

            public PrintWriter getWriter() throws IOException {
                throw new NotImplementedException();
            }

            public boolean isCommitted() {
                throw new NotImplementedException();
            }

            public void reset() {
                throw new NotImplementedException();
            }

            public void resetBuffer() {
                throw new NotImplementedException();
            }

            public void setBufferSize(int n) {
                throw new NotImplementedException();
            }

            public void setCharacterEncoding(String string) {
                throw new NotImplementedException();
            }

            public void setContentLength(int n) {
                headerParser.addHeader("Content-Length", String.valueOf(n));
            }

            public void setContentType(String string) {
                throw new NotImplementedException();
            }

            public void setLocale(Locale locale) {
                throw new NotImplementedException();
            }
        };
        try {
            this.dispatcher.include((ServletRequest)httpServletRequestWrapper, (ServletResponse)httpServletResponse);
        }
        catch (ServletException servletException) {
            IOException iOException = new IOException("include failed");
            iOException.initCause(servletException);
            throw iOException;
        }
    }

    public void close() throws IOException {
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        throw new IllegalStateException("Use servletReader.read(Hashtable, OutputStream) or use a FileReader() instead.");
    }
}

